/*
 * Decompiled with CFR 0.152.
 */
package jebl.evolution.align;

import jebl.evolution.align.Align;
import jebl.evolution.align.Output;
import jebl.evolution.align.Traceback;
import jebl.evolution.align.TracebackAffine;
import jebl.evolution.align.scores.Scores;

abstract class AlignAffine
extends Align {
    float e;
    float[][][] F = null;
    TracebackAffine[][][] B = null;
    private int oldn = 0;
    private int oldm = 0;

    public AlignAffine(Scores sub, float openGapPenalty, float extendGapPenalty) {
        super(sub, openGapPenalty);
        this.setGapExtend(extendGapPenalty);
    }

    public abstract void doAlignment(String var1, String var2);

    public void prepareAlignment(String sq1, String sq2) {
        this.n = sq1.length();
        this.m = sq2.length();
        this.seq1 = sq1;
        this.seq2 = sq2;
        if (this.F == null) {
            this.F = new float[3][this.n + 1][this.m + 1];
            this.B = new TracebackAffine[3][this.n + 1][this.m + 1];
            for (int k = 0; k < 3; ++k) {
                for (int i = 0; i < this.n + 1; ++i) {
                    for (int j = 0; j < this.m + 1; ++j) {
                        this.B[k][i][j] = new TracebackAffine(0, 0, 0);
                    }
                }
            }
            this.oldn = this.n;
            this.oldm = this.m;
        } else if (sq1.length() > this.oldn || sq2.length() > this.oldm) {
            int extram = 5;
            int extran = 5;
            this.F = new float[3][this.n + 1 + extran][this.m + 1 + extram];
            this.B = new TracebackAffine[3][this.n + 1 + extran][this.m + 1 + extram];
            for (int k = 0; k < 3; ++k) {
                for (int i = 0; i < this.n + 1 + extran; ++i) {
                    for (int j = 0; j < this.m + 1 + extram; ++j) {
                        this.B[k][i][j] = new TracebackAffine(0, 0, 0);
                    }
                }
            }
            this.oldn = this.n + extran;
            this.oldm = this.m + extram;
        }
    }

    public void setGapExtend(float e) {
        this.e = e;
    }

    public Traceback next(Traceback tb) {
        TracebackAffine tb3 = (TracebackAffine)tb;
        if (tb3.i + tb3.j + this.B[tb3.k][tb3.i][tb3.j].i + this.B[tb3.k][tb3.i][tb3.j].j == 0) {
            return null;
        }
        return this.B[tb3.k][tb3.i][tb3.j];
    }

    public float getScore() {
        return this.F[((TracebackAffine)this.B0).k][this.B0.i][this.B0.j];
    }

    public void printf(Output out) {
        for (int k = 0; k < 3; ++k) {
            out.println("F[" + k + "]:");
            for (int j = 0; j <= this.m; ++j) {
                for (int i = 0; i < this.F[k].length; ++i) {
                    out.print(AlignAffine.padLeft(this.formatScore(this.F[k][i][j]), 5));
                }
                out.println();
            }
        }
    }
}

