/*
 * Decompiled with CFR 0.152.
 */
package dr.evomodel.operators;

import dr.evolution.tree.NodeRef;
import dr.evolution.tree.Tree;
import dr.evolution.tree.TreeUtils;
import dr.evomodel.speciation.SpeciesBindings;
import dr.evomodel.speciation.SpeciesTreeModel;
import dr.inference.model.Parameter;
import dr.inference.operators.SimpleMCMCOperator;
import dr.math.MathUtils;
import java.util.Arrays;
import jebl.util.FixedBitSet;

@Deprecated
public class TreeNodeSlide
extends SimpleMCMCOperator {
    private final SpeciesTreeModel tree;
    private final SpeciesBindings species;
    private final int[] preOrderIndexBefore;
    private final int[] preOrderIndexAfter;
    private final boolean verbose = false;

    public TreeNodeSlide(SpeciesTreeModel speciesTreeModel, SpeciesBindings speciesBindings, double d) {
        this.tree = speciesTreeModel;
        this.species = speciesBindings;
        this.preOrderIndexBefore = new int[speciesTreeModel.getNodeCount()];
        Arrays.fill(this.preOrderIndexBefore, -1);
        this.preOrderIndexAfter = new int[speciesTreeModel.getNodeCount()];
        Arrays.fill(this.preOrderIndexAfter, -1);
        this.setWeight(d);
    }

    public String getPerformanceSuggestion() {
        return "none";
    }

    @Override
    public String getOperatorName() {
        return "nodeReHeight(" + this.tree.getId() + "," + this.species.getId() + ")";
    }

    @Override
    public double doOperation() {
        this.operateOneNode(0.0);
        return 0.0;
    }

    private void ptree(SpeciesTreeModel speciesTreeModel, NodeRef[] nodeRefArray, int[] nArray) {
        System.err.println(TreeUtils.uniqueNewick(speciesTreeModel, speciesTreeModel.getRoot()));
        System.err.println(TreeUtils.newick(speciesTreeModel));
        this.ptreenode(speciesTreeModel, speciesTreeModel.getRoot(), nArray, "");
        for (NodeRef nodeRef : nodeRefArray) {
            System.err.print(nodeRef.getNumber() + " ");
        }
        System.err.println();
    }

    private void ptreenode(SpeciesTreeModel speciesTreeModel, NodeRef nodeRef, int[] nArray, String string) {
        System.err.print(string + nodeRef.getNumber() + " " + speciesTreeModel.getNodeHeight(nodeRef) + " " + (nodeRef != speciesTreeModel.getRoot() ? speciesTreeModel.getParent(nodeRef).getNumber() : -1) + " ");
        if (!speciesTreeModel.isExternal(nodeRef)) {
            System.err.print("(" + speciesTreeModel.getChild(nodeRef, 0).getNumber() + " " + speciesTreeModel.getChild(nodeRef, 1).getNumber() + ")");
            int n = speciesTreeModel.getExternalNodeCount() + 2 * nArray[nodeRef.getNumber()];
            System.err.println(" [" + speciesTreeModel.sppSplitPopulations.getParameterValue(n) + "," + speciesTreeModel.sppSplitPopulations.getParameterValue(n + 1) + "] ");
            this.ptreenode(speciesTreeModel, speciesTreeModel.getChild(nodeRef, 0), nArray, string + "  ");
            this.ptreenode(speciesTreeModel, speciesTreeModel.getChild(nodeRef, 1), nArray, string + "  ");
        } else {
            System.err.println(speciesTreeModel.getNodeTaxon(nodeRef).toString());
        }
    }

    public void operateOneNode(double d) {
        double d2;
        int n;
        int n2 = this.tree.getExternalNodeCount();
        assert (n2 == this.species.nSpecies());
        NodeRef[] nodeRefArray = new NodeRef[2 * n2 - 1];
        boolean[] blArray = new boolean[n2 - 1];
        TreeNodeSlide.mauCanonical(this.tree, nodeRefArray, blArray);
        int n3 = MathUtils.nextInt(n2 - 1);
        FixedBitSet fixedBitSet = new FixedBitSet(n2);
        FixedBitSet fixedBitSet2 = new FixedBitSet(n2);
        for (n = 0; n < 2 * n3 + 1; n += 2) {
            fixedBitSet.set(this.tree.speciesIndex(nodeRefArray[n]));
        }
        for (n = 2 * (n3 + 1); n < 2 * n2; n += 2) {
            fixedBitSet2.set(this.tree.speciesIndex(nodeRefArray[n]));
        }
        if (d > 0.0) {
            d2 = this.tree.getNodeHeight(nodeRefArray[2 * n3 + 1]) * d;
        } else {
            double d3 = this.species.speciationUpperBound(fixedBitSet, fixedBitSet2);
            d2 = MathUtils.nextDouble() * d3;
        }
        this.tree.beginTreeEdit();
        this.tree.setPreorderIndices(this.preOrderIndexBefore);
        NodeRef nodeRef = nodeRefArray[2 * n3 + 1];
        this.tree.setNodeHeight(nodeRef, d2);
        TreeNodeSlide.mauReconstruct(this.tree, nodeRefArray, blArray);
        this.tree.setPreorderIndices(this.preOrderIndexAfter);
        double[] dArray = null;
        for (int i = 0; i < this.preOrderIndexBefore.length; ++i) {
            int n4;
            int n5 = this.preOrderIndexBefore[i];
            if (n5 < 0 || (n4 = this.preOrderIndexAfter[i]) == n5) continue;
            Parameter parameter = this.tree.sppSplitPopulations;
            if (dArray == null) {
                dArray = parameter.getParameterValues();
            }
            if (this.tree.constPopulation()) {
                parameter.setParameterValue(n2 + n4, dArray[n2 + n5]);
                continue;
            }
            for (int j = 0; j < 2; ++j) {
                parameter.setParameterValue(n2 + 2 * n4 + j, dArray[n2 + 2 * n5 + j]);
            }
        }
        this.tree.endTreeEdit();
    }

    private int getSide(int n, NodeRef nodeRef, NodeRef[] nodeRefArray, boolean[] blArray) {
        for (int i = 1; i < nodeRefArray.length; i += 2) {
            if (nodeRefArray[i] != nodeRef) continue;
            return i < 2 * n + 1 ? -1 : 1;
        }
        assert (false);
        return 0;
    }

    private int getIndexOf(NodeRef nodeRef, NodeRef[] nodeRefArray) {
        for (int i = 1; i < nodeRefArray.length; i += 2) {
            if (nodeRefArray[i] != nodeRef) continue;
            return (i - 1) / 2;
        }
        assert (false);
        return -1;
    }

    private void swapPops(NodeRef nodeRef, int n, NodeRef nodeRef2, int n2, int[] nArray) {
        int n3 = this.tree.getExternalNodeCount();
        int n4 = n3 + 2 * nArray[nodeRef.getNumber()] + n;
        int n5 = n3 + 2 * nArray[nodeRef2.getNumber()] + n2;
        double d = this.tree.sppSplitPopulations.getParameterValue(n4);
        double d2 = this.tree.sppSplitPopulations.getParameterValue(n5);
        this.tree.sppSplitPopulations.setParameterValue(n4, d2);
        this.tree.sppSplitPopulations.setParameterValue(n5, d);
    }

    private static void mauCanonical(Tree tree, NodeRef[] nodeRefArray, boolean[] blArray) {
        TreeNodeSlide.mauCanonicalSub(tree, tree.getRoot(), 0, nodeRefArray, blArray);
    }

    private static int mauCanonicalSub(Tree tree, NodeRef nodeRef, int n, NodeRef[] nodeRefArray, boolean[] blArray) {
        if (tree.isExternal(nodeRef)) {
            nodeRefArray[n] = nodeRef;
            assert ((n & 1) == 0);
            return n + 1;
        }
        boolean bl = MathUtils.nextBoolean();
        int n2 = TreeNodeSlide.mauCanonicalSub(tree, tree.getChild(nodeRef, bl ? 1 : 0), n, nodeRefArray, blArray);
        nodeRefArray[n2] = nodeRef;
        assert ((n2 & 1) == 1);
        blArray[(n2 - 1) / 2] = bl;
        n2 = TreeNodeSlide.mauCanonicalSub(tree, tree.getChild(nodeRef, bl ? 0 : 1), n2 + 1, nodeRefArray, blArray);
        return n2;
    }

    private static void mauReconstruct(SpeciesTreeModel speciesTreeModel, NodeRef[] nodeRefArray, boolean[] blArray) {
        NodeRef nodeRef = TreeNodeSlide.mauReconstructSub(speciesTreeModel, 0, blArray.length, nodeRefArray, blArray);
        if (speciesTreeModel.getRoot() != nodeRef) {
            speciesTreeModel.setRoot(nodeRef);
        }
    }

    private static NodeRef mauReconstructSub(SpeciesTreeModel speciesTreeModel, int n, int n2, NodeRef[] nodeRefArray, boolean[] blArray) {
        if (n == n2) {
            return nodeRefArray[2 * n];
        }
        int n3 = -1;
        double d = -1.0;
        for (int i = n; i < n2; ++i) {
            double d2 = speciesTreeModel.getNodeHeight(nodeRefArray[2 * i + 1]);
            if (!(d < d2)) continue;
            d = d2;
            n3 = i;
        }
        NodeRef nodeRef = nodeRefArray[2 * n3 + 1];
        NodeRef nodeRef2 = speciesTreeModel.getChild(nodeRef, 0);
        NodeRef nodeRef3 = speciesTreeModel.getChild(nodeRef, 1);
        NodeRef nodeRef4 = TreeNodeSlide.mauReconstructSub(speciesTreeModel, n, n3, nodeRefArray, blArray);
        NodeRef nodeRef5 = TreeNodeSlide.mauReconstructSub(speciesTreeModel, n3 + 1, n2, nodeRefArray, blArray);
        if (blArray[n3]) {
            NodeRef nodeRef6 = nodeRef4;
            nodeRef4 = nodeRef5;
            nodeRef5 = nodeRef6;
        }
        if (nodeRef2 != nodeRef4) {
            speciesTreeModel.replaceChild(nodeRef, nodeRef2, nodeRef4);
        }
        if (nodeRef3 != nodeRef5) {
            speciesTreeModel.replaceChild(nodeRef, nodeRef3, nodeRef5);
        }
        return nodeRef;
    }
}

