/*
 * Decompiled with CFR 0.152.
 */
package no.uib.cipr.matrix;

import java.util.Iterator;
import no.uib.cipr.matrix.AbstractDenseMatrix;
import no.uib.cipr.matrix.AbstractMatrix;
import no.uib.cipr.matrix.BLASkernel;
import no.uib.cipr.matrix.DenseMatrix;
import no.uib.cipr.matrix.DenseVector;
import no.uib.cipr.matrix.Interface;
import no.uib.cipr.matrix.Matrix;
import no.uib.cipr.matrix.MatrixEntry;
import no.uib.cipr.matrix.MatrixSingularException;
import no.uib.cipr.matrix.Vector;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
abstract class AbstractTriangDenseMatrix
extends AbstractDenseMatrix {
    BLASkernel.UpLo uplo;
    BLASkernel.Diag diag;
    int ld;

    AbstractTriangDenseMatrix(int n, BLASkernel.UpLo uplo, BLASkernel.Diag diag) {
        super(n, n);
        this.ld = n;
        this.uplo = uplo;
        this.diag = diag;
    }

    AbstractTriangDenseMatrix(Matrix A, BLASkernel.UpLo uplo, BLASkernel.Diag diag) {
        this(A, Math.min(A.numRows(), A.numColumns()), uplo, diag);
    }

    AbstractTriangDenseMatrix(Matrix A, boolean deep, BLASkernel.UpLo uplo, BLASkernel.Diag diag) {
        this(A, Math.min(A.numRows(), A.numColumns()), deep, uplo, diag);
    }

    AbstractTriangDenseMatrix(Matrix A, int k, BLASkernel.UpLo uplo, BLASkernel.Diag diag) {
        this(A, k, true, uplo, diag);
    }

    AbstractTriangDenseMatrix(Matrix A, int k, boolean deep, BLASkernel.UpLo uplo, BLASkernel.Diag diag) {
        super(A, deep);
        if (deep && !A.isSquare()) {
            throw new IllegalArgumentException("deep && !A.isSquare()");
        }
        this.ld = A.numRows();
        this.numRows = this.numColumns = k;
        this.uplo = uplo;
        this.diag = diag;
    }

    @Override
    public Vector mult(double alpha, Vector x, Vector y) {
        if (!(y instanceof DenseVector)) {
            return super.mult(alpha, x, y);
        }
        this.checkMultAdd(x, y);
        double[] yd = ((DenseVector)y).getData();
        y.set(alpha, x);
        Interface.blas().trmv(this.uplo, BLASkernel.Transpose.NoTranspose, this.diag, this.numRows, this.data, Math.max(1, this.ld), yd);
        return y;
    }

    @Override
    public Vector transMult(double alpha, Vector x, Vector y) {
        if (!(y instanceof DenseVector)) {
            return super.transMult(alpha, x, y);
        }
        this.checkTransMultAdd(x, y);
        double[] yd = ((DenseVector)y).getData();
        y.set(alpha, x);
        Interface.blas().trmv(this.uplo, BLASkernel.Transpose.Transpose, this.diag, this.numRows, this.data, Math.max(1, this.ld), yd);
        return y;
    }

    @Override
    public Matrix mult(double alpha, Matrix B, Matrix C) {
        if (!(C instanceof DenseMatrix)) {
            return super.mult(alpha, B, C);
        }
        this.checkMultAdd(B, C);
        double[] Cd = ((DenseMatrix)C).getData();
        C.set(B);
        Interface.blas().trmm(BLASkernel.Side.Left, this.uplo, BLASkernel.Transpose.NoTranspose, this.diag, C.numRows(), C.numColumns(), alpha, this.data, Math.max(1, this.ld), Cd, Math.max(1, C.numRows()));
        return C;
    }

    @Override
    public Matrix transAmult(double alpha, Matrix B, Matrix C) {
        if (!(C instanceof DenseMatrix)) {
            return super.transAmult(alpha, B, C);
        }
        this.checkTransAmultAdd(B, C);
        double[] Cd = ((DenseMatrix)C).getData();
        C.set(B);
        Interface.blas().trmm(BLASkernel.Side.Left, this.uplo, BLASkernel.Transpose.Transpose, this.diag, C.numRows(), C.numColumns(), alpha, this.data, Math.max(1, this.ld), Cd, Math.max(1, C.numRows()));
        return C;
    }

    @Override
    public Matrix solve(Matrix B, Matrix X) {
        return this.solve(B, X, BLASkernel.Transpose.NoTranspose);
    }

    @Override
    public Vector solve(Vector b, Vector x) {
        DenseMatrix B = new DenseMatrix(b, false);
        DenseMatrix X = new DenseMatrix(x, false);
        this.solve(B, X);
        return x;
    }

    @Override
    public Matrix transSolve(Matrix B, Matrix X) {
        return this.solve(B, X, BLASkernel.Transpose.Transpose);
    }

    @Override
    public Vector transSolve(Vector b, Vector x) {
        DenseMatrix B = new DenseMatrix(b, false);
        DenseMatrix X = new DenseMatrix(x, false);
        this.transSolve(B, X);
        return x;
    }

    Matrix solve(Matrix B, Matrix X, BLASkernel.Transpose trans) {
        if (!(X instanceof DenseMatrix)) {
            throw new UnsupportedOperationException("X must be a DenseMatrix");
        }
        if (B.numRows() < this.numRows) {
            throw new IllegalArgumentException("B.numRows() < A.numRows()");
        }
        if (B.numColumns() != X.numColumns()) {
            throw new IllegalArgumentException("B.numColumns() != X.numColumns()");
        }
        if (X.numRows() < this.numRows) {
            throw new IllegalArgumentException("X.numRows() < A.numRows()");
        }
        double[] Xd = ((DenseMatrix)X).getData();
        X.set(B);
        int info = Interface.lapack().trtrs(this.uplo, trans, this.diag, this.numRows, X.numColumns(), this.data, Math.max(1, this.ld), Xd);
        if (info > 0) {
            throw new MatrixSingularException();
        }
        if (info < 0) {
            throw new IllegalArgumentException();
        }
        return X;
    }

    @Override
    int getIndex(int row, int column) {
        this.check(row, column);
        return row + column * Math.max(this.ld, this.numRows);
    }

    @Override
    public Iterator<MatrixEntry> iterator() {
        return new TriangDenseMatrixIterator();
    }

    private class TriangDenseMatrixIterator
    extends AbstractMatrix.RefMatrixIterator {
        private TriangDenseMatrixIterator() {
        }

        public MatrixEntry next() {
            this.entry.update(this.row, this.column);
            if (AbstractTriangDenseMatrix.this.uplo == BLASkernel.UpLo.Lower) {
                if (this.row < AbstractTriangDenseMatrix.this.numRows - 1) {
                    ++this.row;
                } else {
                    ++this.column;
                    this.row = this.column;
                }
            } else if (this.row < this.column) {
                ++this.row;
            } else {
                ++this.column;
                this.row = 0;
            }
            return this.entry;
        }
    }
}

