/*
 * Decompiled with CFR 0.152.
 */
package dr.evolution.wrightfisher;

import dr.evolution.datatype.AminoAcids;
import dr.evolution.datatype.Codons;
import dr.evolution.datatype.GeneticCode;
import dr.evolution.wrightfisher.FitnessFunction;
import dr.math.MathUtils;
import dr.math.distributions.GammaDistribution;

public class CodonFitnessFunction
extends FitnessFunction {
    int stateSize = 20;
    double[][] fitness;
    byte[] fittest = null;
    GeneticCode geneticCode = GeneticCode.UNIVERSAL;
    Codons codons = Codons.UNIVERSAL;

    public CodonFitnessFunction(int n, double d, double d2, double d3) {
        GammaDistribution gammaDistribution = new GammaDistribution(d2, d);
        this.stateSize = 20;
        this.fitness = new double[n][this.stateSize];
        byte[] byArray = new byte[n];
        this.fittest = this.getFittestGenome(n, byArray);
        for (int i = 0; i < n; ++i) {
            this.fitness[i][byArray[i]] = 1.0;
            for (int j = 0; j < this.stateSize; ++j) {
                if (j == byArray[i]) continue;
                if (MathUtils.nextDouble() < d3) {
                    this.fitness[i][j] = 0.0;
                    continue;
                }
                double d4 = (double)Math.round(MathUtils.nextDouble() * 1000.0) / 1000.0;
                while (d4 <= 0.0 || d4 >= 1.0) {
                    d4 = (double)Math.round(MathUtils.nextDouble() * 1000.0) / 1000.0;
                }
                this.fitness[i][j] = Math.max(0.0, 1.0 - gammaDistribution.quantile(d4));
            }
        }
    }

    @Override
    public final double getFitness(byte[] byArray) {
        double d = 1.0;
        int n = 0;
        for (int i = 0; i < byArray.length; i += 3) {
            int n2 = byArray[i] * 16 + byArray[i + 1] * 4 + byArray[i + 2];
            int n3 = this.geneticCode.getAminoAcidState(n2);
            if (n3 < 0 || n3 >= this.stateSize) {
                return 0.0;
            }
            if ((d *= this.fitness[n][n3]) == 0.0) {
                return 0.0;
            }
            ++n;
        }
        return d;
    }

    @Override
    public double getFitnessFactor(int n, byte by, byte by2) {
        throw new RuntimeException();
    }

    @Override
    public final double[][] getFitnessTable() {
        for (int i = 0; i < this.fitness[0].length; ++i) {
            for (int j = 0; j < this.fitness.length; ++j) {
                System.out.print((double)Math.round(this.fitness[j][i] * 1000.0) / 1000.0 + "\t");
            }
            System.out.println();
        }
        return this.fitness;
    }

    public byte[] getFittestGenome(int n, byte[] byArray) {
        byte[] byArray2 = new byte[n * 3];
        for (int i = 0; i < n; ++i) {
            int n2 = this.stateSize;
            int n3 = MathUtils.nextInt(4);
            int n4 = MathUtils.nextInt(4);
            int n5 = MathUtils.nextInt(4);
            int n6 = n3 * 16 + n4 * 4 + n5;
            n2 = this.geneticCode.getAminoAcidState(n6);
            while (n2 >= this.stateSize) {
                n3 = MathUtils.nextInt(4);
                n4 = MathUtils.nextInt(4);
                n5 = MathUtils.nextInt(4);
                n6 = n3 * 16 + n4 * 4 + n5;
                n2 = this.geneticCode.getAminoAcidState(n6);
            }
            System.out.print(AminoAcids.INSTANCE.getChar(n2));
            byArray2[i * 3] = (byte)n3;
            byArray2[i * 3 + 1] = (byte)n4;
            byArray2[i * 3 + 2] = (byte)n5;
            byArray[i] = (byte)n2;
        }
        System.out.println();
        return byArray2;
    }

    @Override
    public void initializeToFittest(byte[] byArray) {
        System.arraycopy(this.fittest, 0, byArray, 0, this.fittest.length);
    }
}

