library("data.table")
library("wyz.code.offensiveProgramming")
library("wyz.code.rdoc")

source_package_name <- target_package_name <- 'wyz.code.rdoc'

gc <- GenerationContext(targetFolder_s_1 = 'inst/man-regenerated',
                        overwrite_b_1 = TRUE,
                        verbosity_b_1 = FALSE, useMarkers_b_1 = FALSE)

beautifier <- beautify()

ex_class <- ex_fun <- list(
  seealso = sentensize(paste('class', beautifier$codelink('InputContext'),
                             'class', beautifier$codelink('ProcessingContext'),
                             'class', beautifier$codelink('GenerationContext'),
                             'and class',  beautifier$codelink('ManualPageBuilder'))),
  keyword = 'documentation',
  concept = 'documentation generation'
)

ex_fun$seealso <- NULL

options('rdhoc_hack' = TRUE)

dt <- wyz.code.rdoc::packageFunctionsInformation()
fn <- dt[nature == 'EXPORTED' & category != "DATA"]$name

color <- Colorizer()

objs <- list(
  InputContext = InputContext(color, packageName_s_1 = target_package_name),
  GenerationContext = gc,
  ProcessingContext = ProcessingContext(),
  ManualPageBuilder = NULL
)

objs$ManualPageBuilder <- ManualPageBuilder(objs$InputContext, objs$ProcessingContext,
                                            objs$GenerationContext)

res <- lapply(fn, function(e) {
  is_class <- grepl('^[A-Z]', e, perl = TRUE)

  cat(color$other(paste('processing', e)), '\n')
  if (is_class) {
      produceAllManualPagesFromObject(objs[[e]], ProcessingContext(ex_class),
                                      gc, packageName_s_1 = target_package_name)
  } else {
    produceManualPage(InputContext(NULL, e, packageName_s_1 = target_package_name),
                      ProcessingContext(ex_fun), gc)
  }
})

rf <- sapply(c('generateEnc', 'generateParagraph',
               'generateParagraph2NL', 'generateParagraphCR'), function(e) {
  ic <- InputContext(NULL, e, packageName_s_1 = target_package_name)
  produceManualPage(ic, pc, gc)
})

pc <- ProcessingContext(
  extraneous_l = list(
    description = "Data set to be used as example for demo purpose.",
    source = 'Data set generated by NEONIRA',
    concept = 'documentation generation'
  )
)

# 1. file dummy.R
ic <- InputContext(dummy,
                   packageName_s_1 = target_package_name,
                   dataFilename_s_1 = 'dummy.R')

r1 <- produceManualPage(ic, pc, gc)

# 2. file family.csv
ic <- InputContext(family,
                   packageName_s_1 = target_package_name,
                   dataFilename_s_1 = 'family.csv')
r2 <- produceManualPage(ic, pc, gc)

