#' The function to filter the first two rows of column y
#'
#' @param data - dataframe
#'
#' @return dataframe with filtered values
#' @export
#'
#' @importFrom magrittr %>%
#' @examples
#' library(dplyr)
#' library(magrittr)
#'
#' df <- data.frame(x = 1:4, y = 1:4)
#'
#' filtered_y <- filter_first_two_rows_y(df)
#' print(filtered_y)


filter_first_two_rows_y <- function(data) {
  y <- NULL
  dplyr::filter(data, dplyr::row_number() <= 2) %>% dplyr::select(y)
}


