/*
 * Decompiled with CFR 0.152.
 */
package org.chocosolver.solver.constraints.binary;

import org.chocosolver.solver.ICause;
import org.chocosolver.solver.Priority;
import org.chocosolver.solver.constraints.Propagator;
import org.chocosolver.solver.constraints.PropagatorPriority;
import org.chocosolver.solver.exception.ContradictionException;
import org.chocosolver.solver.learn.ExplanationForSignedClause;
import org.chocosolver.solver.variables.IntVar;
import org.chocosolver.solver.variables.Variable;
import org.chocosolver.solver.variables.events.IntEventType;
import org.chocosolver.util.ESat;
import org.chocosolver.util.objects.setDataStructures.iterable.IntIterableRangeSet;

public final class PropGreaterOrEqualX_Y
extends Propagator<IntVar> {
    private final IntVar x;
    private final IntVar y;

    public PropGreaterOrEqualX_Y(IntVar[] vars) {
        super((Variable[])vars, (Priority)PropagatorPriority.BINARY, true);
        this.x = vars[0];
        this.y = vars[1];
    }

    @Override
    public int getPropagationConditions(int vIdx) {
        if (vIdx == 0) {
            return IntEventType.combine(IntEventType.INSTANTIATE, IntEventType.DECUPP);
        }
        return IntEventType.combine(IntEventType.INSTANTIATE, IntEventType.INCLOW);
    }

    @Override
    public void propagate(int evtmask) throws ContradictionException {
        this.x.updateLowerBound(this.y.getLB(), (ICause)this);
        this.y.updateUpperBound(this.x.getUB(), (ICause)this);
        if (this.x.getLB() >= this.y.getUB()) {
            this.setPassive();
        }
    }

    @Override
    public void propagate(int varIdx, int mask) throws ContradictionException {
        if (varIdx == 0) {
            this.y.updateUpperBound(this.x.getUB(), (ICause)this);
        } else {
            this.x.updateLowerBound(this.y.getLB(), (ICause)this);
        }
        if (this.x.getLB() >= this.y.getUB()) {
            this.setPassive();
        }
    }

    @Override
    public ESat isEntailed() {
        if (this.x.getUB() < this.y.getLB()) {
            return ESat.FALSE;
        }
        if (this.x.getLB() >= this.y.getUB()) {
            return ESat.TRUE;
        }
        return ESat.UNDEFINED;
    }

    @Override
    public void explain(int p, ExplanationForSignedClause explanation) {
        if (explanation.readVar(p) == ((IntVar[])this.vars)[0]) {
            int m = explanation.readDom(((IntVar[])this.vars)[1]).min();
            IntIterableRangeSet set = explanation.complement(((IntVar[])this.vars)[1]);
            set.retainBetween(-1073741823, m - 1);
            ((IntVar[])this.vars)[0].intersectLit(m, 0x3FFFFFFF, explanation);
            ((IntVar[])this.vars)[1].unionLit(set, explanation);
        } else {
            assert (explanation.readVar(p) == ((IntVar[])this.vars)[1]);
            int m = explanation.readDom(((IntVar[])this.vars)[0]).max();
            IntIterableRangeSet set = explanation.complement(((IntVar[])this.vars)[0]);
            set.retainBetween(m + 1, 0x3FFFFFFF);
            ((IntVar[])this.vars)[0].unionLit(set, explanation);
            ((IntVar[])this.vars)[1].intersectLit(-1073741823, m, explanation);
        }
    }

    @Override
    public String toString() {
        return "prop(" + ((IntVar[])this.vars)[0].getName() + ".GEQ." + ((IntVar[])this.vars)[1].getName() + ")";
    }
}

