/*
 * Decompiled with CFR 0.152.
 */
package com.qarks.util.proxy.client;

import java.io.BufferedInputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.net.URL;
import java.net.URLConnection;
import java.util.Enumeration;
import java.util.Properties;
import javax.net.ssl.HostnameVerifier;
import javax.net.ssl.HttpsURLConnection;
import javax.net.ssl.SSLSession;
import javax.net.ssl.SSLSocketFactory;

public class ClientServletUtilities {
    private ClientServletUtilities() {
    }

    public static void disableHostnameVerifier() {
        HttpsURLConnection.setDefaultHostnameVerifier(new HostnameVerifier(){

            @Override
            public boolean verify(String string, SSLSession sSLSession) {
                return true;
            }
        });
    }

    public static Object readObjectFromServlet(SSLSocketFactory sSLSocketFactory, URL uRL, Properties properties) throws IOException {
        URLConnection uRLConnection = ClientServletUtilities.connectToServlet(sSLSocketFactory, uRL, properties);
        Object object = null;
        ObjectInputStream objectInputStream = null;
        objectInputStream = new ObjectInputStream(new BufferedInputStream(uRLConnection.getInputStream()));
        try {
            object = objectInputStream.readObject();
        }
        catch (ClassNotFoundException classNotFoundException) {
            classNotFoundException.printStackTrace();
            throw new IOException("class not found when deserializing:" + classNotFoundException.toString());
        }
        finally {
            if (objectInputStream != null) {
                objectInputStream.close();
            }
        }
        return object;
    }

    public static Object writeObjectToServlet(SSLSocketFactory sSLSocketFactory, Serializable serializable, URL uRL, Properties properties) throws IOException {
        URLConnection uRLConnection = ClientServletUtilities.connectToServlet(sSLSocketFactory, uRL, properties);
        ClientServletUtilities.applySSLSocketFactory(uRLConnection, sSLSocketFactory);
        Object object = null;
        ObjectInputStream objectInputStream = null;
        ObjectOutputStream objectOutputStream = null;
        try {
            objectOutputStream = new ObjectOutputStream(uRLConnection.getOutputStream());
            objectOutputStream.writeObject(serializable);
            objectOutputStream.flush();
            objectInputStream = new ObjectInputStream(uRLConnection.getInputStream());
            object = objectInputStream.readObject();
        }
        catch (ClassNotFoundException classNotFoundException) {
            classNotFoundException.printStackTrace();
            throw new IOException("class not found when deserializing:" + classNotFoundException.toString());
        }
        finally {
            if (objectOutputStream != null) {
                objectOutputStream.close();
            }
            if (objectInputStream != null) {
                objectInputStream.close();
            }
        }
        return object;
    }

    public static void applySSLSocketFactory(URLConnection uRLConnection, SSLSocketFactory sSLSocketFactory) {
        if (uRLConnection instanceof HttpsURLConnection && sSLSocketFactory != null) {
            ((HttpsURLConnection)uRLConnection).setSSLSocketFactory(sSLSocketFactory);
        }
    }

    public static URLConnection connectToServlet(SSLSocketFactory sSLSocketFactory, URL uRL, Properties properties) throws IOException {
        Object object;
        Object object2;
        String string = "?";
        Enumeration<Object> enumeration = properties.keys();
        while (enumeration.hasMoreElements()) {
            object2 = (String)enumeration.nextElement();
            object = properties.getProperty((String)object2);
            string = string + (String)object2 + "=" + (String)object;
            if (!enumeration.hasMoreElements()) continue;
            string = string + "&";
        }
        object2 = new URL(uRL.toString() + string);
        object = null;
        object = ((URL)object2).openConnection();
        ((URLConnection)object).setDoInput(true);
        ((URLConnection)object).setDoOutput(true);
        ((URLConnection)object).setUseCaches(false);
        ((URLConnection)object).setDefaultUseCaches(false);
        ((URLConnection)object).setRequestProperty("Content-Type", "application/octet-stream");
        return object;
    }
}

