/*
 * Decompiled with CFR 0.152.
 */
package choco.kernel.solver.search;

import choco.kernel.solver.Solution;
import choco.kernel.solver.Solver;
import choco.kernel.solver.search.AbstractGlobalSearchStrategy;
import choco.kernel.solver.search.AbstractSolutionPool;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;

class FifoSolutionPool
extends AbstractSolutionPool {
    protected final LinkedList<Solution> solutions = new LinkedList();

    protected FifoSolutionPool(AbstractGlobalSearchStrategy strategy, int capacity) {
        super(strategy, capacity);
        for (int i = 0; i < capacity; ++i) {
            this.solutions.add(new Solution(strategy.solver));
        }
    }

    @Override
    public List<Solution> asList() {
        return Collections.unmodifiableList(this.solutions.subList(0, this.size()));
    }

    @Override
    public Solution getBestSolution() {
        return this.isEmpty() ? null : this.solutions.peekFirst();
    }

    @Override
    public void recordSolution(Solver solver) {
        Solution sol = this.solutions.removeLast();
        this.strategy.writeSolution(sol);
        this.solutions.addFirst(sol);
    }

    @Override
    public void resizeCapacity(int capacity) {
        if (capacity > this.capacity) {
            for (int i = this.capacity; i < capacity; ++i) {
                this.solutions.add(new Solution(this.strategy.solver));
            }
        } else if (capacity < this.capacity) {
            for (int i = capacity; i < this.capacity; ++i) {
                this.solutions.removeLast();
            }
        }
        this.capacity = capacity;
    }
}

