/*
 * Decompiled with CFR 0.152.
 */
package umontreal.iro.lecuyer.randvarmulti;

import cern.colt.matrix.DoubleMatrix2D;
import cern.colt.matrix.impl.DenseDoubleMatrix2D;
import umontreal.iro.lecuyer.randvar.NormalGen;
import umontreal.iro.lecuyer.randvarmulti.RandomMultivariateGen;

public class MultinormalGen
extends RandomMultivariateGen {
    protected double[] mu;
    protected DoubleMatrix2D sigma;
    protected DoubleMatrix2D sqrtSigma;
    protected double[] temp;
    protected static final double MYINF = 37.54;

    private void initMN(NormalGen gen1, double[] mu, int d) {
        if (gen1 == null) {
            throw new NullPointerException("gen1 is null");
        }
        if (gen1.getMu() != 0.0) {
            throw new IllegalArgumentException("mu != 0");
        }
        if (gen1.getSigma() != 1.0) {
            throw new IllegalArgumentException("sigma != 1");
        }
        this.gen1 = gen1;
        if (mu == null) {
            this.dimension = d;
            this.mu = new double[d];
        } else {
            this.dimension = mu.length;
            this.mu = (double[])mu.clone();
        }
        this.temp = new double[this.dimension];
    }

    public MultinormalGen(NormalGen gen1, int d) {
        this.initMN(gen1, null, d);
        this.sigma = new DenseDoubleMatrix2D(d, d);
        this.sqrtSigma = new DenseDoubleMatrix2D(d, d);
        for (int i = 0; i < d; ++i) {
            this.sigma.setQuick(i, i, 1.0);
            this.sqrtSigma.setQuick(i, i, 1.0);
        }
    }

    protected MultinormalGen(NormalGen gen1, double[] mu, DoubleMatrix2D sigma) {
        this.initMN(gen1, mu, -1);
        this.sigma = sigma.copy();
    }

    protected MultinormalGen(NormalGen gen1, double[] mu, double[][] sigma) {
        this.initMN(gen1, mu, -1);
        this.sigma = new DenseDoubleMatrix2D(sigma);
    }

    public double[] getMu() {
        return this.mu;
    }

    public double getMu(int i) {
        return this.mu[i];
    }

    public void setMu(double[] mu) {
        if (mu.length != this.mu.length) {
            throw new IllegalArgumentException("Incompatible length of mean vector");
        }
        this.mu = mu;
    }

    public void setMu(int i, double mui) {
        this.mu[i] = mui;
    }

    public DoubleMatrix2D getSigma() {
        return this.sigma.copy();
    }

    public void nextPoint(double[] p) {
        int i;
        int n = this.dimension;
        for (i = 0; i < n; ++i) {
            this.temp[i] = this.gen1.nextDouble();
            if (this.temp[i] == Double.NEGATIVE_INFINITY) {
                this.temp[i] = -37.54;
            }
            if (this.temp[i] != Double.POSITIVE_INFINITY) continue;
            this.temp[i] = 37.54;
        }
        for (i = 0; i < n; ++i) {
            p[i] = 0.0;
            for (int c = 0; c < n; ++c) {
                int n2 = i;
                p[n2] = p[n2] + this.sqrtSigma.getQuick(i, c) * this.temp[c];
            }
            int n3 = i;
            p[n3] = p[n3] + this.mu[i];
        }
    }
}

