/*
 * Decompiled with CFR 0.152.
 */
package org.corehunter;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Objects;
import java.util.Random;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import org.corehunter.CoreHunterArguments;
import org.corehunter.CoreHunterExecutionMode;
import org.corehunter.CoreHunterListener;
import org.corehunter.CoreHunterObjective;
import org.corehunter.CoreHunterObjectiveType;
import org.corehunter.Range;
import org.corehunter.data.CoreHunterData;
import org.corehunter.exceptions.CoreHunterException;
import org.corehunter.objectives.AverageAccessionToNearestEntry;
import org.corehunter.objectives.AverageEntryToEntry;
import org.corehunter.objectives.AverageEntryToNearestEntry;
import org.corehunter.objectives.Coverage;
import org.corehunter.objectives.HeterozygousLoci;
import org.corehunter.objectives.Shannon;
import org.corehunter.objectives.distance.DistanceMeasure;
import org.corehunter.objectives.distance.measures.CavalliSforzaEdwardsDistance;
import org.corehunter.objectives.distance.measures.GowerDistance;
import org.corehunter.objectives.distance.measures.ModifiedRogersDistance;
import org.corehunter.objectives.distance.measures.PrecomputedDistance;
import org.jamesframework.core.problems.objectives.Objective;
import org.jamesframework.core.search.Search;
import org.jamesframework.core.search.algo.MetropolisSearch;
import org.jamesframework.core.search.algo.ParallelTempering;
import org.jamesframework.core.search.algo.RandomDescent;
import org.jamesframework.core.search.neigh.Neighbourhood;
import org.jamesframework.core.search.stopcriteria.MaxRuntime;
import org.jamesframework.core.search.stopcriteria.MaxSteps;
import org.jamesframework.core.search.stopcriteria.MaxStepsWithoutImprovement;
import org.jamesframework.core.search.stopcriteria.MaxTimeWithoutImprovement;
import org.jamesframework.core.subset.SubsetProblem;
import org.jamesframework.core.subset.SubsetSolution;
import org.jamesframework.core.subset.neigh.SingleSwapNeighbourhood;
import org.jamesframework.core.util.SetUtilities;
import org.jamesframework.ext.problems.objectives.NormalizedObjective;
import org.jamesframework.ext.problems.objectives.WeightedIndex;

public class CoreHunter {
    private static final int DEFAULT_MAX_TIME_WITHOUT_IMPROVEMENT = 10000;
    private static final int FAST_MAX_TIME_WITHOUT_IMPROVEMENT = 2000;
    private static final int PT_NUM_REPLICAS = 10;
    private static final int PT_REPLICA_STEPS = 500;
    private static final double PT_MIN_TEMP = 1.0E-8;
    private static final double PT_MAX_TEMP = 1.0E-4;
    private CoreHunterExecutionMode mode;
    private CoreHunterListener listener;
    private long timeLimit = -1L;
    private long maxTimeWithoutImprovement = -1L;
    private long maxSteps = -1L;
    private long maxStepsWithoutImprovement = -1L;
    private final Random seedGenerator;

    public CoreHunter() {
        this(CoreHunterExecutionMode.DEFAULT);
    }

    public CoreHunter(CoreHunterExecutionMode mode) {
        this.mode = mode;
        this.seedGenerator = new Random();
    }

    public List<Range<Double>> normalize(CoreHunterArguments arguments) {
        if (arguments == null) {
            throw new IllegalArgumentException("Arguments not defined!");
        }
        CoreHunterData data = arguments.getData();
        if (data == null) {
            throw new IllegalArgumentException("Dataset not defined!");
        }
        if (!arguments.isNormalized()) {
            throw new IllegalArgumentException("Normalization supposed to be disabled.");
        }
        List<CoreHunterObjective> objectives = arguments.getObjectives();
        if (objectives == null || objectives.isEmpty()) {
            throw new IllegalArgumentException("Objectives not defined!");
        }
        if (objectives.size() < 2) {
            throw new IllegalArgumentException("At least two objectives required for Pareto normalization.");
        }
        HashMap seeds = new HashMap();
        objectives.stream().forEachOrdered(obj -> seeds.put(obj, this.seedGenerator.nextLong()));
        List bestSolutions = objectives.parallelStream().map(obj -> {
            Objective<SubsetSolution, CoreHunterData> jamesObj = this.createObjective(data, (CoreHunterObjective)obj);
            Search<SubsetSolution> normSearch = this.createRandomDescent(arguments, jamesObj);
            normSearch.setRandom(new Random((Long)seeds.get(obj)));
            normSearch.run();
            return normSearch.getBestSolution();
        }).collect(Collectors.toList());
        ArrayList<Range<Double>> ranges = new ArrayList<Range<Double>>();
        for (int o = 0; o < objectives.size(); ++o) {
            double max;
            double min;
            Objective<SubsetSolution, CoreHunterData> obj2 = this.createObjective(data, objectives.get(o));
            List allValues = bestSolutions.stream().map(sol -> obj2.evaluate((SubsetSolution)sol, data).getValue()).collect(Collectors.toList());
            double bestValue = (Double)allValues.get(o);
            if (obj2.isMinimizing()) {
                min = bestValue;
                max = (Double)Collections.max(allValues);
            } else {
                max = bestValue;
                min = (Double)Collections.min(allValues);
            }
            ranges.add(new Range<Double>(min, max));
        }
        return ranges;
    }

    public SubsetSolution execute(CoreHunterArguments arguments) {
        if (arguments == null) {
            throw new IllegalArgumentException("Arguments not defined!");
        }
        if (arguments.getData() == null) {
            throw new IllegalArgumentException("Dataset not defined!");
        }
        Search<SubsetSolution> search = this.createMainSearch(arguments);
        if (this.listener != null) {
            search.addSearchListener(this.listener);
        }
        search.start();
        search.dispose();
        return search.getBestSolution();
    }

    public double evaluate(SubsetSolution sol, CoreHunterData data, CoreHunterObjective objective) {
        Objective<SubsetSolution, CoreHunterData> obj = this.createObjective(data, objective);
        return obj.evaluate(sol, data).getValue();
    }

    public long getTimeLimit() {
        return this.timeLimit;
    }

    public void setTimeLimit(long ms) {
        this.timeLimit = ms;
    }

    public long getMaxTimeWithoutImprovement() {
        if (this.timeLimit < 0L && this.maxTimeWithoutImprovement < 0L && this.maxSteps < 0L && this.maxStepsWithoutImprovement < 0L) {
            return this.mode == CoreHunterExecutionMode.DEFAULT ? 10000L : 2000L;
        }
        return this.maxTimeWithoutImprovement;
    }

    public void setMaxTimeWithoutImprovement(long ms) {
        this.maxTimeWithoutImprovement = ms;
    }

    public long getMaxSteps() {
        return this.maxSteps;
    }

    public void setMaxSteps(long steps) {
        this.maxSteps = steps;
    }

    public long getMaxStepsWithoutImprovement() {
        return this.maxStepsWithoutImprovement;
    }

    public void setMaxStepsWithoutImprovement(long steps) {
        this.maxStepsWithoutImprovement = steps;
    }

    public CoreHunterListener getListener() {
        return this.listener;
    }

    public void setListener(CoreHunterListener listener) {
        this.listener = listener;
    }

    public void setSeed(long seed) {
        this.seedGenerator.setSeed(seed);
    }

    private Search<SubsetSolution> createMainSearch(CoreHunterArguments arguments) {
        Objective<SubsetSolution, CoreHunterData> obj = this.createObjective(arguments);
        switch (this.mode) {
            case DEFAULT: {
                return this.createParallelTempering(arguments, obj);
            }
            case FAST: {
                return this.createRandomDescent(arguments, obj);
            }
        }
        throw new CoreHunterException("Unknown execution mode " + (Object)((Object)this.mode) + ".");
    }

    private Search<SubsetSolution> createRandomDescent(CoreHunterArguments args, Objective<SubsetSolution, CoreHunterData> obj) {
        RandomDescent<SubsetSolution> rd = new RandomDescent<SubsetSolution>(this.createProblem(args, obj), this.createNeighbourhood(args));
        rd.setRandom(new Random(this.seedGenerator.nextLong()));
        return this.setStopCriteria(rd, this.mode == CoreHunterExecutionMode.DEFAULT);
    }

    private Search<SubsetSolution> createParallelTempering(CoreHunterArguments args, Objective<SubsetSolution, CoreHunterData> obj) {
        if (this.mode != CoreHunterExecutionMode.DEFAULT) {
            throw new CoreHunterException("Parallel tempering search should only be used in default mode.");
        }
        ParallelTempering<SubsetSolution> pt = new ParallelTempering<SubsetSolution>(this.createProblem(args, obj), this.createNeighbourhood(args), 10, 1.0E-8, 1.0E-4, (p, n, t) -> {
            MetropolisSearch rep = new MetropolisSearch(p, n, t);
            rep.setRandom(new Random(this.seedGenerator.nextLong()));
            return rep;
        });
        pt.setReplicaSteps(500L);
        pt.setRandom(new Random(this.seedGenerator.nextLong()));
        return this.setStopCriteria(pt, false);
    }

    private SubsetProblem<CoreHunterData> createProblem(CoreHunterArguments args, Objective<SubsetSolution, CoreHunterData> obj) {
        int size = args.getSubsetSize();
        SubsetProblem<CoreHunterData> problem = new SubsetProblem<CoreHunterData>(args.getData(), obj, size);
        problem.setRandomSolutionGenerator((rnd, data) -> {
            SubsetSolution sol = new SubsetSolution(data.getIDs(), args.getAlwaysSelected());
            HashSet<Integer> candidates = new HashSet<Integer>(sol.getUnselectedIDs());
            candidates.removeAll(args.getNeverSelected());
            sol.selectAll(SetUtilities.getRandomSubset(candidates, size - sol.getNumSelectedIDs(), rnd));
            return sol;
        });
        return problem;
    }

    private Neighbourhood<SubsetSolution> createNeighbourhood(CoreHunterArguments args) {
        HashSet<Integer> fixed = new HashSet<Integer>();
        fixed.addAll(args.getAlwaysSelected());
        fixed.addAll(args.getNeverSelected());
        return new SingleSwapNeighbourhood(fixed);
    }

    private Search<SubsetSolution> setStopCriteria(Search<SubsetSolution> search, boolean rescaleSteps) {
        long steps;
        if (this.getTimeLimit() > 0L) {
            search.addStopCriterion(new MaxRuntime(this.getTimeLimit(), TimeUnit.MILLISECONDS));
        }
        if (this.getMaxTimeWithoutImprovement() > 0L) {
            search.addStopCriterion(new MaxTimeWithoutImprovement(this.getMaxTimeWithoutImprovement(), TimeUnit.MILLISECONDS));
        }
        if (this.getMaxSteps() > 0L) {
            steps = rescaleSteps ? this.getMaxSteps() * 500L : this.getMaxSteps();
            search.addStopCriterion(new MaxSteps(steps));
        }
        if (this.getMaxStepsWithoutImprovement() > 0L) {
            steps = rescaleSteps ? this.getMaxStepsWithoutImprovement() * 500L : this.getMaxStepsWithoutImprovement();
            search.addStopCriterion(new MaxStepsWithoutImprovement(steps));
        }
        return search;
    }

    private Objective<SubsetSolution, CoreHunterData> createObjective(CoreHunterArguments arguments) {
        CoreHunterData data = arguments.getData();
        List<CoreHunterObjective> objectives = arguments.getObjectives();
        if (objectives == null || objectives.isEmpty()) {
            throw new CoreHunterException("No objective(s) given.");
        }
        if (objectives.size() == 1) {
            return this.createObjective(data, objectives.get(0));
        }
        WeightedIndex<SubsetSolution, CoreHunterData> weightedIndex = new WeightedIndex<SubsetSolution, CoreHunterData>();
        List<Objective<SubsetSolution, CoreHunterData>> jamesObjectives = objectives.stream().map(obj -> this.createObjective(data, (CoreHunterObjective)obj)).collect(Collectors.toList());
        if (arguments.isNormalized()) {
            jamesObjectives = this.normalizeObjectives(arguments, jamesObjectives);
        }
        for (int o = 0; o < objectives.size(); ++o) {
            weightedIndex.addObjective(jamesObjectives.get(o), objectives.get(o).getWeight());
        }
        return weightedIndex;
    }

    private Objective<SubsetSolution, CoreHunterData> createObjective(CoreHunterData data, CoreHunterObjective coreHunterObjective) {
        Objective<SubsetSolution, CoreHunterData> objective = null;
        DistanceMeasure distanceMeasure = null;
        if (coreHunterObjective.getMeasure() != null) {
            switch (coreHunterObjective.getMeasure()) {
                case MODIFIED_ROGERS: {
                    if (!data.hasGenotypes()) {
                        throw new CoreHunterException("Genotypes are required for Modified Rogers distance.");
                    }
                    distanceMeasure = new ModifiedRogersDistance();
                    break;
                }
                case CAVALLI_SFORZA_EDWARDS: {
                    if (!data.hasGenotypes()) {
                        throw new CoreHunterException("Genotypes are required for Cavalli-Sforza and Edwards distance.");
                    }
                    distanceMeasure = new CavalliSforzaEdwardsDistance();
                    break;
                }
                case GOWERS: {
                    if (!data.hasPhenotypes()) {
                        throw new CoreHunterException("Phenotypes are required for Gower distance.");
                    }
                    distanceMeasure = new GowerDistance();
                    break;
                }
                case PRECOMPUTED_DISTANCE: {
                    if (!data.hasDistances()) {
                        throw new CoreHunterException("No precomputed distance matrix has been defined.");
                    }
                    distanceMeasure = new PrecomputedDistance();
                    break;
                }
            }
        }
        switch (coreHunterObjective.getObjectiveType()) {
            case AV_ACCESSION_TO_NEAREST_ENTRY: {
                if (distanceMeasure == null) {
                    throw new CoreHunterException(String.format("No distance measure defined. A distance measure is required for %s", new Object[]{CoreHunterObjectiveType.AV_ACCESSION_TO_NEAREST_ENTRY}));
                }
                objective = new AverageAccessionToNearestEntry(distanceMeasure);
                break;
            }
            case AV_ENTRY_TO_ENTRY: {
                if (distanceMeasure == null) {
                    throw new CoreHunterException(String.format("No distance measure defined. A distance measure is required for %s", new Object[]{CoreHunterObjectiveType.AV_ENTRY_TO_ENTRY}));
                }
                objective = new AverageEntryToEntry(distanceMeasure);
                break;
            }
            case AV_ENTRY_TO_NEAREST_ENTRY: {
                if (distanceMeasure == null) {
                    throw new CoreHunterException(String.format("No distance measure defined. A distance measure is required for %s", new Object[]{CoreHunterObjectiveType.AV_ENTRY_TO_NEAREST_ENTRY}));
                }
                objective = new AverageEntryToNearestEntry(distanceMeasure);
                break;
            }
            case COVERAGE: {
                if (!data.hasGenotypes()) {
                    throw new CoreHunterException("Genotypes are required for coverage objective.");
                }
                objective = new Coverage();
                break;
            }
            case HETEROZYGOUS_LOCI: {
                if (!data.hasGenotypes()) {
                    throw new CoreHunterException("Genotypes are required for expected proportion of heterozygous loci objective.");
                }
                objective = new HeterozygousLoci();
                break;
            }
            case SHANNON_DIVERSITY: {
                if (!data.hasGenotypes()) {
                    throw new CoreHunterException("Genotypes are required for Shannon's index.");
                }
                objective = new Shannon();
                break;
            }
            default: {
                throw new IllegalArgumentException(String.format("Unknown objective : %s", coreHunterObjective));
            }
        }
        return objective;
    }

    private List<Objective<SubsetSolution, CoreHunterData>> normalizeObjectives(CoreHunterArguments arguments, List<Objective<SubsetSolution, CoreHunterData>> objectives) {
        List<Range<Double>> ranges;
        List<CoreHunterObjective> chObjectives;
        if (this.listener != null) {
            this.listener.preprocessingStarted("Normalizing objectives.");
        }
        if ((chObjectives = arguments.getObjectives()).stream().map(CoreHunterObjective::getNormalizationRange).anyMatch(Objects::isNull)) {
            ranges = this.normalize(arguments);
            for (int o = 0; o < chObjectives.size(); ++o) {
                Range<Double> range = chObjectives.get(o).getNormalizationRange();
                if (range == null) continue;
                ranges.set(o, range);
            }
        } else {
            ranges = chObjectives.stream().map(CoreHunterObjective::getNormalizationRange).collect(Collectors.toList());
        }
        StringBuilder message = new StringBuilder();
        ArrayList<Objective<SubsetSolution, CoreHunterData>> normalizedObjectives = new ArrayList<Objective<SubsetSolution, CoreHunterData>>();
        for (int o = 0; o < objectives.size(); ++o) {
            Objective<SubsetSolution, CoreHunterData> obj = objectives.get(o);
            Range<Double> range = ranges.get(o);
            double min = range.getLower();
            double max = range.getUpper();
            normalizedObjectives.add(new NormalizedObjective<SubsetSolution, CoreHunterData>(obj, min, max));
            message.append(String.format(Locale.ROOT, "%s: [%.3f, %.3f]%n", obj, min, max));
        }
        message.append("Finished normalization.");
        if (this.listener != null) {
            this.listener.preprocessingStopped(message.toString());
        }
        return normalizedObjectives;
    }
}

