/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jclec.intarray;

import net.sf.jclec.ISpecies;
import net.sf.jclec.base.AbstractCreator;
import net.sf.jclec.intarray.IIntArraySpecies;
import net.sf.jclec.intarray.IntArrayIndividual;
import net.sf.jclec.util.intset.IIntegerSet;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class IntArrayCreator<I extends IntArrayIndividual>
extends AbstractCreator<I> {
    private static final long serialVersionUID = -2638928425169895614L;
    protected transient IIntArraySpecies<I> species;
    protected transient IIntegerSet[] schema;

    public boolean equals(Object other) {
        return other instanceof IntArrayCreator;
    }

    @Override
    protected void prepareCreation() {
        ISpecies spc = this.context.getSpecies();
        if (!(spc instanceof IIntArraySpecies)) {
            throw new IllegalStateException("Illegal species in context");
        }
        this.species = (IIntArraySpecies)spc;
        this.schema = this.species.getGenotypeSchema();
    }

    @Override
    protected void createNext() {
        this.createdBuffer.add(this.species.createIndividual(this.createGenotype()));
    }

    private final int[] createGenotype() {
        int gl = this.schema.length;
        int[] result = new int[gl];
        int i = 0;
        while (i < gl) {
            result[i] = this.schema[i].getRandom(this.randgen);
            ++i;
        }
        return result;
    }
}

