/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.jclec.base;

import java.util.ArrayList;
import java.util.List;
import net.sourceforge.jclec.IIndividual;
import net.sourceforge.jclec.IPopulation;
import net.sourceforge.jclec.IProvider;
import net.sourceforge.jclec.ISystem;
import net.sourceforge.jclec.util.random.IRandGen;

public abstract class AbstractCreator
implements IProvider {
    protected IPopulation context;
    protected IRandGen randgen;
    protected transient int numberOfIndividuals;
    protected transient List<IIndividual> createdBuffer;
    protected transient int createdCounter;

    @Override
    public void contextualize(ISystem context) {
        if (!(context instanceof IPopulation)) {
            throw new IllegalArgumentException("This object uses a population as execution context");
        }
        this.context = (IPopulation)context;
        this.randgen = context.createRandGen();
    }

    @Override
    public List<IIndividual> provide(int numberOfIndividuals) {
        this.numberOfIndividuals = numberOfIndividuals;
        this.createdBuffer = new ArrayList<IIndividual>(numberOfIndividuals);
        this.prepareCreation();
        this.createdCounter = 0;
        while (this.createdCounter < numberOfIndividuals) {
            this.createNext();
            ++this.createdCounter;
        }
        return this.createdBuffer;
    }

    protected abstract void prepareCreation();

    protected abstract void createNext();
}

