/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.jclec.util.random;

import net.sourceforge.jclec.util.random.AbstractRandGen;
import org.apache.commons.lang.builder.EqualsBuilder;
import org.apache.commons.lang.builder.ToStringBuilder;

public class Ranecu
extends AbstractRandGen {
    private static final long serialVersionUID = -6085545562116115737L;
    private int seed1;
    private int seed2;

    protected Ranecu() {
    }

    public Ranecu(int seed1, int seed2) {
        this.seed1 = seed1;
        this.seed2 = seed2;
    }

    @Override
    public double raw() {
        int iz;
        int k = this.seed1 / 53668;
        this.seed1 = 40014 * (this.seed1 - k * 53668) - k * 12211;
        if (this.seed1 < 0) {
            this.seed1 += 2147483563;
        }
        k = this.seed2 / 52774;
        this.seed2 = 40692 * (this.seed2 - k * 52774) - k * 3791;
        if (this.seed2 < 0) {
            this.seed2 += 0x7FFFFF07;
        }
        if ((iz = this.seed1 - this.seed2) < 1) {
            iz += 0x7FFFFFAA;
        }
        return (double)iz * 4.656613E-10;
    }

    @Override
    public final void raw(double[] d, int n) {
        int i = 0;
        while (i < n) {
            int iz;
            int k = this.seed1 / 53668;
            this.seed1 = 40014 * (this.seed1 - k * 53668) - k * 12211;
            if (this.seed1 < 0) {
                this.seed1 += 2147483563;
            }
            k = this.seed2 / 52774;
            this.seed2 = 40692 * (this.seed2 - k * 52774) - k * 3791;
            if (this.seed2 < 0) {
                this.seed2 += 0x7FFFFF07;
            }
            if ((iz = this.seed1 - this.seed2) < 1) {
                iz += 0x7FFFFFAA;
            }
            d[i] = (double)iz * 4.656613E-10;
            ++i;
        }
    }

    public String toString() {
        ToStringBuilder tsb = new ToStringBuilder(this);
        tsb.append("seed1", this.seed1);
        tsb.append("seed2", this.seed2);
        return tsb.toString();
    }

    public boolean equals(Object other) {
        if (other instanceof Ranecu) {
            Ranecu o = (Ranecu)other;
            EqualsBuilder eb = new EqualsBuilder();
            eb.append(this.seed1, o.seed1);
            eb.append(this.seed2, o.seed2);
            return eb.isEquals();
        }
        return false;
    }
}

