/*
 * Decompiled with CFR 0.152.
 */
package javolution.util;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.NoSuchElementException;
import javax.realtime.MemoryArea;
import javolution.lang.Reusable;
import javolution.realtime.Realtime;
import javolution.realtime.RealtimeObject;
import javolution.util.FastCollection;
import javolution.util.FastComparator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FastList<E>
extends FastCollection<E>
implements Reusable,
List<E>,
Serializable {
    private static final RealtimeObject.Factory FACTORY = new RealtimeObject.Factory(){

        public Object create() {
            return new FastList();
        }

        public void cleanup(Object object) {
            ((FastList)object).reset();
        }
    };
    private transient Node<E> _head = new Node();
    private transient Node<E> _tail = new Node();
    private transient int _size;

    public FastList() {
        this(4);
    }

    public FastList(int n) {
        ((Node)this._head)._next = (Node)this._tail;
        ((Node)this._tail)._previous = (Node)this._head;
        Node<E> node = this._tail;
        int n2 = 0;
        while (n2++ < n) {
            Node node2 = new Node();
            node2._previous = (Node)node;
            ((Node)node)._next = node2;
            node = node2;
        }
    }

    public FastList(Collection<? extends E> collection) {
        this(collection.size());
        this.addAll(collection);
    }

    public static <E> FastList<E> newInstance() {
        return (FastList)FACTORY.object();
    }

    @Override
    public final boolean add(E e) {
        this.addLast(e);
        return true;
    }

    @Override
    public int hashCode() {
        FastComparator fastComparator = this.getValueComparator();
        int n = 1;
        Node node = this._head;
        Node<E> node2 = this._tail;
        while ((node = node._next) != node2) {
            n = 31 * n + fastComparator.hashCodeOf(node._value);
        }
        return n;
    }

    @Override
    public final E get(int n) {
        if (n < 0 || n >= this._size) {
            throw new IndexOutOfBoundsException("index: " + n);
        }
        return (E)((Node)this.nodeAt(n))._value;
    }

    @Override
    public final E set(int n, E e) {
        if (n < 0 || n >= this._size) {
            throw new IndexOutOfBoundsException("index: " + n);
        }
        Node<E> node = this.nodeAt(n);
        Object object = ((Node)node)._value;
        ((Node)node)._value = e;
        return (E)object;
    }

    @Override
    public final void add(int n, E e) {
        if (n < 0 || n > this._size) {
            throw new IndexOutOfBoundsException("index: " + n);
        }
        this.addBefore(this.nodeAt(n), e);
    }

    @Override
    public final boolean addAll(int n, Collection<? extends E> collection) {
        if (n < 0 || n > this._size) {
            throw new IndexOutOfBoundsException("index: " + n);
        }
        Node<E> node = this.nodeAt(n);
        if (collection instanceof FastList) {
            FastList fastList = (FastList)collection;
            Node node2 = fastList._head;
            Node<E> node3 = fastList._tail;
            while ((node2 = node2._next) != node3) {
                this.addBefore(node, node2._value);
            }
        } else {
            Iterator<E> iterator = collection.iterator();
            while (iterator.hasNext()) {
                this.addBefore(node, iterator.next());
            }
        }
        return collection.size() != 0;
    }

    @Override
    public final E remove(int n) {
        if (n < 0 || n >= this._size) {
            throw new IndexOutOfBoundsException("index: " + n);
        }
        Node<E> node = this.nodeAt(n);
        Object object = ((Node)node)._value;
        this.delete(node);
        return (E)object;
    }

    @Override
    public final int indexOf(Object object) {
        FastComparator fastComparator = this.getValueComparator();
        int n = 0;
        Node node = this._head;
        Node<E> node2 = this._tail;
        while ((node = node._next) != node2) {
            if (fastComparator.areEqual(object, node._value)) {
                return n;
            }
            ++n;
        }
        return -1;
    }

    @Override
    public final int lastIndexOf(Object object) {
        FastComparator fastComparator = this.getValueComparator();
        int n = this.size() - 1;
        Node node = this._tail;
        Node<E> node2 = this._head;
        while ((node = node._previous) != node2) {
            if (fastComparator.areEqual(object, node._value)) {
                return n;
            }
            --n;
        }
        return -1;
    }

    @Override
    public final Iterator<E> iterator() {
        FastListIterator fastListIterator = (FastListIterator)FastListIterator.FACTORY.object();
        fastListIterator._list = this;
        fastListIterator._length = this._size;
        fastListIterator._nextNode = ((Node)this._head)._next;
        fastListIterator._nextIndex = 0;
        return fastListIterator;
    }

    @Override
    public final ListIterator<E> listIterator() {
        FastListIterator fastListIterator = (FastListIterator)FastListIterator.FACTORY.object();
        fastListIterator._list = this;
        fastListIterator._length = this._size;
        fastListIterator._nextNode = ((Node)this._head)._next;
        fastListIterator._nextIndex = 0;
        return fastListIterator;
    }

    @Override
    public final ListIterator<E> listIterator(int n) {
        if (n >= 0 && n <= this._size) {
            FastListIterator fastListIterator = (FastListIterator)FastListIterator.FACTORY.object();
            fastListIterator._list = this;
            fastListIterator._length = this._size;
            fastListIterator._nextNode = this.nodeAt(n);
            fastListIterator._nextIndex = n;
            return fastListIterator;
        }
        throw new IndexOutOfBoundsException("index: " + n + " for list of size: " + this._size);
    }

    @Override
    public final List<E> subList(int n, int n2) {
        if (n < 0 || n2 > this._size || n > n2) {
            throw new IndexOutOfBoundsException("fromIndex: " + n + ", toIndex: " + n2 + " for list of size: " + this._size);
        }
        SubList subList = (SubList)SubList.FACTORY.object();
        subList._list = this;
        subList._head = ((Node)this.nodeAt(n))._previous;
        subList._tail = this.nodeAt(n2);
        subList._size = n2 - n;
        return subList;
    }

    @Override
    public final E getFirst() {
        Node node = ((Node)this._head)._next;
        if (node == this._tail) {
            throw new NoSuchElementException();
        }
        return (E)node._value;
    }

    @Override
    public final E getLast() {
        Node node = ((Node)this._tail)._previous;
        if (node == this._head) {
            throw new NoSuchElementException();
        }
        return (E)node._value;
    }

    @Override
    public final void addFirst(E e) {
        this.addBefore(((Node)this._head)._next, e);
    }

    @Override
    public void addLast(E e) {
        if (((Node)this._tail)._next == null) {
            this.increaseCapacity();
        }
        ((Node)this._tail)._value = e;
        this._tail = ((Node)this._tail)._next;
        ++this._size;
    }

    @Override
    public final E removeFirst() {
        Node node = ((Node)this._head)._next;
        if (node == this._tail) {
            throw new NoSuchElementException();
        }
        Object object = node._value;
        this.delete(node);
        return (E)object;
    }

    @Override
    public final E removeLast() {
        if (this._size == 0) {
            throw new NoSuchElementException();
        }
        --this._size;
        Node node = ((Node)this._tail)._previous;
        Object object = node._value;
        this._tail = node;
        node._value = null;
        return (E)object;
    }

    public final void addBefore(Node<E> node, E e) {
        if (((Node)this._tail)._next == null) {
            this.increaseCapacity();
        }
        ++this._size;
        Node node2 = ((Node)this._tail)._next;
        Node node3 = ((Node)this._tail)._next = node2._next;
        if (node3 != null) {
            node3._previous = (Node)this._tail;
        }
        Node node4 = ((Node)node)._previous;
        node4._next = node2;
        ((Node)node)._previous = node2;
        node2._next = (Node)node;
        node2._previous = node4;
        node2._value = e;
    }

    private final Node<E> nodeAt(int n) {
        int n2 = this._size;
        if (n <= n2 >> 1) {
            Node node = this._head;
            int n3 = n;
            while (n3-- >= 0) {
                node = node._next;
            }
            return node;
        }
        Node node = this._tail;
        int n4 = n2 - n;
        while (n4-- > 0) {
            node = node._previous;
        }
        return node;
    }

    @Override
    public final Node<E> head() {
        return this._head;
    }

    @Override
    public final Node<E> tail() {
        return this._tail;
    }

    @Override
    public final E valueOf(FastCollection.Record record) {
        return (E)((Node)record)._value;
    }

    @Override
    public final void delete(FastCollection.Record record) {
        Node node = (Node)record;
        --this._size;
        node._value = null;
        node._previous._next = node._next;
        node._next._previous = node._previous;
        Node node2 = ((Node)this._tail)._next;
        node._previous = (Node)this._tail;
        node._next = node2;
        ((Node)this._tail)._next = node;
        if (node2 != null) {
            node2._previous = node;
        }
    }

    @Override
    public final int size() {
        return this._size;
    }

    @Override
    public final void clear() {
        Node node = this._head;
        Node<E> node2 = this._tail;
        while ((node = node._next) != node2) {
            node._value = null;
        }
        this._tail = ((Node)this._head)._next;
        this._size = 0;
    }

    @Override
    public void reset() {
        super.setValueComparator(FastComparator.DIRECT);
        this.clear();
    }

    @Override
    public boolean move(Realtime.ObjectSpace objectSpace) {
        if (super.move(objectSpace)) {
            Node node = this._head;
            Node<E> node2 = this._tail;
            while ((node = node._next) != node2) {
                if (!(node._value instanceof Realtime)) continue;
                ((Realtime)node._value).move(objectSpace);
            }
            return true;
        }
        return false;
    }

    private void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        this._head = new Node();
        this._tail = new Node();
        ((Node)this._head)._next = (Node)this._tail;
        ((Node)this._tail)._previous = (Node)this._head;
        int n = objectInputStream.readInt();
        this.setValueComparator((FastComparator)objectInputStream.readObject());
        int n2 = n;
        while (n2-- != 0) {
            this.addLast(objectInputStream.readObject());
        }
    }

    private void writeObject(ObjectOutputStream objectOutputStream) throws IOException {
        objectOutputStream.writeInt(this._size);
        objectOutputStream.writeObject(this.getValueComparator());
        Node node = this._head;
        int n = this._size;
        while (n-- != 0) {
            node = node._next;
            objectOutputStream.writeObject(node._value);
        }
    }

    private void increaseCapacity() {
        MemoryArea.getMemoryArea(this).executeInArea(new Runnable(){

            public void run() {
                Node node = new Node();
                FastList.this._tail._next = node;
                node._previous = FastList.this._tail;
                Node node2 = new Node();
                node._next = node2;
                node2._previous = node;
                Node node3 = new Node();
                node2._next = node3;
                node3._previous = node2;
                Node node4 = new Node();
                node3._next = node4;
                node4._previous = node3;
            }
        });
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static final class SubList<E>
    extends FastCollection<E>
    implements List<E>,
    Serializable {
        private static final RealtimeObject.Factory FACTORY = new RealtimeObject.Factory(){

            protected Object create() {
                return new SubList();
            }

            protected void cleanup(Object object) {
                SubList subList = (SubList)object;
                subList._list = null;
                subList._head = null;
                subList._tail = null;
            }
        };
        private FastList<E> _list;
        private Node<E> _head;
        private Node<E> _tail;
        private int _size;

        private SubList() {
        }

        @Override
        public int size() {
            return this._size;
        }

        @Override
        public FastCollection.Record head() {
            return this._head;
        }

        @Override
        public FastCollection.Record tail() {
            return this._tail;
        }

        @Override
        public E valueOf(FastCollection.Record record) {
            return this._list.valueOf(record);
        }

        @Override
        public void delete(FastCollection.Record record) {
            this._list.delete(record);
        }

        @Override
        public boolean addAll(int n, Collection<? extends E> collection) {
            if (n < 0 || n > this._size) {
                throw new IndexOutOfBoundsException("index: " + n);
            }
            Node<E> node = this.nodeAt(n);
            Iterator<E> iterator = collection.iterator();
            while (iterator.hasNext()) {
                this._list.addBefore(node, iterator.next());
            }
            return collection.size() != 0;
        }

        @Override
        public E get(int n) {
            if (n < 0 || n >= this._size) {
                throw new IndexOutOfBoundsException("index: " + n);
            }
            return (E)((Node)this.nodeAt(n))._value;
        }

        @Override
        public E set(int n, E e) {
            if (n < 0 || n >= this._size) {
                throw new IndexOutOfBoundsException("index: " + n);
            }
            Node<E> node = this.nodeAt(n);
            Object object = ((Node)node)._value;
            ((Node)node)._value = e;
            return (E)object;
        }

        @Override
        public void add(int n, E e) {
            if (n < 0 || n > this._size) {
                throw new IndexOutOfBoundsException("index: " + n);
            }
            this._list.addBefore(this.nodeAt(n), e);
        }

        @Override
        public E remove(int n) {
            if (n < 0 || n >= this._size) {
                throw new IndexOutOfBoundsException("index: " + n);
            }
            Node<E> node = this.nodeAt(n);
            Object object = ((Node)node)._value;
            this._list.delete(node);
            return (E)object;
        }

        @Override
        public int indexOf(Object object) {
            FastComparator fastComparator = this._list.getValueComparator();
            int n = 0;
            Node node = this._head;
            Node<E> node2 = this._tail;
            while ((node = node._next) != node2) {
                if (fastComparator.areEqual(object, node._value)) {
                    return n;
                }
                ++n;
            }
            return -1;
        }

        @Override
        public int lastIndexOf(Object object) {
            FastComparator fastComparator = this.getValueComparator();
            int n = this.size() - 1;
            Node node = this._tail;
            Node<E> node2 = this._head;
            while ((node = node._previous) != node2) {
                if (fastComparator.areEqual(object, node._value)) {
                    return n;
                }
                --n;
            }
            return -1;
        }

        @Override
        public ListIterator<E> listIterator() {
            return this.listIterator(0);
        }

        @Override
        public ListIterator<E> listIterator(int n) {
            if (n >= 0 && n <= this._size) {
                FastListIterator fastListIterator = (FastListIterator)FastListIterator.FACTORY.object();
                fastListIterator._list = this._list;
                fastListIterator._length = this._size;
                fastListIterator._nextNode = this.nodeAt(n);
                fastListIterator._nextIndex = n;
                return fastListIterator;
            }
            throw new IndexOutOfBoundsException("index: " + n + " for list of size: " + this._size);
        }

        @Override
        public List<E> subList(int n, int n2) {
            if (n < 0 || n2 > this._size || n > n2) {
                throw new IndexOutOfBoundsException("fromIndex: " + n + ", toIndex: " + n2 + " for list of size: " + this._size);
            }
            SubList subList = (SubList)FACTORY.object();
            subList._list = this._list;
            subList._head = ((Node)this.nodeAt(n))._previous;
            subList._tail = this.nodeAt(n2);
            subList._size = n2 - n;
            return subList;
        }

        private final Node<E> nodeAt(int n) {
            if (n <= this._size >> 1) {
                Node node = this._head;
                int n2 = n;
                while (n2-- >= 0) {
                    node = node._next;
                }
                return node;
            }
            Node node = this._tail;
            int n3 = this._size - n;
            while (n3-- > 0) {
                node = node._previous;
            }
            return node;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static final class FastListIterator<E>
    extends RealtimeObject
    implements ListIterator<E> {
        private static final RealtimeObject.Factory FACTORY = new RealtimeObject.Factory(){

            protected Object create() {
                return new FastListIterator();
            }

            protected void cleanup(Object object) {
                FastListIterator fastListIterator = (FastListIterator)object;
                fastListIterator._list = null;
                fastListIterator._currentNode = null;
                fastListIterator._nextNode = null;
            }
        };
        private FastList<E> _list;
        private Node<E> _nextNode;
        private Node<E> _currentNode;
        private int _length;
        private int _nextIndex;

        private FastListIterator() {
        }

        @Override
        public boolean hasNext() {
            return this._nextIndex != this._length;
        }

        @Override
        public E next() {
            if (this._nextIndex == this._length) {
                throw new NoSuchElementException();
            }
            ++this._nextIndex;
            this._currentNode = this._nextNode;
            this._nextNode = ((Node)this._nextNode)._next;
            return (E)((Node)this._currentNode)._value;
        }

        @Override
        public int nextIndex() {
            return this._nextIndex;
        }

        @Override
        public boolean hasPrevious() {
            return this._nextIndex != 0;
        }

        @Override
        public E previous() {
            if (this._nextIndex == 0) {
                throw new NoSuchElementException();
            }
            --this._nextIndex;
            this._currentNode = this._nextNode = ((Node)this._nextNode)._previous;
            return (E)((Node)this._currentNode)._value;
        }

        @Override
        public int previousIndex() {
            return this._nextIndex - 1;
        }

        @Override
        public void add(E e) {
            this._list.addBefore(this._nextNode, e);
            this._currentNode = null;
            ++this._length;
            ++this._nextIndex;
        }

        @Override
        public void set(E e) {
            if (this._currentNode == null) {
                throw new IllegalStateException();
            }
            ((Node)this._currentNode)._value = e;
        }

        @Override
        public void remove() {
            if (this._currentNode != null) {
                if (this._nextNode == this._currentNode) {
                    this._nextNode = ((Node)this._nextNode)._next;
                } else {
                    --this._nextIndex;
                }
                this._list.delete(this._currentNode);
                this._currentNode = null;
                --this._length;
            } else {
                throw new IllegalStateException();
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static final class Node<E>
    implements FastCollection.Record,
    Serializable {
        private Node<E> _next;
        private Node<E> _previous;
        private E _value;

        private Node() {
        }

        public final E getValue() {
            return this._value;
        }

        @Override
        public final Node<E> getNext() {
            return this._next;
        }

        @Override
        public final Node<E> getPrevious() {
            return this._previous;
        }
    }
}

