/*
 * Decompiled with CFR 0.152.
 */
package ec.tstoolkit.modelling.arima.x13;

import ec.tstoolkit.information.InformationSet;
import ec.tstoolkit.information.InformationSetSerializable;
import ec.tstoolkit.modelling.ChangeOfRegimeSpec;
import ec.tstoolkit.modelling.RegressionTestSpec;
import ec.tstoolkit.timeseries.calendars.LengthOfPeriodType;
import ec.tstoolkit.timeseries.calendars.TradingDaysType;
import java.util.Arrays;
import java.util.Map;
import java.util.Objects;

public class TradingDaysSpec
implements Cloneable,
InformationSetSerializable {
    private String holidays_;
    private String[] users_;
    private TradingDaysType type_ = TradingDaysType.None;
    private LengthOfPeriodType lp_ = LengthOfPeriodType.None;
    private RegressionTestSpec test_ = RegressionTestSpec.None;
    private boolean autoAdjust_ = true;
    private int w_ = 0;
    private ChangeOfRegimeSpec changeofregime_;
    public static final String TDOPTION = "option";
    public static final String LPOPTION = "leapyear";
    public static final String ADJUST = "autoadjust";
    public static final String HOLIDAYS = "holidays";
    public static final String USER = "user";
    public static final String TEST = "test";
    public static final String W = "stocktd";
    public static final String CHANGEOFREGIME = "changeofregime";

    public void reset() {
        this.holidays_ = null;
        this.users_ = null;
        this.type_ = TradingDaysType.None;
        this.lp_ = LengthOfPeriodType.None;
        this.test_ = RegressionTestSpec.None;
        this.autoAdjust_ = true;
        this.w_ = 0;
        this.changeofregime_ = null;
    }

    public TradingDaysType getTradingDaysType() {
        return this.type_;
    }

    public boolean isUsed() {
        return this.type_ != TradingDaysType.None || this.users_ != null || this.w_ != 0;
    }

    boolean isDefined() {
        return this.isUsed() && this.test_ == RegressionTestSpec.None;
    }

    public void setTradingDaysType(TradingDaysType value) {
        this.type_ = value;
        this.users_ = null;
        this.w_ = 0;
    }

    public LengthOfPeriodType getLengthOfPeriod() {
        return this.lp_;
    }

    public void setLengthOfPeriod(LengthOfPeriodType value) {
        this.lp_ = value;
    }

    public boolean isAutoAdjust() {
        return this.autoAdjust_;
    }

    public void setAutoAdjust(boolean value) {
        this.autoAdjust_ = value;
    }

    public void setStockTradingDays(int w) {
        this.w_ = w;
        this.holidays_ = null;
        this.users_ = null;
        this.type_ = TradingDaysType.None;
        this.lp_ = LengthOfPeriodType.None;
    }

    public boolean isStockTradingDays() {
        return this.w_ != 0;
    }

    public int getStockTradingDays() {
        return this.w_;
    }

    public boolean isValid() {
        if (this.isStockTradingDays()) {
            return true;
        }
        if (this.test_ != RegressionTestSpec.None) {
            return this.type_ != TradingDaysType.None && this.lp_ != LengthOfPeriodType.None;
        }
        if (this.type_ == TradingDaysType.None) {
            return this.lp_ == LengthOfPeriodType.None;
        }
        return true;
    }

    public String getHolidays() {
        return this.holidays_;
    }

    public void setHolidays(String value) {
        this.holidays_ = value;
        if (this.holidays_ != null && this.holidays_.length() == 0) {
            this.holidays_ = null;
        }
        if (this.holidays_ != null) {
            this.users_ = null;
            this.w_ = 0;
        }
    }

    public String[] getUserVariables() {
        return this.users_;
    }

    public void setUserVariables(String[] value) {
        this.users_ = value;
        if (this.users_ != null) {
            this.holidays_ = null;
            this.type_ = TradingDaysType.None;
            this.lp_ = LengthOfPeriodType.None;
            this.autoAdjust_ = false;
            this.w_ = 0;
        }
    }

    public RegressionTestSpec getTest() {
        return this.test_;
    }

    public void setTest(RegressionTestSpec value) {
        this.test_ = value;
    }

    public boolean isDefault() {
        return this.w_ == 0 && this.type_ == TradingDaysType.None && this.lp_ == LengthOfPeriodType.None && this.holidays_ == null && this.users_ == null;
    }

    public ChangeOfRegimeSpec getChangeOfRegime() {
        return this.changeofregime_;
    }

    public void setChangeOfRegime(ChangeOfRegimeSpec value) {
        this.changeofregime_ = value;
    }

    public TradingDaysSpec clone() {
        try {
            TradingDaysSpec spec = (TradingDaysSpec)super.clone();
            if (this.users_ != null) {
                spec.users_ = (String[])this.users_.clone();
            }
            if (this.changeofregime_ != null) {
                spec.changeofregime_ = this.changeofregime_.clone();
            }
            return spec;
        }
        catch (CloneNotSupportedException ex) {
            throw new AssertionError();
        }
    }

    public boolean equals(Object obj) {
        return this == obj || obj instanceof TradingDaysSpec && this.equals((TradingDaysSpec)obj);
    }

    private boolean equals(TradingDaysSpec other) {
        return Arrays.deepEquals(this.users_, other.users_) && Objects.equals(this.holidays_, other.holidays_) && this.w_ == other.w_ && Objects.equals(this.changeofregime_, other.changeofregime_) && this.type_ == other.type_ && this.lp_ == other.lp_ && this.test_ == other.test_ && this.autoAdjust_ == other.autoAdjust_;
    }

    public int hashCode() {
        int hash = 5;
        hash = 47 * hash + Objects.hashCode(this.holidays_);
        hash = 47 * hash + Arrays.deepHashCode(this.users_);
        hash = 47 * hash + Objects.hashCode((Object)this.type_);
        hash = 47 * hash + Objects.hashCode((Object)this.test_);
        hash = 47 * hash + this.w_;
        return hash;
    }

    public void disable() {
        this.holidays_ = null;
        this.users_ = null;
        this.type_ = TradingDaysType.None;
        this.test_ = RegressionTestSpec.None;
        this.lp_ = LengthOfPeriodType.None;
        this.w_ = 0;
    }

    @Override
    public InformationSet write(boolean verbose) {
        if (!verbose && this.isDefault()) {
            return null;
        }
        InformationSet info = new InformationSet();
        if (verbose || this.type_ != TradingDaysType.None) {
            info.add(TDOPTION, this.type_.name());
        }
        if (verbose || this.lp_ != LengthOfPeriodType.None) {
            info.add(LPOPTION, this.lp_.name());
        }
        if (verbose || !this.autoAdjust_) {
            info.add(ADJUST, Boolean.valueOf(this.autoAdjust_));
        }
        if (this.holidays_ != null) {
            info.add(HOLIDAYS, this.holidays_);
        }
        if (this.users_ != null) {
            info.add(USER, this.users_);
        }
        if (verbose || this.w_ != 0) {
            info.add(W, Integer.valueOf(this.w_));
        }
        if (verbose || this.test_ != RegressionTestSpec.None) {
            info.add(TEST, this.test_.name());
        }
        if (this.changeofregime_ != null) {
            info.add(CHANGEOFREGIME, this.changeofregime_.toString());
        }
        return info;
    }

    @Override
    public boolean read(InformationSet info) {
        try {
            String cr;
            String test;
            Boolean adj;
            String lp;
            this.reset();
            String td = info.get(TDOPTION, String.class);
            if (td != null) {
                this.type_ = TradingDaysType.valueOf(td);
            }
            if ((lp = info.get(LPOPTION, String.class)) != null) {
                this.lp_ = LengthOfPeriodType.valueOf(lp);
            }
            if ((adj = info.get(ADJUST, Boolean.class)) != null) {
                this.autoAdjust_ = adj;
            }
            this.holidays_ = info.get(HOLIDAYS, String.class);
            this.users_ = info.get(USER, String[].class);
            Integer w = info.get(W, Integer.class);
            if (w != null) {
                this.w_ = w;
            }
            if ((test = info.get(TEST, String.class)) != null) {
                this.test_ = RegressionTestSpec.valueOf(test);
            }
            if ((cr = info.get(CHANGEOFREGIME, String.class)) != null) {
                this.changeofregime_ = ChangeOfRegimeSpec.fromString(cr);
                if (this.changeofregime_ == null) {
                    return false;
                }
            }
            return true;
        }
        catch (Exception err) {
            return false;
        }
    }

    public static void fillDictionary(String prefix, Map<String, Class> dic) {
        dic.put(InformationSet.item(prefix, ADJUST), Boolean.class);
        dic.put(InformationSet.item(prefix, TDOPTION), String.class);
        dic.put(InformationSet.item(prefix, LPOPTION), String.class);
        dic.put(InformationSet.item(prefix, USER), String[].class);
        dic.put(InformationSet.item(prefix, HOLIDAYS), String.class);
        dic.put(InformationSet.item(prefix, W), Integer.class);
        dic.put(InformationSet.item(prefix, TEST), String.class);
        dic.put(InformationSet.item(prefix, CHANGEOFREGIME), String.class);
    }
}

