## ----include = FALSE----------------------------------------------------------
knitr::opts_chunk$set(
  collapse = TRUE,
  comment = "#>"
)

## ----setup--------------------------------------------------------------------
library(MUGS)

## ----load_data----------------------------------------------------------------
# Load required data
data(S.1)
data(S.2)
data(X.group.source)
data(X.group.target)
data(U.1)
data(U.2)

## ----prepare_variables--------------------------------------------------------
# Set parameters
n1 <- 100
n2 <- 100
p <- 5

# Ensure row and column names are consistent for matching
rownames(U.1) <- as.character(seq_len(nrow(U.1)))  # "1" to "100"
rownames(U.2) <- as.character(seq(from = 51, length.out = nrow(U.2)))  # "51" to "150"

# Align S.1 and S.2 with embeddings
rownames(S.1) <- rownames(U.1)
colnames(S.1) <- rownames(U.1)

rownames(S.2) <- rownames(U.2)
colnames(S.2) <- rownames(U.2)

# Get common codes
names.list.1 <- rownames(S.1)
names.list.2 <- rownames(S.2)
common_codes <- intersect(names.list.1, names.list.2)
n.common <- length(common_codes)

if (n.common == 0) stop("Error: No common codes found between source and target sites.")

full.name.list <- c(names.list.1, names.list.2)

# Initialize delta matrix
delta.int <- matrix(0, length(full.name.list), p)
rownames(delta.int) <- full.name.list

## ----run_function-------------------------------------------------------------
# Estimate site-specific effects
CodeSiteEff_l2_par.out <-  CodeSiteEff_l2_par(
  S.1 = S.1,
  S.2 = S.2,
  n1 = 100,
  n2 = 100,
  U.1 = U.1,
  U.2 = U.2,
  V.1= U.1,
  V.2 = U.2,
  delta.int = delta.int,
  lambda.delta = 3000,
  p=5,
  common_codes = common_codes,
  n.common = 50,
  n.core=2)

## ----examine_output-----------------------------------------------------------
# View structure of the output
str(CodeSiteEff_l2_par.out)

# Print specific components of the result
cat("\nEstimated Effects (Delta):\n")
print(CodeSiteEff_l2_par.out$delta[1:5, 1:5])  # First 5 rows and columns of delta matrix

cat("\nRegularization Path:\n")
print(CodeSiteEff_l2_par.out$path)

