/*
 * Decompiled with CFR 0.152.
 */
package org.rosuda.REngine;

import org.rosuda.REngine.REXPList;
import org.rosuda.REngine.REXPVector;

public class REXPInteger
extends REXPVector {
    protected int[] payload;
    public static final int NA = Integer.MIN_VALUE;

    public static boolean isNA(int value) {
        return value == Integer.MIN_VALUE;
    }

    public REXPInteger(int load) {
        this.payload = new int[]{load};
    }

    public REXPInteger(int[] load) {
        this.payload = load == null ? new int[]{} : load;
    }

    public REXPInteger(int[] load, REXPList attr) {
        super(attr);
        this.payload = load == null ? new int[]{} : load;
    }

    @Override
    public Object asNativeJavaObject() {
        return this.payload;
    }

    @Override
    public int length() {
        return this.payload.length;
    }

    @Override
    public boolean isInteger() {
        return true;
    }

    @Override
    public boolean isNumeric() {
        return true;
    }

    @Override
    public int[] asIntegers() {
        return this.payload;
    }

    @Override
    public double[] asDoubles() {
        double[] d = new double[this.payload.length];
        for (int i = 0; i < this.payload.length; ++i) {
            d[i] = this.payload[i];
        }
        return d;
    }

    @Override
    public String[] asStrings() {
        String[] s = new String[this.payload.length];
        for (int i = 0; i < this.payload.length; ++i) {
            s[i] = "" + this.payload[i];
        }
        return s;
    }

    @Override
    public boolean[] isNA() {
        boolean[] a = new boolean[this.payload.length];
        for (int i = 0; i < a.length; ++i) {
            a[i] = this.payload[i] == Integer.MIN_VALUE;
        }
        return a;
    }

    @Override
    public String toDebugString() {
        int i;
        StringBuffer sb = new StringBuffer(super.toDebugString() + "{");
        for (i = 0; i < this.payload.length && i < maxDebugItems; ++i) {
            if (i > 0) {
                sb.append(",");
            }
            sb.append(this.payload[i]);
        }
        if (i < this.payload.length) {
            sb.append(",..");
        }
        return sb.toString() + "}";
    }
}

