/*
 * Decompiled with CFR 0.152.
 */
package hep.aida.tdouble.ref;

import hep.aida.tdouble.DoubleIAxis;
import hep.aida.tdouble.DoubleIHistogram1D;
import hep.aida.tdouble.ref.DoubleHistogram;

abstract class DoubleAbstractHistogram1D
extends DoubleHistogram
implements DoubleIHistogram1D {
    private static final long serialVersionUID = 1L;
    protected DoubleIAxis xAxis;

    DoubleAbstractHistogram1D(String string) {
        super(string);
    }

    public int allEntries() {
        return this.entries() + this.extraEntries();
    }

    public int dimensions() {
        return 1;
    }

    public int entries() {
        int n = 0;
        int n2 = this.xAxis.bins();
        while (--n2 >= 0) {
            n += this.binEntries(n2);
        }
        return n;
    }

    public int extraEntries() {
        return this.binEntries(-2) + this.binEntries(-1);
    }

    int map(int n) {
        int n2 = this.xAxis.bins() + 2;
        if (n >= n2) {
            throw new IllegalArgumentException("bin=" + n);
        }
        if (n >= 0) {
            return n + 1;
        }
        if (n == -2) {
            return 0;
        }
        if (n == -1) {
            return n2 - 1;
        }
        throw new IllegalArgumentException("bin=" + n);
    }

    public int[] minMaxBins() {
        double d = Double.MAX_VALUE;
        double d2 = Double.MIN_VALUE;
        int n = -1;
        int n2 = -1;
        int n3 = this.xAxis.bins();
        while (--n3 >= 0) {
            double d3 = this.binHeight(n3);
            if (d3 < d) {
                d = d3;
                n = n3;
            }
            if (!(d3 > d2)) continue;
            d2 = d3;
            n2 = n3;
        }
        int[] nArray = new int[]{n, n2};
        return nArray;
    }

    public double sumAllBinHeights() {
        return this.sumBinHeights() + this.sumExtraBinHeights();
    }

    public double sumBinHeights() {
        double d = 0.0;
        int n = this.xAxis.bins();
        while (--n >= 0) {
            d += this.binHeight(n);
        }
        return d;
    }

    public double sumExtraBinHeights() {
        return this.binHeight(-2) + this.binHeight(-1);
    }

    public DoubleIAxis xAxis() {
        return this.xAxis;
    }
}

