/*
 * Decompiled with CFR 0.152.
 */
package com.amazon.sqlengine.executor.etree.value.scalar;

import com.amazon.dsi.dataengine.interfaces.IColumn;
import com.amazon.sqlengine.executor.datawrapper.ISqlDataWrapper;
import com.amazon.sqlengine.executor.etree.ETDataRequest;
import com.amazon.sqlengine.executor.etree.value.ETValueExpr;
import com.amazon.sqlengine.executor.etree.value.scalar.ETScalarFn;
import com.amazon.sqlengine.utilities.SQLEngineMessageKey;
import com.amazon.support.Warning;
import com.amazon.support.WarningCode;
import com.amazon.support.exceptions.ErrorException;
import java.util.Arrays;
import java.util.List;

public class ETSpaceFn
extends ETScalarFn {
    private final long m_columnLength;

    public ETSpaceFn(IColumn iColumn, List<ETValueExpr> list, List<IColumn> list2) throws ErrorException {
        super(iColumn, list, list2);
        assert (4 == list2.get(0).getTypeMetadata().getType());
        assert (iColumn.getTypeMetadata().isCharacterType());
        this.m_columnLength = iColumn.getColumnLength();
    }

    @Override
    public boolean retrieveData(ETDataRequest eTDataRequest) throws ErrorException {
        ISqlDataWrapper iSqlDataWrapper = this.getArgumentData(0);
        if (iSqlDataWrapper.isNull()) {
            eTDataRequest.getData().setNull();
            return false;
        }
        long l = eTDataRequest.getOffset() / 2L;
        long l2 = eTDataRequest.getMaxSize();
        long l3 = iSqlDataWrapper.getInteger();
        l3 = 0L > l3 ? 0L : l3 - l;
        long l4 = this.m_columnLength - l;
        boolean bl = false;
        int n = (int)Math.min(Integer.MAX_VALUE, l3);
        if (-1L != l2) {
            n = (int)Math.min((long)n, l2 / 2L);
        }
        if (l4 < (long)n) {
            n = (int)l4;
            bl = true;
        }
        char[] cArray = new char[n];
        Arrays.fill(cArray, ' ');
        eTDataRequest.getData().setChar(String.valueOf(cArray));
        if (bl) {
            this.getWarningListener().postWarning(new Warning(WarningCode.STRING_RIGHT_TRUNCATION_WARNING, 7, SQLEngineMessageKey.STRING_RIGHT_TRUNCATION.name(), -1L, -1));
            return false;
        }
        return (long)n < l3;
    }
}

