/*
 * Decompiled with CFR 0.152.
 */
package com.amazon.redshift.dataengine;

import com.amazon.dsi.dataengine.interfaces.IQueryExecutor;
import com.amazon.dsi.dataengine.utilities.ExecutionResults;
import com.amazon.dsi.dataengine.utilities.ParameterInputValue;
import com.amazon.dsi.dataengine.utilities.ParameterMetadata;
import com.amazon.dsi.dataengine.utilities.ParameterType;
import com.amazon.dsi.dataengine.utilities.TypeMetadata;
import com.amazon.dsi.exceptions.BadDefaultParamException;
import com.amazon.dsi.exceptions.NumericOverflowException;
import com.amazon.jdbc.communications.interfaces.SocketCloseListener;
import com.amazon.redshift.api.PGDataTypeUtilities;
import com.amazon.redshift.client.PGClient;
import com.amazon.redshift.client.PGMessagingContext;
import com.amazon.redshift.core.PGJDBCDriver;
import com.amazon.redshift.core.PGJDBCStatement;
import com.amazon.redshift.dataengine.PGExecutionResults;
import com.amazon.redshift.dataengine.PGMultipleParameterSetsExecutionResults;
import com.amazon.redshift.dataengine.metadata.PGParameterMetadata;
import com.amazon.redshift.exceptions.PGJDBCMessageKey;
import com.amazon.support.ILogger;
import com.amazon.support.LogUtilities;
import com.amazon.support.exceptions.ErrorException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public abstract class PGAbstractQueryExecutor
implements IQueryExecutor,
SocketCloseListener {
    protected List<PGMessagingContext> m_contexts = new ArrayList<PGMessagingContext>();
    protected int m_currentExecuteIndex = -1;
    protected boolean m_isDirectExecute;
    protected ExecutionResults m_results;
    protected PGClient m_client;
    protected ILogger m_log;
    protected PGJDBCStatement m_statement;
    protected ErrorException m_fatalException = null;
    protected int m_socketTimeoutMS;
    protected boolean m_rowCountArrayExpected = false;
    private Map<Integer, TypeMetadata> m_setParameterMetadata = null;
    private Map<PGMessagingContext, List<Integer>> m_numericParamIndxs = new HashMap<PGMessagingContext, List<Integer>>();
    private List<Integer> m_parameterOIDs = new ArrayList<Integer>();
    protected boolean m_prepareStage = true;

    protected abstract int getParamCountForContext(PGMessagingContext var1);

    @Override
    public void cancelExecute() throws ErrorException {
        LogUtilities.logFunctionEntrance(this.m_log, new Object[0]);
        if (null != this.m_fatalException) {
            throw this.m_fatalException;
        }
        this.m_client.cancelQuery();
        for (PGMessagingContext pGMessagingContext : this.m_contexts) {
            pGMessagingContext.m_isCanceled.set(true);
        }
    }

    @Override
    public void clearCancel() {
        LogUtilities.logFunctionEntrance(this.m_log, new Object[0]);
        for (PGMessagingContext pGMessagingContext : this.m_contexts) {
            pGMessagingContext.m_isCanceled.set(false);
        }
    }

    @Override
    public void clearPushedParamData() throws ErrorException {
        LogUtilities.logFunctionEntrance(this.m_log, new Object[0]);
    }

    @Override
    public void close() {
        LogUtilities.logFunctionEntrance(this.m_log, new Object[0]);
        for (PGMessagingContext pGMessagingContext : this.m_contexts) {
            pGMessagingContext.closeOperation();
            pGMessagingContext.removeSocketCloseListener(this);
        }
        this.m_results = null;
    }

    @Override
    public void finalizePushedParamData() throws ErrorException {
        LogUtilities.logFunctionEntrance(this.m_log, new Object[0]);
    }

    @Override
    public ExecutionResults getResults() throws ErrorException {
        LogUtilities.logFunctionEntrance(this.m_log, new Object[0]);
        if (null != this.m_fatalException) {
            throw this.m_fatalException;
        }
        if (null == this.m_contexts) {
            return null;
        }
        this.m_results = this.m_contexts.get((int)0).m_multipleParameterSetsMode ? new PGMultipleParameterSetsExecutionResults(this.m_contexts, this.m_log, this.m_socketTimeoutMS) : new PGExecutionResults(this.m_contexts, this.m_currentExecuteIndex, this.m_log, this.m_statement.getExpectedResult(), this.m_socketTimeoutMS, this.m_rowCountArrayExpected, this.m_prepareStage);
        return this.m_results;
    }

    @Override
    public void pushMappedParamTypes(Map<Integer, TypeMetadata> map) throws ErrorException {
        LogUtilities.logFunctionEntrance(this.m_log, new Object[0]);
        if (!this.m_statement.isCallableStatement()) {
            int n;
            boolean bl = false;
            boolean bl2 = true;
            if (null == this.m_setParameterMetadata) {
                bl = true;
                bl2 = false;
                this.m_setParameterMetadata = map;
            }
            TypeMetadata typeMetadata = null;
            int n2 = 0;
            for (Map.Entry<PGMessagingContext, List<Integer>> entry : this.m_numericParamIndxs.entrySet()) {
                PGMessagingContext pGMessagingContext = entry.getKey();
                for (int n3 : entry.getValue()) {
                    n = map.get(n3).getType();
                    short s = this.m_setParameterMetadata.get(n3).getType();
                    if (bl2 && n == s) continue;
                    bl = true;
                    typeMetadata = map.get(n3);
                    this.m_setParameterMetadata.put(n3, typeMetadata);
                    int n4 = PGDataTypeUtilities.SQLTypeToOid(typeMetadata.getType());
                    this.m_parameterOIDs.set(n2 + n3, n4);
                    try {
                        if (1700 == n4) {
                            n4 = 1043;
                        }
                        pGMessagingContext.m_parameterMetadata.set(n3, PGDataTypeUtilities.createParameter(n4, n3, pGMessagingContext));
                    }
                    catch (NumericOverflowException numericOverflowException) {
                        LogUtilities.logFatal(numericOverflowException, this.m_log);
                        throw PGJDBCDriver.s_PostgreSQLMessages.createGeneralException(PGJDBCMessageKey.CONN_GENERAL_ERR.name(), numericOverflowException.getMessage(), (Throwable)numericOverflowException);
                    }
                }
                n2 += pGMessagingContext.m_parameterMetadata.size();
            }
            if (bl) {
                try {
                    int n5 = 0;
                    int n6 = 0;
                    this.checkCancelled();
                    for (PGMessagingContext pGMessagingContext : this.m_contexts) {
                        ArrayList<Integer> arrayList = null;
                        n6 = this.getParamCountForContext(pGMessagingContext);
                        if (0 == n6) continue;
                        arrayList = new ArrayList<Integer>();
                        for (n = 0; n < n6; ++n) {
                            arrayList.add(this.m_parameterOIDs.get(n5));
                            ++n5;
                        }
                        this.m_client.reprepareStatement(pGMessagingContext, arrayList, this.m_statement.getWarningListener());
                    }
                }
                catch (ErrorException errorException) {
                    this.m_setParameterMetadata = null;
                    throw errorException;
                }
            }
        }
    }

    @Override
    public void pushParamData(int n, ParameterInputValue parameterInputValue) throws BadDefaultParamException, ErrorException {
        LogUtilities.logFunctionEntrance(this.m_log, n, parameterInputValue);
    }

    @Override
    public void socketClosed(ErrorException errorException) {
        this.m_fatalException = errorException;
    }

    protected List<ParameterMetadata> getMetadataForParameters(PGMessagingContext pGMessagingContext) throws ErrorException {
        LogUtilities.logFunctionEntrance(this.m_log, new Object[0]);
        ArrayList<ParameterMetadata> arrayList = new ArrayList();
        List<Integer> list = this.m_numericParamIndxs.get(pGMessagingContext);
        if (null == list) {
            list = new ArrayList<Integer>();
        }
        this.m_parameterOIDs.addAll(pGMessagingContext.m_parameterOids);
        if (this.m_statement.isCallableStatement()) {
            int n = PGDataTypeUtilities.oidToSQLType(pGMessagingContext.getRowDescription().getFieldDescriptions()[0].getDataTypeObjectID());
            if (this.m_statement.hasReturnQuestionMark()) {
                PGParameterMetadata pGParameterMetadata = new PGParameterMetadata(1, ParameterType.OUTPUT, n, pGMessagingContext);
                arrayList.add(pGParameterMetadata);
                for (ParameterMetadata parameterMetadata : pGMessagingContext.m_parameterMetadata) {
                    PGParameterMetadata pGParameterMetadata2 = new PGParameterMetadata(parameterMetadata.getParameterNumber() + 1, parameterMetadata.getParameterType(), (int)parameterMetadata.getTypeMetadata().getType(), pGMessagingContext);
                    int n2 = parameterMetadata.getParameterNumber();
                    arrayList.add(pGParameterMetadata2);
                    if (2 != pGParameterMetadata2.getTypeMetadata().getType() && 3 != pGParameterMetadata2.getTypeMetadata().getType()) continue;
                    list.add(n2 - 1);
                }
            } else {
                for (int i = 0; i < pGMessagingContext.m_parameterMetadata.size(); ++i) {
                    ParameterMetadata parameterMetadata = pGMessagingContext.m_parameterMetadata.get(i);
                    PGParameterMetadata pGParameterMetadata = null;
                    int n3 = parameterMetadata.getParameterNumber();
                    pGParameterMetadata = i == 0 ? new PGParameterMetadata(n3 + 1, ParameterType.INPUT_OUTPUT, (int)parameterMetadata.getTypeMetadata().getType(), pGMessagingContext) : new PGParameterMetadata(n3 + 1, parameterMetadata.getParameterType(), (int)parameterMetadata.getTypeMetadata().getType(), pGMessagingContext);
                    arrayList.add(pGParameterMetadata);
                    if (2 != pGParameterMetadata.getTypeMetadata().getType() && 3 != pGParameterMetadata.getTypeMetadata().getType()) continue;
                    list.add(n3 - 1);
                }
                if (arrayList.isEmpty()) {
                    PGParameterMetadata pGParameterMetadata = new PGParameterMetadata(1, ParameterType.OUTPUT, n, pGMessagingContext);
                    arrayList.add(pGParameterMetadata);
                }
            }
        } else {
            for (int i = 0; i < pGMessagingContext.m_parameterMetadata.size(); ++i) {
                ParameterMetadata parameterMetadata = pGMessagingContext.m_parameterMetadata.get(i);
                int n = parameterMetadata.getParameterNumber();
                if (2 != parameterMetadata.getTypeMetadata().getType() && 3 != parameterMetadata.getTypeMetadata().getType()) continue;
                list.add(n - 1);
            }
            arrayList = pGMessagingContext.m_parameterMetadata;
        }
        this.m_numericParamIndxs.put(pGMessagingContext, list);
        return arrayList;
    }

    protected void checkCancelled() throws ErrorException {
        for (PGMessagingContext pGMessagingContext : this.m_contexts) {
            if (!pGMessagingContext.m_isCanceled.get()) continue;
            throw PGJDBCDriver.s_PostgreSQLMessages.createGeneralException(PGJDBCMessageKey.PG_QUERY_CANCELLED.name());
        }
    }

    protected int getQueryTimeout() {
        try {
            return this.m_statement.getProperty(3).getInt() * 1000;
        }
        catch (Exception exception) {
            LogUtilities.logError(exception, this.m_log);
            return 0;
        }
    }
}

