/*
 * Decompiled with CFR 0.152.
 */
package no.uib.cipr.matrix;

import no.uib.cipr.matrix.BLASkernel;
import no.uib.cipr.matrix.LowerTriangBandMatrix;
import no.uib.cipr.matrix.Matrix;
import no.uib.cipr.matrix.MatrixEntry;

public class UnitLowerTriangBandMatrix
extends LowerTriangBandMatrix {
    public UnitLowerTriangBandMatrix(int n, int kd) {
        super(n, kd, BLASkernel.Diag.Unit);
    }

    public UnitLowerTriangBandMatrix(Matrix A, int kd) {
        this(A, kd, true);
    }

    public UnitLowerTriangBandMatrix(Matrix A, int kd, boolean deep) {
        super(A, kd, deep, BLASkernel.Diag.Unit);
    }

    public void add(int row, int column, double value) {
        if (row == column) {
            throw new IllegalArgumentException("row == column");
        }
        super.add(row, column, value);
    }

    public double get(int row, int column) {
        if (row == column) {
            return 1.0;
        }
        return super.get(row, column);
    }

    public void set(int row, int column, double value) {
        if (row == column) {
            throw new IllegalArgumentException("row == column");
        }
        super.set(row, column, value);
    }

    public UnitLowerTriangBandMatrix copy() {
        return new UnitLowerTriangBandMatrix(this, this.kl);
    }

    public Matrix zero() {
        throw new UnsupportedOperationException();
    }

    void copy(Matrix A) {
        for (MatrixEntry e : A) {
            if (!this.inBand(e.row(), e.column()) || e.row() == e.column()) continue;
            this.set(e.row(), e.column(), e.get());
        }
    }
}

