/*
 * Decompiled with CFR 0.152.
 */
package dr.xml.unittest;

import dr.xml.AbstractXMLObjectParser;
import dr.xml.AttributeRule;
import dr.xml.ElementRule;
import dr.xml.Reportable;
import dr.xml.XMLObject;
import dr.xml.XMLParseException;
import dr.xml.XMLSyntaxRule;
import dr.xml.XORRule;
import java.util.logging.Logger;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class BeastUnitTest
implements Reportable {
    private final String message;
    private final String[] actual;
    private final String expected;
    private final int[] indices;
    private Boolean pass;
    private final AssertType assertType;
    private final boolean equalMode;
    private static final String CHECK = "assertEqual";
    private static final String EQUAL = "equal";
    private static final String MESSAGE = "message";
    private static final String EXPECTED = "expected";
    private static final String ACTUAL = "actual";
    private static final String REGEX = "regex";
    private static final String TOLERANCE_STRING = "tolerance";
    private static final String VERBOSE = "verbose";
    private static final String STRIP_CHARACTERS = "charactersToStrip";
    private static final String TOLERANCE_TYPE = "toleranceType";
    private static final String ABSOLUTE = "absolute";
    private static final String RELATIVE = "relative";
    private static final String INDICES = "actualIndices";
    public static AbstractXMLObjectParser PARSER = new AbstractXMLObjectParser(){

        @Override
        public Object parseXMLObject(XMLObject xMLObject) throws XMLParseException {
            AssertType assertType;
            String string = null;
            if (xMLObject.hasChildNamed(BeastUnitTest.MESSAGE)) {
                string = xMLObject.getChild(BeastUnitTest.MESSAGE).getStringChild(0);
            }
            boolean bl = xMLObject.getAttribute(BeastUnitTest.EQUAL, true);
            String[] stringArray = this.parseValues(xMLObject.getChild(BeastUnitTest.EXPECTED));
            if (stringArray.length != 1) {
                throw new XMLParseException("There should only be one 'expected' value.");
            }
            String string2 = stringArray[0];
            String[] stringArray2 = this.parseValues(xMLObject.getChild(BeastUnitTest.ACTUAL));
            String string3 = xMLObject.getAttribute(BeastUnitTest.STRIP_CHARACTERS, ",");
            if (xMLObject.hasAttribute(BeastUnitTest.TOLERANCE_STRING)) {
                AssertType.DoubleAssert.ToleranceType toleranceType;
                double d = xMLObject.getDoubleAttribute(BeastUnitTest.TOLERANCE_STRING);
                String string4 = xMLObject.getAttribute(BeastUnitTest.TOLERANCE_TYPE, BeastUnitTest.ABSOLUTE);
                if (string4.equalsIgnoreCase(BeastUnitTest.ABSOLUTE)) {
                    toleranceType = AssertType.DoubleAssert.ToleranceType.ABSOLUTE;
                } else if (string4.equalsIgnoreCase(BeastUnitTest.RELATIVE)) {
                    toleranceType = AssertType.DoubleAssert.ToleranceType.RELATIVE;
                } else {
                    throw new XMLParseException("The optional attribute toleranceType must be either \"relative\" or \"absolute\"");
                }
                assertType = new AssertType.DoubleAssert(d, toleranceType, string3);
            } else {
                assertType = new AssertType.StringAssert();
            }
            int[] nArray = null;
            if (xMLObject.hasAttribute(BeastUnitTest.INDICES)) {
                nArray = xMLObject.getIntegerArrayAttribute(BeastUnitTest.INDICES);
            }
            BeastUnitTest beastUnitTest = new BeastUnitTest(string, stringArray2, string2, assertType, nArray, bl);
            beastUnitTest.execute();
            if (xMLObject.getAttribute(BeastUnitTest.VERBOSE, false).booleanValue()) {
                Logger.getLogger("dr.xml.unittest").info(beastUnitTest.getReport());
            }
            return beastUnitTest;
        }

        private String[] parseValues(XMLObject xMLObject) throws XMLParseException {
            int n = xMLObject.getChildCount();
            String[] stringArray = new String[n];
            for (int i = 0; i < n; ++i) {
                if (xMLObject.getChild(i) instanceof Reportable) {
                    Reportable reportable = (Reportable)xMLObject.getChild(i);
                    stringArray[i] = reportable.getReport();
                    continue;
                }
                stringArray[i] = xMLObject.getStringChild(i);
            }
            if (xMLObject.hasAttribute(BeastUnitTest.REGEX)) {
                Pattern pattern = Pattern.compile(xMLObject.getStringAttribute(BeastUnitTest.REGEX));
                for (int i = 0; i < n; ++i) {
                    Matcher matcher = pattern.matcher(stringArray[i]);
                    if (!matcher.find()) continue;
                    stringArray[i] = matcher.group(1);
                }
            }
            return stringArray;
        }

        @Override
        public XMLSyntaxRule[] getSyntaxRules() {
            return rules;
        }

        @Override
        public String getParserDescription() {
            return null;
        }

        @Override
        public Class getReturnType() {
            return BeastUnitTest.class;
        }

        @Override
        public String getParserName() {
            return BeastUnitTest.CHECK;
        }
    };
    private static final XMLSyntaxRule[] rules = new XMLSyntaxRule[]{AttributeRule.newBooleanRule("equal", true), new ElementRule("expected", new XMLSyntaxRule[]{new XORRule(new ElementRule(Reportable.class), new ElementRule(String.class)), AttributeRule.newStringRule("regex", true)}), new ElementRule("actual", new XMLSyntaxRule[]{new XORRule(new ElementRule(Reportable.class, 1, Integer.MAX_VALUE), new ElementRule(String.class, 1, Integer.MAX_VALUE)), AttributeRule.newStringRule("regex", true)}), new ElementRule("message", new XMLSyntaxRule[]{new ElementRule(String.class)}, true), AttributeRule.newDoubleRule("tolerance", true), AttributeRule.newBooleanRule("verbose", true), AttributeRule.newStringRule("toleranceType", true), AttributeRule.newIntegerArrayRule("actualIndices", true)};

    public BeastUnitTest(String string, String[] stringArray, String string2, AssertType assertType, int[] nArray, boolean bl) {
        this.message = string;
        this.actual = stringArray;
        this.expected = string2;
        this.assertType = assertType;
        this.indices = nArray;
        this.equalMode = bl;
    }

    public void execute() {
        for (int i = 0; i < this.actual.length; ++i) {
            boolean bl;
            boolean bl2 = this.equalMode ? this.assertType.equivalent(this.actual[i], this.indices, this.expected) : (bl = !this.assertType.equivalent(this.actual[i], this.indices, this.expected));
            if (bl) continue;
            this.failCheck(i);
        }
        this.pass = true;
    }

    private void failCheck(int n) {
        String string = this.formatName() + ": '" + this.actual[n] + "' != '" + this.expected + "'";
        System.err.println(string);
        System.exit(-1);
    }

    private String formatName() {
        return "assert" + (this.message != null ? " " + this.message : "");
    }

    private String getPass() {
        return this.pass != null ? (this.pass.booleanValue() ? "passed" : "fail") : "not executed";
    }

    @Override
    public String getReport() {
        return this.formatName() + ": " + this.getPass();
    }

    static interface AssertType {
        public boolean equivalent(String var1, int[] var2, String var3);

        public static class DoubleAssert
        implements AssertType {
            private final double tolerance;
            private final String stripChars;
            private final ToleranceType toleranceType;

            DoubleAssert(double d, ToleranceType toleranceType, String string) {
                this.tolerance = d;
                this.stripChars = string;
                this.toleranceType = toleranceType;
            }

            @Override
            public boolean equivalent(String string, int[] nArray, String string2) {
                double[] dArray;
                double[] dArray2 = this.parseArray(string, nArray);
                if (dArray2.length != (dArray = this.parseArray(string2, null)).length) {
                    System.err.println("The dimensions of the \"actual\" and \"expected\" values are not the same.");
                    return false;
                }
                for (int i = 0; i < dArray2.length; ++i) {
                    if (this.toleranceType.close(dArray2[i], dArray[i], this.tolerance)) continue;
                    System.err.println("Dimension " + (i + 1) + " of \"actual\" does not match \" expected\". (" + dArray2[i] + " != " + dArray[i] + ")");
                    return false;
                }
                return true;
            }

            private double[] parseArray(String string, int[] nArray) {
                double[] dArray;
                string = string.replaceAll(",", " ");
                string = string.replaceAll("[" + this.stripChars + "]", " ");
                string = string.trim();
                String[] stringArray = string.split("\\s+");
                if (nArray == null) {
                    dArray = new double[stringArray.length];
                    for (int i = 0; i < stringArray.length; ++i) {
                        dArray[i] = Double.parseDouble(stringArray[i]);
                    }
                } else {
                    dArray = new double[nArray.length];
                    int n = 0;
                    for (int n2 : nArray) {
                        dArray[n] = Double.parseDouble(stringArray[n2]);
                        ++n;
                    }
                }
                return dArray;
            }

            static enum ToleranceType {
                RELATIVE{

                    @Override
                    boolean close(double d, double d2, double d3) {
                        double d4 = Math.abs(d3 * d2);
                        return ABSOLUTE.close(d, d2, d4);
                    }
                }
                ,
                ABSOLUTE{

                    @Override
                    boolean close(double d, double d2, double d3) {
                        return Math.abs(d - d2) < d3;
                    }
                };


                abstract boolean close(double var1, double var3, double var5);
            }
        }

        public static class StringAssert
        implements AssertType {
            @Override
            public boolean equivalent(String string, int[] nArray, String string2) {
                return string.compareTo(string2) == 0;
            }
        }
    }
}

