/*
 * Decompiled with CFR 0.152.
 */
package dr.math.matrixAlgebra;

import dr.math.MathUtils;
import dr.math.matrixAlgebra.EJMLUtils;
import org.ejml.data.D1Matrix64F;
import org.ejml.data.DenseMatrix64F;
import org.ejml.factory.DecompositionFactory;
import org.ejml.interfaces.decomposition.SingularValueDecomposition;
import org.ejml.ops.CommonOps;

public class SkewSymmetricMatrixExponential {
    private final int dim;
    private final DenseMatrix64F S;
    private final DenseMatrix64F B1;
    private final DenseMatrix64F B2;
    private final DenseMatrix64F B3;
    private final DenseMatrix64F P1;
    private final DenseMatrix64F P2;
    private final DenseMatrix64F buffer;

    public SkewSymmetricMatrixExponential(int n) {
        this.dim = n;
        this.S = new DenseMatrix64F(n, n);
        this.B1 = new DenseMatrix64F(n, n);
        this.B2 = new DenseMatrix64F(n, n);
        this.B3 = new DenseMatrix64F(n, n);
        this.P1 = new DenseMatrix64F(n, n);
        this.P2 = new DenseMatrix64F(n, n);
        this.buffer = new DenseMatrix64F(n, n);
    }

    public void exponentiate(double[] dArray, double[] dArray2) {
        int n = this.dim * this.dim;
        if (dArray.length != n || dArray2.length != n) {
            throw new IllegalArgumentException("At least one matrix is of wrong dimension.");
        }
        System.arraycopy(dArray, 0, this.S.data, 0, n);
        SingularValueDecomposition<DenseMatrix64F> singularValueDecomposition = DecompositionFactory.svd(this.dim, this.dim, false, false, true);
        singularValueDecomposition.decompose(this.S);
        double[] dArray3 = singularValueDecomposition.getSingularValues();
        double d = MathUtils.maximum(dArray3);
        double d2 = 1.0;
        int n2 = 0;
        while (d > 1.0) {
            ++n2;
            d *= 0.5;
            d2 *= 0.5;
        }
        CommonOps.scale(d2, this.S);
        CommonOps.mult(this.S, this.S, this.B1);
        CommonOps.mult(this.B1, this.B1, this.B2);
        CommonOps.mult(this.B1, this.B2, this.B3);
        EJMLUtils.setScaledIdentity(this.P1, 1.729728E7);
        CommonOps.addEquals(this.P1, 1995840.0, this.B1);
        CommonOps.addEquals(this.P1, 25200.0, this.B2);
        CommonOps.addEquals(this.P1, 56.0, this.B3);
        EJMLUtils.setScaledIdentity(this.buffer, 8648640.0);
        CommonOps.addEquals(this.buffer, 277200.0, this.B1);
        CommonOps.addEquals(this.buffer, 1512.0, this.B2);
        CommonOps.addEquals(this.buffer, this.B3);
        CommonOps.mult(this.S, this.buffer, this.P2);
        CommonOps.subtract((D1Matrix64F)this.P1, (D1Matrix64F)this.P2, (D1Matrix64F)this.B1);
        CommonOps.add((D1Matrix64F)this.P1, this.P2, (D1Matrix64F)this.B2);
        CommonOps.solve(this.B1, this.B2, this.S);
        for (int i = 0; i < n2; ++i) {
            System.arraycopy(this.S.data, 0, this.B1.data, 0, this.S.data.length);
            CommonOps.mult(this.B1, this.B1, this.S);
        }
        System.arraycopy(this.S.data, 0, dArray2, 0, this.S.data.length);
    }
}

