/*
 * Decompiled with CFR 0.152.
 */
package dr.evomodel.antigenic;

import dr.evomodel.antigenic.NewAntigenicLikelihood;
import dr.inference.model.Parameter;
import java.util.Arrays;

public interface AntigenicGradientWrtParameter {
    public boolean requiresLocationGradient();

    public boolean requiresObservationGradient();

    public int getSize();

    public void getGradient(double[] var1, int var2, double[] var3, double[] var4);

    public Parameter getParameter();

    public static abstract class Base
    implements AntigenicGradientWrtParameter {
        final int viruses;
        final int sera;
        final int mdsDim;
        final Parameter parameter;

        Base(int n, int n2, int n3, Parameter parameter) {
            this.viruses = n;
            this.sera = n2;
            this.mdsDim = n3;
            this.parameter = parameter;
        }

        @Override
        public Parameter getParameter() {
            return this.parameter;
        }
    }

    public static class Drift
    extends Locations {
        private final Parameter virusTime;
        private final Parameter serumTime;

        Drift(int n, int n2, int n3, Parameter parameter, Parameter parameter2, Parameter parameter3, NewAntigenicLikelihood.Layout layout) {
            super(n, n2, n3, parameter, layout);
            this.virusTime = parameter2;
            this.serumTime = parameter3;
        }

        @Override
        int getLocationOffset() {
            throw new RuntimeException("Should not be called");
        }

        @Override
        public int getSize() {
            return 1;
        }

        @Override
        public void getGradient(double[] dArray, int n, double[] dArray2, double[] dArray3) {
            int n2;
            double d = 0.0;
            int n3 = this.layout.getVirusLocationOffset();
            for (n2 = 0; n2 < this.viruses; ++n2) {
                d += dArray2[n3 + n2 * this.mdsDim] * this.virusTime.getParameterValue(n2);
            }
            n2 = this.layout.getSerumLocationOffset();
            for (int i = 0; i < this.sera; ++i) {
                d += dArray2[n2 + i * this.mdsDim] * this.serumTime.getParameterValue(i);
            }
            dArray[n] = d;
        }
    }

    public static abstract class Locations
    extends Base {
        final NewAntigenicLikelihood.Layout layout;

        Locations(int n, int n2, int n3, Parameter parameter, NewAntigenicLikelihood.Layout layout) {
            super(n, n2, n3, parameter);
            this.layout = layout;
        }

        abstract int getLocationOffset();

        @Override
        public abstract int getSize();

        @Override
        public boolean requiresLocationGradient() {
            return true;
        }

        @Override
        public boolean requiresObservationGradient() {
            return false;
        }

        @Override
        public void getGradient(double[] dArray, int n, double[] dArray2, double[] dArray3) {
            System.arraycopy(dArray2, this.getLocationOffset(), dArray, n, this.getSize());
        }
    }

    public static class SerumLocations
    extends Locations {
        SerumLocations(int n, int n2, int n3, Parameter parameter, NewAntigenicLikelihood.Layout layout) {
            super(n, n2, n3, parameter, layout);
        }

        @Override
        int getLocationOffset() {
            return this.layout.getSerumLocationOffset();
        }

        @Override
        public int getSize() {
            return this.sera * this.mdsDim;
        }
    }

    public static class VirusLocations
    extends Locations {
        private final int startOffset;
        private final int tipSize;

        VirusLocations(int n, int n2, int n3, Parameter parameter, NewAntigenicLikelihood.Layout layout, int n4, int n5) {
            super(n, n2, n3, parameter, layout);
            this.startOffset = n4;
            this.tipSize = n5;
        }

        @Override
        public void getGradient(double[] dArray, int n, double[] dArray2, double[] dArray3) {
            if (this.tipSize == this.mdsDim) {
                super.getGradient(dArray, n, dArray2, dArray3);
            } else {
                int n2 = this.getLocationOffset();
                Arrays.fill(dArray, n, n + this.getSize(), 0.0);
                for (int i = 0; i < this.viruses; ++i) {
                    for (int j = 0; j < this.mdsDim; ++j) {
                        dArray[n + i * this.tipSize + this.startOffset + j] = dArray2[n2 + i * this.mdsDim + j];
                    }
                }
            }
        }

        @Override
        int getLocationOffset() {
            return this.layout.getVirusLocationOffset();
        }

        @Override
        public int getSize() {
            return this.viruses * this.tipSize;
        }
    }
}

