/*
 * Decompiled with CFR 0.152.
 */
package org.ddahl.commonsmath;

import java.io.Serializable;
import org.apache.commons.math3.distribution.AbstractIntegerDistribution;
import org.apache.commons.math3.distribution.AbstractRealDistribution;
import org.apache.commons.math3.distribution.BetaDistribution;
import org.apache.commons.math3.distribution.BinomialDistribution;
import org.apache.commons.math3.distribution.ChiSquaredDistribution;
import org.apache.commons.math3.distribution.ExponentialDistribution;
import org.apache.commons.math3.distribution.FDistribution;
import org.apache.commons.math3.distribution.GammaDistribution;
import org.apache.commons.math3.distribution.GeometricDistribution;
import org.apache.commons.math3.distribution.NormalDistribution;
import org.apache.commons.math3.distribution.PascalDistribution;
import org.apache.commons.math3.distribution.PoissonDistribution;
import org.apache.commons.math3.distribution.TDistribution;
import org.apache.commons.math3.distribution.UniformRealDistribution;
import org.apache.commons.math3.random.RandomGenerator;
import org.apache.commons.math3.random.Well44497b;
import org.apache.commons.math3.special.Beta;
import org.apache.commons.math3.special.Gamma;
import org.apache.commons.math3.util.FastMath;
import scala.Array$;
import scala.Function0;
import scala.Function1;
import scala.Predef$;
import scala.Tuple2;
import scala.collection.GenIterable;
import scala.collection.mutable.ArrayOps;
import scala.math.Numeric;
import scala.math.package$;
import scala.reflect.ClassTag;
import scala.reflect.ClassTag$;
import scala.runtime.BoxesRunTime;
import scala.runtime.DoubleRef;
import scala.runtime.ScalaRunTime$;
import scala.runtime.java8.JFunction0;
import scala.runtime.java8.JFunction1;

public final class Transcompile$ {
    public static Transcompile$ MODULE$;
    private final Well44497b rng;
    private final UniformRealDistribution stdUniform;
    private final NormalDistribution stdNormal;
    private final GammaDistribution stdGamma;
    private final ExponentialDistribution stdExp;
    private final BetaDistribution stdBeta;
    private final TDistribution stdT;
    private final ChiSquaredDistribution stdChiSquared;
    private final FDistribution stdF;
    private final BinomialDistribution stdBinomial;
    private final PascalDistribution stdNegativeBinomial;
    private final PoissonDistribution stdPoisson;
    private final GeometricDistribution stdGeometric;

    static {
        new Transcompile$();
    }

    private Well44497b rng() {
        return this.rng;
    }

    private int r2int(double x) {
        return (int)FastMath.round((double)x);
    }

    public double _gamma(double x) {
        return Gamma.gamma((double)x);
    }

    public double[] _gamma(double[] x) {
        return (double[])new ArrayOps.ofDouble(Predef$.MODULE$.doubleArrayOps(x)).map((Function1)(JFunction1.mcDD.sp & Serializable & scala.Serializable)x$1 -> Gamma.gamma((double)x$1), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.Double()));
    }

    public double[] _gamma(int[] x) {
        return (double[])new ArrayOps.ofInt(Predef$.MODULE$.intArrayOps(x)).map((Function1)(JFunction1.mcDI.sp & Serializable & scala.Serializable)z -> Gamma.gamma((double)z), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.Double()));
    }

    public double _lgamma(double x) {
        return Gamma.logGamma((double)x);
    }

    public double[] _lgamma(double[] x) {
        return (double[])new ArrayOps.ofDouble(Predef$.MODULE$.doubleArrayOps(x)).map((Function1)(JFunction1.mcDD.sp & Serializable & scala.Serializable)x$1 -> Gamma.logGamma((double)x$1), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.Double()));
    }

    public double[] _lgamma(int[] x) {
        return (double[])new ArrayOps.ofInt(Predef$.MODULE$.intArrayOps(x)).map((Function1)(JFunction1.mcDI.sp & Serializable & scala.Serializable)z -> Gamma.logGamma((double)z), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.Double()));
    }

    public double _beta(double x, double y) {
        return FastMath.exp((double)Beta.logBeta((double)x, (double)y));
    }

    public double[] _beta(double[] x, double[] y) {
        return (double[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])new ArrayOps.ofDouble(Predef$.MODULE$.doubleArrayOps(x)).zip((GenIterable)Predef$.MODULE$.wrapDoubleArray(y), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(Tuple2.class))))).map((Function1 & Serializable & scala.Serializable)z -> BoxesRunTime.boxToDouble((double)Transcompile$.$anonfun$_beta$1(z)), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.Double()));
    }

    public double[] _beta(int[] x, double[] y) {
        return (double[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])new ArrayOps.ofInt(Predef$.MODULE$.intArrayOps(x)).zip((GenIterable)Predef$.MODULE$.wrapDoubleArray(y), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(Tuple2.class))))).map((Function1 & Serializable & scala.Serializable)z -> BoxesRunTime.boxToDouble((double)Transcompile$.$anonfun$_beta$2(z)), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.Double()));
    }

    public double[] _beta(double[] x, int[] y) {
        return (double[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])new ArrayOps.ofDouble(Predef$.MODULE$.doubleArrayOps(x)).zip((GenIterable)Predef$.MODULE$.wrapIntArray(y), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(Tuple2.class))))).map((Function1 & Serializable & scala.Serializable)z -> BoxesRunTime.boxToDouble((double)Transcompile$.$anonfun$_beta$3(z)), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.Double()));
    }

    public double[] _beta(int[] x, int[] y) {
        return (double[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])new ArrayOps.ofInt(Predef$.MODULE$.intArrayOps(x)).zip((GenIterable)Predef$.MODULE$.wrapIntArray(y), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(Tuple2.class))))).map((Function1 & Serializable & scala.Serializable)z -> BoxesRunTime.boxToDouble((double)Transcompile$.$anonfun$_beta$4(z)), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.Double()));
    }

    public double _lbeta(double x, double y) {
        return Beta.logBeta((double)x, (double)y);
    }

    public double[] _lbeta(double[] x, double[] y) {
        return (double[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])new ArrayOps.ofDouble(Predef$.MODULE$.doubleArrayOps(x)).zip((GenIterable)Predef$.MODULE$.wrapDoubleArray(y), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(Tuple2.class))))).map((Function1 & Serializable & scala.Serializable)z -> BoxesRunTime.boxToDouble((double)Transcompile$.$anonfun$_lbeta$1(z)), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.Double()));
    }

    public double[] _lbeta(int[] x, double[] y) {
        return (double[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])new ArrayOps.ofInt(Predef$.MODULE$.intArrayOps(x)).zip((GenIterable)Predef$.MODULE$.wrapDoubleArray(y), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(Tuple2.class))))).map((Function1 & Serializable & scala.Serializable)z -> BoxesRunTime.boxToDouble((double)Transcompile$.$anonfun$_lbeta$2(z)), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.Double()));
    }

    public double[] _lbeta(double[] x, int[] y) {
        return (double[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])new ArrayOps.ofDouble(Predef$.MODULE$.doubleArrayOps(x)).zip((GenIterable)Predef$.MODULE$.wrapIntArray(y), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(Tuple2.class))))).map((Function1 & Serializable & scala.Serializable)z -> BoxesRunTime.boxToDouble((double)Transcompile$.$anonfun$_lbeta$3(z)), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.Double()));
    }

    public double[] _lbeta(int[] x, int[] y) {
        return (double[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])new ArrayOps.ofInt(Predef$.MODULE$.intArrayOps(x)).zip((GenIterable)Predef$.MODULE$.wrapIntArray(y), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(Tuple2.class))))).map((Function1 & Serializable & scala.Serializable)z -> BoxesRunTime.boxToDouble((double)Transcompile$.$anonfun$_lbeta$4(z)), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.Double()));
    }

    public double _factorial(double x) {
        return Gamma.gamma((double)(x + 1.0));
    }

    public double[] _factorial(double[] x) {
        return (double[])new ArrayOps.ofDouble(Predef$.MODULE$.doubleArrayOps(x)).map((Function1)(JFunction1.mcDD.sp & Serializable & scala.Serializable)z -> Gamma.gamma((double)(z + 1.0)), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.Double()));
    }

    public double[] _factorial(int[] x) {
        return (double[])new ArrayOps.ofInt(Predef$.MODULE$.intArrayOps(x)).map((Function1)(JFunction1.mcDI.sp & Serializable & scala.Serializable)z -> Gamma.gamma((double)(z + 1)), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.Double()));
    }

    public double _lfactorial(double x) {
        return Gamma.logGamma((double)(x + 1.0));
    }

    public double[] _lfactorial(double[] x) {
        return (double[])new ArrayOps.ofDouble(Predef$.MODULE$.doubleArrayOps(x)).map((Function1)(JFunction1.mcDD.sp & Serializable & scala.Serializable)z -> Gamma.logGamma((double)(z + 1.0)), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.Double()));
    }

    public double[] _lfactorial(int[] x) {
        return (double[])new ArrayOps.ofInt(Predef$.MODULE$.intArrayOps(x)).map((Function1)(JFunction1.mcDI.sp & Serializable & scala.Serializable)z -> Gamma.logGamma((double)(z + 1)), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.Double()));
    }

    public double _choose(double n, double k) {
        int kk = this.r2int(k);
        return FastMath.exp((double)(Gamma.logGamma((double)(n + 1.0)) - Gamma.logGamma((double)(kk + 1)) - Gamma.logGamma((double)(n - (double)kk + 1.0))));
    }

    public double[] _choose(double[] n, double[] k) {
        return (double[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])new ArrayOps.ofDouble(Predef$.MODULE$.doubleArrayOps(n)).zip((GenIterable)Predef$.MODULE$.wrapIntArray((int[])new ArrayOps.ofDouble(Predef$.MODULE$.doubleArrayOps(k)).map((Function1)(JFunction1.mcID.sp & Serializable & scala.Serializable)x -> MODULE$.r2int(x), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.Int()))), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(Tuple2.class))))).map((Function1 & Serializable & scala.Serializable)z -> BoxesRunTime.boxToDouble((double)Transcompile$.$anonfun$_choose$2(z)), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.Double()));
    }

    public double[] _choose(int[] n, double[] k) {
        return (double[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])new ArrayOps.ofInt(Predef$.MODULE$.intArrayOps(n)).zip((GenIterable)Predef$.MODULE$.wrapIntArray((int[])new ArrayOps.ofDouble(Predef$.MODULE$.doubleArrayOps(k)).map((Function1)(JFunction1.mcID.sp & Serializable & scala.Serializable)x -> MODULE$.r2int(x), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.Int()))), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(Tuple2.class))))).map((Function1 & Serializable & scala.Serializable)z -> BoxesRunTime.boxToDouble((double)Transcompile$.$anonfun$_choose$4(z)), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.Double()));
    }

    public double[] _choose(double[] n, int[] k) {
        return (double[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])new ArrayOps.ofDouble(Predef$.MODULE$.doubleArrayOps(n)).zip((GenIterable)Predef$.MODULE$.wrapIntArray(k), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(Tuple2.class))))).map((Function1 & Serializable & scala.Serializable)z -> BoxesRunTime.boxToDouble((double)Transcompile$.$anonfun$_choose$5(z)), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.Double()));
    }

    public double[] _choose(int[] n, int[] k) {
        return (double[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])new ArrayOps.ofInt(Predef$.MODULE$.intArrayOps(n)).zip((GenIterable)Predef$.MODULE$.wrapIntArray(k), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(Tuple2.class))))).map((Function1 & Serializable & scala.Serializable)z -> BoxesRunTime.boxToDouble((double)Transcompile$.$anonfun$_choose$6(z)), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.Double()));
    }

    public double _lchoose(double n, double k) {
        int kk = this.r2int(k);
        return Gamma.logGamma((double)(n + 1.0)) - Gamma.logGamma((double)(kk + 1)) - Gamma.logGamma((double)(n - (double)kk + 1.0));
    }

    public double[] _lchoose(double[] n, double[] k) {
        return (double[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])new ArrayOps.ofDouble(Predef$.MODULE$.doubleArrayOps(n)).zip((GenIterable)Predef$.MODULE$.wrapIntArray((int[])new ArrayOps.ofDouble(Predef$.MODULE$.doubleArrayOps(k)).map((Function1)(JFunction1.mcID.sp & Serializable & scala.Serializable)x -> MODULE$.r2int(x), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.Int()))), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(Tuple2.class))))).map((Function1 & Serializable & scala.Serializable)z -> BoxesRunTime.boxToDouble((double)Transcompile$.$anonfun$_lchoose$2(z)), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.Double()));
    }

    public double[] _lchoose(int[] n, double[] k) {
        return (double[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])new ArrayOps.ofInt(Predef$.MODULE$.intArrayOps(n)).zip((GenIterable)Predef$.MODULE$.wrapIntArray((int[])new ArrayOps.ofDouble(Predef$.MODULE$.doubleArrayOps(k)).map((Function1)(JFunction1.mcID.sp & Serializable & scala.Serializable)x -> MODULE$.r2int(x), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.Int()))), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(Tuple2.class))))).map((Function1 & Serializable & scala.Serializable)z -> BoxesRunTime.boxToDouble((double)Transcompile$.$anonfun$_lchoose$4(z)), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.Double()));
    }

    public double[] _lchoose(double[] n, int[] k) {
        return (double[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])new ArrayOps.ofDouble(Predef$.MODULE$.doubleArrayOps(n)).zip((GenIterable)Predef$.MODULE$.wrapIntArray(k), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(Tuple2.class))))).map((Function1 & Serializable & scala.Serializable)z -> BoxesRunTime.boxToDouble((double)Transcompile$.$anonfun$_lchoose$5(z)), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.Double()));
    }

    public double[] _lchoose(int[] n, int[] k) {
        return (double[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])new ArrayOps.ofInt(Predef$.MODULE$.intArrayOps(n)).zip((GenIterable)Predef$.MODULE$.wrapIntArray(k), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(Tuple2.class))))).map((Function1 & Serializable & scala.Serializable)z -> BoxesRunTime.boxToDouble((double)Transcompile$.$anonfun$_lchoose$6(z)), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.Double()));
    }

    public int[] _sample(double x) {
        return (int[])this._sample(Array$.MODULE$.range(1, this.r2int(x) + 1), this._sample$default$2(), this._sample$default$3(), this._sample$default$4(), ClassTag$.MODULE$.Int());
    }

    public int[] _sample(double x, double size) {
        return (int[])this._sample(Array$.MODULE$.range(1, this.r2int(x) + 1), size, this._sample$default$3(), this._sample$default$4(), ClassTag$.MODULE$.Int());
    }

    public int[] _sample(double x, boolean replace) {
        return (int[])this._sample(Array$.MODULE$.range(1, this.r2int(x) + 1), this.r2int(x), replace, this._sample$default$4(), ClassTag$.MODULE$.Int());
    }

    public int[] _sample(double x, double size, boolean replace) {
        return (int[])this._sample(Array$.MODULE$.range(1, this.r2int(x) + 1), size, replace, this._sample$default$4(), ClassTag$.MODULE$.Int());
    }

    public int[] _sample(double x, double size, boolean replace, double[] prob) {
        return (int[])this._sample(Array$.MODULE$.range(1, this.r2int(x) + 1), size, replace, prob, ClassTag$.MODULE$.Int());
    }

    public int[] _sample(double x, double size, double[] prob) {
        return (int[])this._sample(Array$.MODULE$.range(1, this.r2int(x) + 1), size, false, prob, ClassTag$.MODULE$.Int());
    }

    public int[] _sample(double x, boolean replace, double[] prob) {
        return (int[])this._sample(Array$.MODULE$.range(1, this.r2int(x) + 1), this.r2int(x), replace, prob, ClassTag$.MODULE$.Int());
    }

    public int[] _sample(double x, double[] prob) {
        return (int[])this._sample(Array$.MODULE$.range(1, this.r2int(x) + 1), this.r2int(x), false, prob, ClassTag$.MODULE$.Int());
    }

    public <T> Object _sample(Object x, double size, boolean replace, double[] prob, ClassTag<T> evidence$1) {
        double[] p;
        double[] dArray = p = prob == null ? (double[])Array$.MODULE$.fill(ScalaRunTime$.MODULE$.array_length(x), (Function0)(JFunction0.mcD.sp & Serializable & scala.Serializable)() -> 1.0, ClassTag$.MODULE$.Double()) : (double[])new ArrayOps.ofDouble(Predef$.MODULE$.doubleArrayOps(prob)).map((Function1)(JFunction1.mcDD.sp & Serializable & scala.Serializable)x$1 -> package$.MODULE$.max(0.0, x$1), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.Double()));
        if (ScalaRunTime$.MODULE$.array_length(x) != p.length) {
            throw scala.sys.package$.MODULE$.error("Length of 'x' and 'prob' must be same.");
        }
        int s = Double.isNaN(size) ? ScalaRunTime$.MODULE$.array_length(x) : this.r2int(size);
        Tuple2[] pairs = (Tuple2[])Predef$.MODULE$.genericArrayOps(x).zip((GenIterable)Predef$.MODULE$.wrapDoubleArray(p), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(Tuple2.class)));
        DoubleRef total = DoubleRef.create((double)BoxesRunTime.unboxToDouble((Object)new ArrayOps.ofDouble(Predef$.MODULE$.doubleArrayOps(p)).sum((Numeric)Numeric.DoubleIsFractional$.MODULE$)));
        if (!replace && s > ScalaRunTime$.MODULE$.array_length(x)) {
            throw scala.sys.package$.MODULE$.error("Cannot take a sample larger than the population when 'replace = FALSE'.");
        }
        return Array$.MODULE$.fill(s, (Function0 & Serializable & scala.Serializable)() -> {
            int i;
            block1: {
                double u = total$1.elem * MODULE$.rng().nextDouble();
                double cumsum = 0.0;
                i = 0;
                while (cumsum <= u) {
                    cumsum += pairs[i]._2$mcD$sp();
                    ++i;
                }
                --i;
                if (replace) break block1;
                total$1.elem -= pairs[i]._2$mcD$sp();
                pairs$1[i] = new Tuple2(pairs[i]._1(), (Object)BoxesRunTime.boxToDouble((double)0.0));
            }
            return pairs[i]._1();
        }, evidence$1);
    }

    public <T> double _sample$default$2() {
        return Double.NaN;
    }

    public <T> boolean _sample$default$3() {
        return false;
    }

    public <T> double[] _sample$default$4() {
        return null;
    }

    private double dI(AbstractIntegerDistribution dist, double x) {
        return dist.probability(this.r2int(x));
    }

    private double d(AbstractRealDistribution dist, double x) {
        return dist.density(x);
    }

    private double[] dI(AbstractIntegerDistribution dist, double[] x, boolean log) {
        if (log) {
            return (double[])new ArrayOps.ofDouble(Predef$.MODULE$.doubleArrayOps(x)).map((Function1)(JFunction1.mcDD.sp & Serializable & scala.Serializable)xx -> dist.logProbability(MODULE$.r2int(xx)), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.Double()));
        }
        return (double[])new ArrayOps.ofDouble(Predef$.MODULE$.doubleArrayOps(x)).map((Function1)(JFunction1.mcDD.sp & Serializable & scala.Serializable)xx -> dist.probability(MODULE$.r2int(xx)), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.Double()));
    }

    private double[] d(AbstractRealDistribution dist, double[] x, boolean log) {
        if (log) {
            return (double[])new ArrayOps.ofDouble(Predef$.MODULE$.doubleArrayOps(x)).map((Function1)(JFunction1.mcDD.sp & Serializable & scala.Serializable)xx -> dist.logDensity(xx), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.Double()));
        }
        return (double[])new ArrayOps.ofDouble(Predef$.MODULE$.doubleArrayOps(x)).map((Function1)(JFunction1.mcDD.sp & Serializable & scala.Serializable)xx -> dist.density(xx), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.Double()));
    }

    private double pI(AbstractIntegerDistribution dist, double q) {
        return dist.cumulativeProbability(this.r2int(q));
    }

    private double p(AbstractRealDistribution dist, double q) {
        return dist.cumulativeProbability(q);
    }

    private double[] pI(AbstractIntegerDistribution dist, double[] q, boolean lower_tail) {
        if (lower_tail) {
            return (double[])new ArrayOps.ofDouble(Predef$.MODULE$.doubleArrayOps(q)).map((Function1)(JFunction1.mcDD.sp & Serializable & scala.Serializable)qq -> dist.cumulativeProbability(MODULE$.r2int(qq)), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.Double()));
        }
        return (double[])new ArrayOps.ofDouble(Predef$.MODULE$.doubleArrayOps(q)).map((Function1)(JFunction1.mcDD.sp & Serializable & scala.Serializable)qq -> 1.0 - dist.cumulativeProbability(MODULE$.r2int(qq)), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.Double()));
    }

    private double[] p(AbstractRealDistribution dist, double[] q, boolean lower_tail) {
        if (lower_tail) {
            return (double[])new ArrayOps.ofDouble(Predef$.MODULE$.doubleArrayOps(q)).map((Function1)(JFunction1.mcDD.sp & Serializable & scala.Serializable)qq -> dist.cumulativeProbability(qq), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.Double()));
        }
        return (double[])new ArrayOps.ofDouble(Predef$.MODULE$.doubleArrayOps(q)).map((Function1)(JFunction1.mcDD.sp & Serializable & scala.Serializable)qq -> 1.0 - dist.cumulativeProbability(qq), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.Double()));
    }

    private double qI(AbstractIntegerDistribution dist, double p) {
        return dist.inverseCumulativeProbability(p);
    }

    private double q(AbstractRealDistribution dist, double p) {
        return dist.inverseCumulativeProbability(p);
    }

    private double[] qI(AbstractIntegerDistribution dist, double[] p, boolean lower_tail) {
        if (lower_tail) {
            return (double[])new ArrayOps.ofDouble(Predef$.MODULE$.doubleArrayOps(p)).map((Function1)(JFunction1.mcDD.sp & Serializable & scala.Serializable)pp -> dist.inverseCumulativeProbability(pp), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.Double()));
        }
        return (double[])new ArrayOps.ofDouble(Predef$.MODULE$.doubleArrayOps(p)).map((Function1)(JFunction1.mcDD.sp & Serializable & scala.Serializable)pp -> dist.inverseCumulativeProbability(1.0 - pp), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.Double()));
    }

    private double[] q(AbstractRealDistribution dist, double[] p, boolean lower_tail) {
        if (lower_tail) {
            return (double[])new ArrayOps.ofDouble(Predef$.MODULE$.doubleArrayOps(p)).map((Function1)(JFunction1.mcDD.sp & Serializable & scala.Serializable)pp -> dist.inverseCumulativeProbability(pp), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.Double()));
        }
        return (double[])new ArrayOps.ofDouble(Predef$.MODULE$.doubleArrayOps(p)).map((Function1)(JFunction1.mcDD.sp & Serializable & scala.Serializable)pp -> dist.inverseCumulativeProbability(1.0 - pp), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.Double()));
    }

    private double rI(AbstractIntegerDistribution dist) {
        return dist.sample();
    }

    private double r(AbstractRealDistribution dist) {
        return dist.sample();
    }

    private double[] rI(AbstractIntegerDistribution dist, double n) {
        return (double[])new ArrayOps.ofInt(Predef$.MODULE$.intArrayOps(dist.sample(this.r2int(n)))).map((Function1)(JFunction1.mcDI.sp & Serializable & scala.Serializable)x$2 -> x$2, Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.Double()));
    }

    private double[] r(AbstractRealDistribution dist, double n) {
        return dist.sample(this.r2int(n));
    }

    private UniformRealDistribution mkUniform(double min, double max) {
        return new UniformRealDistribution((RandomGenerator)this.rng(), min, max);
    }

    private UniformRealDistribution stdUniform() {
        return this.stdUniform;
    }

    public double _dunif(double x) {
        return this.d((AbstractRealDistribution)this.stdUniform(), x);
    }

    public double[] _dunif(double[] x, double min, double max, boolean log) {
        return this.d((AbstractRealDistribution)this.mkUniform(min, max), x, log);
    }

    public double _dunif$default$2() {
        return 0.0;
    }

    public double _dunif$default$3() {
        return 1.0;
    }

    public boolean _dunif$default$4() {
        return false;
    }

    public double _punif(double q) {
        return this.p((AbstractRealDistribution)this.stdUniform(), q);
    }

    public double[] _punif(double[] q, double min, double max, boolean lower_tail) {
        return this.p((AbstractRealDistribution)this.mkUniform(min, max), q, lower_tail);
    }

    public double _punif$default$2() {
        return 0.0;
    }

    public double _punif$default$3() {
        return 1.0;
    }

    public boolean _punif$default$4() {
        return true;
    }

    public double _qunif(double p) {
        return this.q((AbstractRealDistribution)this.stdUniform(), p);
    }

    public double[] _qunif(double[] p, double min, double max, boolean lower_tail) {
        return this.q((AbstractRealDistribution)this.mkUniform(min, max), p, lower_tail);
    }

    public double _qunif$default$2() {
        return 0.0;
    }

    public double _qunif$default$3() {
        return 1.0;
    }

    public boolean _qunif$default$4() {
        return true;
    }

    public double _runif() {
        return this.r((AbstractRealDistribution)this.stdUniform());
    }

    public double[] _runif(double n, double min, double max) {
        return this.r((AbstractRealDistribution)this.mkUniform(min, max), n);
    }

    public double _runif$default$2() {
        return 0.0;
    }

    public double _runif$default$3() {
        return 1.0;
    }

    private NormalDistribution mkNormal(double mean, double sd) {
        return new NormalDistribution((RandomGenerator)this.rng(), mean, sd);
    }

    private NormalDistribution stdNormal() {
        return this.stdNormal;
    }

    public double _dnorm(double x) {
        return this.d((AbstractRealDistribution)this.stdNormal(), x);
    }

    public double[] _dnorm(double[] x, double mean, double sd, boolean log) {
        return this.d((AbstractRealDistribution)this.mkNormal(mean, sd), x, log);
    }

    public double _dnorm$default$2() {
        return 0.0;
    }

    public double _dnorm$default$3() {
        return 1.0;
    }

    public boolean _dnorm$default$4() {
        return false;
    }

    public double _pnorm(double q) {
        return this.p((AbstractRealDistribution)this.stdNormal(), q);
    }

    public double[] _pnorm(double[] q, double mean, double sd, boolean lower_tail) {
        return this.p((AbstractRealDistribution)this.mkNormal(mean, sd), q, lower_tail);
    }

    public double _pnorm$default$2() {
        return 0.0;
    }

    public double _pnorm$default$3() {
        return 1.0;
    }

    public boolean _pnorm$default$4() {
        return true;
    }

    public double _qnorm(double p) {
        return this.q((AbstractRealDistribution)this.stdNormal(), p);
    }

    public double[] _qnorm(double[] p, double mean, double sd, boolean lower_tail) {
        return this.q((AbstractRealDistribution)this.mkNormal(mean, sd), p, lower_tail);
    }

    public double _qnorm$default$2() {
        return 0.0;
    }

    public double _qnorm$default$3() {
        return 1.0;
    }

    public boolean _qnorm$default$4() {
        return true;
    }

    public double _rnorm() {
        return this.r((AbstractRealDistribution)this.stdNormal());
    }

    public double[] _rnorm(double n, double mean, double sd) {
        return this.r((AbstractRealDistribution)this.mkNormal(mean, sd), n);
    }

    public double _rnorm$default$2() {
        return 0.0;
    }

    public double _rnorm$default$3() {
        return 1.0;
    }

    private GammaDistribution mkGamma(double shape, double rate, double scale) {
        if (!Double.isNaN(rate) && !Double.isNaN(scale)) {
            throw scala.sys.package$.MODULE$.error("Only provide one of 'rate' or 'scale'.");
        }
        double scale2 = Double.isNaN(rate) && Double.isNaN(scale) ? 1.0 : (Double.isNaN(rate) ? scale : 1.0 / rate);
        return new GammaDistribution((RandomGenerator)this.rng(), shape, scale2);
    }

    private GammaDistribution stdGamma() {
        return this.stdGamma;
    }

    public double _dgamma(double x) {
        return this.d((AbstractRealDistribution)this.stdGamma(), x);
    }

    public double[] _dgamma(double[] x, double shape, double rate, double scale, boolean log) {
        return this.d((AbstractRealDistribution)this.mkGamma(shape, rate, scale), x, log);
    }

    public double _dgamma$default$3() {
        return Double.NaN;
    }

    public double _dgamma$default$4() {
        return Double.NaN;
    }

    public boolean _dgamma$default$5() {
        return false;
    }

    public double _pgamma(double q) {
        return this.p((AbstractRealDistribution)this.stdGamma(), q);
    }

    public double[] _pgamma(double[] q, double shape, double rate, double scale, boolean lower_tail) {
        return this.p((AbstractRealDistribution)this.mkGamma(shape, rate, scale), q, lower_tail);
    }

    public double _pgamma$default$3() {
        return Double.NaN;
    }

    public double _pgamma$default$4() {
        return Double.NaN;
    }

    public boolean _pgamma$default$5() {
        return true;
    }

    public double _qgamma(double p) {
        return this.q((AbstractRealDistribution)this.stdGamma(), p);
    }

    public double[] _qgamma(double[] p, double shape, double rate, double scale, boolean lower_tail) {
        return this.q((AbstractRealDistribution)this.mkGamma(shape, rate, scale), p, lower_tail);
    }

    public double _qgamma$default$3() {
        return Double.NaN;
    }

    public double _qgamma$default$4() {
        return Double.NaN;
    }

    public boolean _qgamma$default$5() {
        return true;
    }

    public double _rgamma() {
        return this.r((AbstractRealDistribution)this.stdGamma());
    }

    public double[] _rgamma(double n, double shape, double rate, double scale) {
        return this.r((AbstractRealDistribution)this.mkGamma(shape, rate, scale), n);
    }

    public double _rgamma$default$3() {
        return Double.NaN;
    }

    public double _rgamma$default$4() {
        return Double.NaN;
    }

    private ExponentialDistribution mkExp(double rate) {
        return new ExponentialDistribution((RandomGenerator)this.rng(), 1.0 / rate);
    }

    private ExponentialDistribution stdExp() {
        return this.stdExp;
    }

    public double _dexp(double x) {
        return this.d((AbstractRealDistribution)this.stdExp(), x);
    }

    public double[] _dexp(double[] x, double rate, boolean log) {
        return this.d((AbstractRealDistribution)this.mkExp(rate), x, log);
    }

    public double _dexp$default$2() {
        return 1.0;
    }

    public boolean _dexp$default$3() {
        return false;
    }

    public double _pexp(double q) {
        return this.p((AbstractRealDistribution)this.stdExp(), q);
    }

    public double[] _pexp(double[] q, double rate, boolean lower_tail) {
        return this.p((AbstractRealDistribution)this.mkExp(rate), q, lower_tail);
    }

    public double _pexp$default$2() {
        return 1.0;
    }

    public boolean _pexp$default$3() {
        return true;
    }

    public double _qexp(double p) {
        return this.q((AbstractRealDistribution)this.stdExp(), p);
    }

    public double[] _qexp(double[] p, double rate, boolean lower_tail) {
        return this.q((AbstractRealDistribution)this.mkExp(rate), p, lower_tail);
    }

    public double _qexp$default$2() {
        return 1.0;
    }

    public boolean _qexp$default$3() {
        return true;
    }

    public double _rexp() {
        return this.r((AbstractRealDistribution)this.stdExp());
    }

    public double[] _rexp(double n, double rate) {
        return this.r((AbstractRealDistribution)this.mkExp(rate), n);
    }

    public double _rexp$default$2() {
        return 1.0;
    }

    private BetaDistribution mkBeta(double shape1, double shape2, double ncp) {
        if (ncp != 0.0) {
            throw scala.sys.package$.MODULE$.error("The current implementation requires that the ncp is 0.");
        }
        return new BetaDistribution((RandomGenerator)this.rng(), shape1, shape2);
    }

    private BetaDistribution stdBeta() {
        return this.stdBeta;
    }

    public double _dbeta(double x) {
        return this.d((AbstractRealDistribution)this.stdBeta(), x);
    }

    public double[] _dbeta(double[] x, double shape1, double shape2, double ncp, boolean log) {
        return this.d((AbstractRealDistribution)this.mkBeta(shape1, shape2, ncp), x, log);
    }

    public double _dbeta$default$4() {
        return 0.0;
    }

    public boolean _dbeta$default$5() {
        return false;
    }

    public double _pbeta(double q) {
        return this.p((AbstractRealDistribution)this.stdBeta(), q);
    }

    public double[] _pbeta(double[] q, double shape1, double shape2, double ncp, boolean lower_tail) {
        return this.p((AbstractRealDistribution)this.mkBeta(shape1, shape2, ncp), q, lower_tail);
    }

    public double _pbeta$default$4() {
        return 0.0;
    }

    public boolean _pbeta$default$5() {
        return true;
    }

    public double _qbeta(double p) {
        return this.q((AbstractRealDistribution)this.stdBeta(), p);
    }

    public double[] _qbeta(double[] p, double shape1, double shape2, double ncp, boolean lower_tail) {
        return this.q((AbstractRealDistribution)this.mkBeta(shape1, shape2, ncp), p, lower_tail);
    }

    public double _qbeta$default$4() {
        return 0.0;
    }

    public boolean _qbeta$default$5() {
        return true;
    }

    public double _rbeta() {
        return this.r((AbstractRealDistribution)this.stdBeta());
    }

    public double[] _rbeta(double n, double shape1, double shape2, double ncp) {
        return this.r((AbstractRealDistribution)this.mkBeta(shape1, shape2, ncp), n);
    }

    public double _rbeta$default$4() {
        return 0.0;
    }

    private TDistribution mkT(double df, double ncp) {
        if (ncp != 0.0) {
            throw scala.sys.package$.MODULE$.error("The current implementation requires that the ncp is 0.");
        }
        return new TDistribution((RandomGenerator)this.rng(), df);
    }

    private TDistribution stdT() {
        return this.stdT;
    }

    public double _dt(double x) {
        return this.d((AbstractRealDistribution)this.stdT(), x);
    }

    public double[] _dt(double[] x, double df, double ncp, boolean log) {
        return this.d((AbstractRealDistribution)this.mkT(df, ncp), x, log);
    }

    public double _dt$default$3() {
        return 0.0;
    }

    public boolean _dt$default$4() {
        return false;
    }

    public double _pt(double q) {
        return this.p((AbstractRealDistribution)this.stdT(), q);
    }

    public double[] _pt(double[] q, double df, double ncp, boolean lower_tail) {
        return this.p((AbstractRealDistribution)this.mkT(df, ncp), q, lower_tail);
    }

    public double _pt$default$3() {
        return 0.0;
    }

    public boolean _pt$default$4() {
        return true;
    }

    public double _qt(double p) {
        return this.q((AbstractRealDistribution)this.stdT(), p);
    }

    public double[] _qt(double[] p, double df, double ncp, boolean lower_tail) {
        return this.q((AbstractRealDistribution)this.mkT(df, ncp), p, lower_tail);
    }

    public double _qt$default$3() {
        return 0.0;
    }

    public boolean _qt$default$4() {
        return true;
    }

    public double _rt() {
        return this.r((AbstractRealDistribution)this.stdT());
    }

    public double[] _rt(double n, double df, double ncp) {
        return this.r((AbstractRealDistribution)this.mkT(df, ncp), n);
    }

    public double _rt$default$3() {
        return 0.0;
    }

    private ChiSquaredDistribution mkChiSquared(double df, double ncp) {
        if (ncp != 0.0) {
            throw scala.sys.package$.MODULE$.error("The current implementation requires that the ncp is 0.");
        }
        return new ChiSquaredDistribution((RandomGenerator)this.rng(), df);
    }

    private ChiSquaredDistribution stdChiSquared() {
        return this.stdChiSquared;
    }

    public double _dchisq(double x) {
        return this.d((AbstractRealDistribution)this.stdChiSquared(), x);
    }

    public double[] _dchisq(double[] x, double df, double ncp, boolean log) {
        return this.d((AbstractRealDistribution)this.mkChiSquared(df, ncp), x, log);
    }

    public double _dchisq$default$3() {
        return 0.0;
    }

    public boolean _dchisq$default$4() {
        return false;
    }

    public double _pchisq(double q) {
        return this.p((AbstractRealDistribution)this.stdChiSquared(), q);
    }

    public double[] _pchisq(double[] q, double df, double ncp, boolean lower_tail) {
        return this.p((AbstractRealDistribution)this.mkChiSquared(df, ncp), q, lower_tail);
    }

    public double _pchisq$default$3() {
        return 0.0;
    }

    public boolean _pchisq$default$4() {
        return true;
    }

    public double _qchisq(double p) {
        return this.q((AbstractRealDistribution)this.stdChiSquared(), p);
    }

    public double[] _qchisq(double[] p, double df, double ncp, boolean lower_tail) {
        return this.q((AbstractRealDistribution)this.mkChiSquared(df, ncp), p, lower_tail);
    }

    public double _qchisq$default$3() {
        return 0.0;
    }

    public boolean _qchisq$default$4() {
        return true;
    }

    public double _rchisq() {
        return this.r((AbstractRealDistribution)this.stdChiSquared());
    }

    public double[] _rchisq(double n, double df, double ncp) {
        return this.r((AbstractRealDistribution)this.mkChiSquared(df, ncp), n);
    }

    public double _rchisq$default$3() {
        return 0.0;
    }

    private FDistribution mkF(double df1, double df2, double ncp) {
        if (ncp != 0.0) {
            throw scala.sys.package$.MODULE$.error("The current implementation requires that the ncp is 0.");
        }
        return new FDistribution((RandomGenerator)this.rng(), df1, df2);
    }

    private FDistribution stdF() {
        return this.stdF;
    }

    public double _df(double x) {
        return this.d((AbstractRealDistribution)this.stdF(), x);
    }

    public double[] _df(double[] x, double df1, double df2, double ncp, boolean log) {
        return this.d((AbstractRealDistribution)this.mkF(df1, df2, ncp), x, log);
    }

    public double _df$default$4() {
        return 0.0;
    }

    public boolean _df$default$5() {
        return false;
    }

    public double _pf(double q) {
        return this.p((AbstractRealDistribution)this.stdF(), q);
    }

    public double[] _pf(double[] q, double df1, double df2, double ncp, boolean lower_tail) {
        return this.p((AbstractRealDistribution)this.mkF(df1, df2, ncp), q, lower_tail);
    }

    public double _pf$default$4() {
        return 0.0;
    }

    public boolean _pf$default$5() {
        return true;
    }

    public double _qf(double p) {
        return this.q((AbstractRealDistribution)this.stdF(), p);
    }

    public double[] _qf(double[] p, double df1, double df2, double ncp, boolean lower_tail) {
        return this.q((AbstractRealDistribution)this.mkF(df1, df2, ncp), p, lower_tail);
    }

    public double _qf$default$4() {
        return 0.0;
    }

    public boolean _qf$default$5() {
        return true;
    }

    public double _rf() {
        return this.r((AbstractRealDistribution)this.stdF());
    }

    public double[] _rf(double n, double df1, double df2, double ncp) {
        return this.r((AbstractRealDistribution)this.mkF(df1, df2, ncp), n);
    }

    public double _rf$default$4() {
        return 0.0;
    }

    private BinomialDistribution mkBinomial(double size, double prob) {
        return new BinomialDistribution((RandomGenerator)this.rng(), this.r2int(size), prob);
    }

    private BinomialDistribution stdBinomial() {
        return this.stdBinomial;
    }

    public double _dbinom(double x) {
        return this.dI((AbstractIntegerDistribution)this.stdBinomial(), x);
    }

    public double[] _dbinom(double[] x, double size, double prob, boolean log) {
        return this.dI((AbstractIntegerDistribution)this.mkBinomial(size, prob), x, log);
    }

    public boolean _dbinom$default$4() {
        return false;
    }

    public double _pbinom(double q) {
        return this.pI((AbstractIntegerDistribution)this.stdBinomial(), q);
    }

    public double[] _pbinom(double[] q, double size, double prob, boolean lower_tail) {
        return this.pI((AbstractIntegerDistribution)this.mkBinomial(size, prob), q, lower_tail);
    }

    public boolean _pbinom$default$4() {
        return true;
    }

    public double _qbinom(double p) {
        return this.qI((AbstractIntegerDistribution)this.stdBinomial(), p);
    }

    public double[] _qbinom(double[] p, double size, double prob, boolean lower_tail) {
        return this.qI((AbstractIntegerDistribution)this.mkBinomial(size, prob), p, lower_tail);
    }

    public boolean _qbinom$default$4() {
        return true;
    }

    public double _rbinom() {
        return this.rI((AbstractIntegerDistribution)this.stdBinomial());
    }

    public double[] _rbinom(double n, double size, double prob) {
        return this.rI((AbstractIntegerDistribution)this.mkBinomial(size, prob), n);
    }

    private PascalDistribution mkNegativeBinomial(double size, double prob, double mu) {
        if (!Double.isNaN(mu)) {
            throw scala.sys.package$.MODULE$.error("Parametrization with 'mu' is not implemented.");
        }
        return new PascalDistribution((RandomGenerator)this.rng(), this.r2int(size), prob);
    }

    private PascalDistribution stdNegativeBinomial() {
        return this.stdNegativeBinomial;
    }

    public double _dnbinom(double x) {
        return this.dI((AbstractIntegerDistribution)this.stdNegativeBinomial(), x);
    }

    public double[] _dnbinom(double[] x, double size, double prob, double mu, boolean log) {
        return this.dI((AbstractIntegerDistribution)this.mkNegativeBinomial(size, prob, mu), x, log);
    }

    public double _dnbinom$default$4() {
        return Double.NaN;
    }

    public boolean _dnbinom$default$5() {
        return false;
    }

    public double _pnbinom(double q) {
        return this.pI((AbstractIntegerDistribution)this.stdNegativeBinomial(), q);
    }

    public double[] _pnbinom(double[] q, double size, double prob, double mu, boolean lower_tail) {
        return this.pI((AbstractIntegerDistribution)this.mkNegativeBinomial(size, prob, mu), q, lower_tail);
    }

    public double _pnbinom$default$4() {
        return Double.NaN;
    }

    public boolean _pnbinom$default$5() {
        return true;
    }

    public double _qnbinom(double p) {
        return this.qI((AbstractIntegerDistribution)this.stdNegativeBinomial(), p);
    }

    public double[] _qnbinom(double[] p, double size, double prob, double mu, boolean lower_tail) {
        return this.qI((AbstractIntegerDistribution)this.mkNegativeBinomial(size, prob, mu), p, lower_tail);
    }

    public double _qnbinom$default$4() {
        return Double.NaN;
    }

    public boolean _qnbinom$default$5() {
        return true;
    }

    public double _rnbinom() {
        return this.rI((AbstractIntegerDistribution)this.stdNegativeBinomial());
    }

    public double[] _rnbinom(double n, double size, double prob, double mu) {
        return this.rI((AbstractIntegerDistribution)this.mkNegativeBinomial(size, prob, mu), n);
    }

    public double _rnbinom$default$4() {
        return Double.NaN;
    }

    private PoissonDistribution mkPoisson(double lambda) {
        return new PoissonDistribution((RandomGenerator)this.rng(), lambda, 1.0E-12, 10000000);
    }

    private PoissonDistribution stdPoisson() {
        return this.stdPoisson;
    }

    public double _dpois(double x) {
        return this.dI((AbstractIntegerDistribution)this.stdPoisson(), x);
    }

    public double[] _dpois(double[] x, double lambda, boolean log) {
        return this.dI((AbstractIntegerDistribution)this.mkPoisson(lambda), x, log);
    }

    public boolean _dpois$default$3() {
        return false;
    }

    public double _ppois(double q) {
        return this.pI((AbstractIntegerDistribution)this.stdPoisson(), q);
    }

    public double[] _ppois(double[] q, double lambda, boolean lower_tail) {
        return this.pI((AbstractIntegerDistribution)this.mkPoisson(lambda), q, lower_tail);
    }

    public boolean _ppois$default$3() {
        return true;
    }

    public double _qpois(double p) {
        return this.qI((AbstractIntegerDistribution)this.stdPoisson(), p);
    }

    public double[] _qpois(double[] p, double lambda, boolean lower_tail) {
        return this.qI((AbstractIntegerDistribution)this.mkPoisson(lambda), p, lower_tail);
    }

    public boolean _qpois$default$3() {
        return true;
    }

    public double _rpois() {
        return this.rI((AbstractIntegerDistribution)this.stdPoisson());
    }

    public double[] _rpois(double n, double lambda) {
        return this.rI((AbstractIntegerDistribution)this.mkPoisson(lambda), n);
    }

    private GeometricDistribution mkGeometric(double prob) {
        return new GeometricDistribution((RandomGenerator)this.rng(), prob);
    }

    private GeometricDistribution stdGeometric() {
        return this.stdGeometric;
    }

    public double _dgeom(double x) {
        return this.dI((AbstractIntegerDistribution)this.stdGeometric(), x);
    }

    public double[] _dgeom(double[] x, double prob, boolean log) {
        return this.dI((AbstractIntegerDistribution)this.mkGeometric(prob), x, log);
    }

    public boolean _dgeom$default$3() {
        return false;
    }

    public double _pgeom(double q) {
        return this.pI((AbstractIntegerDistribution)this.stdGeometric(), q);
    }

    public double[] _pgeom(double[] q, double prob, boolean lower_tail) {
        return this.pI((AbstractIntegerDistribution)this.mkGeometric(prob), q, lower_tail);
    }

    public boolean _pgeom$default$3() {
        return true;
    }

    public double _qgeom(double p) {
        return this.qI((AbstractIntegerDistribution)this.stdGeometric(), p);
    }

    public double[] _qgeom(double[] p, double prob, boolean lower_tail) {
        return this.qI((AbstractIntegerDistribution)this.mkGeometric(prob), p, lower_tail);
    }

    public boolean _qgeom$default$3() {
        return true;
    }

    public double _rgeom() {
        return this.rI((AbstractIntegerDistribution)this.stdGeometric());
    }

    public double[] _rgeom(double n, double prob) {
        return this.rI((AbstractIntegerDistribution)this.mkGeometric(prob), n);
    }

    public static final /* synthetic */ double $anonfun$_beta$1(Tuple2 z) {
        return FastMath.exp((double)Beta.logBeta((double)z._1$mcD$sp(), (double)z._2$mcD$sp()));
    }

    public static final /* synthetic */ double $anonfun$_beta$2(Tuple2 z) {
        return FastMath.exp((double)Beta.logBeta((double)z._1$mcI$sp(), (double)z._2$mcD$sp()));
    }

    public static final /* synthetic */ double $anonfun$_beta$3(Tuple2 z) {
        return FastMath.exp((double)Beta.logBeta((double)z._1$mcD$sp(), (double)z._2$mcI$sp()));
    }

    public static final /* synthetic */ double $anonfun$_beta$4(Tuple2 z) {
        return FastMath.exp((double)Beta.logBeta((double)z._1$mcI$sp(), (double)z._2$mcI$sp()));
    }

    public static final /* synthetic */ double $anonfun$_lbeta$1(Tuple2 z) {
        return Beta.logBeta((double)z._1$mcD$sp(), (double)z._2$mcD$sp());
    }

    public static final /* synthetic */ double $anonfun$_lbeta$2(Tuple2 z) {
        return Beta.logBeta((double)z._1$mcI$sp(), (double)z._2$mcD$sp());
    }

    public static final /* synthetic */ double $anonfun$_lbeta$3(Tuple2 z) {
        return Beta.logBeta((double)z._1$mcD$sp(), (double)z._2$mcI$sp());
    }

    public static final /* synthetic */ double $anonfun$_lbeta$4(Tuple2 z) {
        return Beta.logBeta((double)z._1$mcI$sp(), (double)z._2$mcI$sp());
    }

    public static final /* synthetic */ double $anonfun$_choose$2(Tuple2 z) {
        return FastMath.exp((double)(Gamma.logGamma((double)(z._1$mcD$sp() + 1.0)) - Gamma.logGamma((double)(z._2$mcI$sp() + 1)) - Gamma.logGamma((double)(z._1$mcD$sp() - (double)z._2$mcI$sp() + 1.0))));
    }

    public static final /* synthetic */ double $anonfun$_choose$4(Tuple2 z) {
        return FastMath.exp((double)(Gamma.logGamma((double)(z._1$mcI$sp() + 1)) - Gamma.logGamma((double)(z._2$mcI$sp() + 1)) - Gamma.logGamma((double)(z._1$mcI$sp() - z._2$mcI$sp() + 1))));
    }

    public static final /* synthetic */ double $anonfun$_choose$5(Tuple2 z) {
        return FastMath.exp((double)(Gamma.logGamma((double)(z._1$mcD$sp() + 1.0)) - Gamma.logGamma((double)(z._2$mcI$sp() + 1)) - Gamma.logGamma((double)(z._1$mcD$sp() - (double)z._2$mcI$sp() + 1.0))));
    }

    public static final /* synthetic */ double $anonfun$_choose$6(Tuple2 z) {
        return FastMath.exp((double)(Gamma.logGamma((double)(z._1$mcI$sp() + 1)) - Gamma.logGamma((double)(z._2$mcI$sp() + 1)) - Gamma.logGamma((double)(z._1$mcI$sp() - z._2$mcI$sp() + 1))));
    }

    public static final /* synthetic */ double $anonfun$_lchoose$2(Tuple2 z) {
        return Gamma.logGamma((double)(z._1$mcD$sp() + 1.0)) - Gamma.logGamma((double)(z._2$mcI$sp() + 1)) - Gamma.logGamma((double)(z._1$mcD$sp() - (double)z._2$mcI$sp() + 1.0));
    }

    public static final /* synthetic */ double $anonfun$_lchoose$4(Tuple2 z) {
        return Gamma.logGamma((double)(z._1$mcI$sp() + 1)) - Gamma.logGamma((double)(z._2$mcI$sp() + 1)) - Gamma.logGamma((double)(z._1$mcI$sp() - z._2$mcI$sp() + 1));
    }

    public static final /* synthetic */ double $anonfun$_lchoose$5(Tuple2 z) {
        return Gamma.logGamma((double)(z._1$mcD$sp() + 1.0)) - Gamma.logGamma((double)(z._2$mcI$sp() + 1)) - Gamma.logGamma((double)(z._1$mcD$sp() - (double)z._2$mcI$sp() + 1.0));
    }

    public static final /* synthetic */ double $anonfun$_lchoose$6(Tuple2 z) {
        return Gamma.logGamma((double)(z._1$mcI$sp() + 1)) - Gamma.logGamma((double)(z._2$mcI$sp() + 1)) - Gamma.logGamma((double)(z._1$mcI$sp() - z._2$mcI$sp() + 1));
    }

    private Transcompile$() {
        MODULE$ = this;
        this.rng = new Well44497b();
        this.stdUniform = this.mkUniform(0.0, 1.0);
        this.stdNormal = this.mkNormal(0.0, 1.0);
        this.stdGamma = this.mkGamma(1.0, 1.0, Double.NaN);
        this.stdExp = this.mkExp(1.0);
        this.stdBeta = this.mkBeta(1.0, 1.0, 0.0);
        this.stdT = this.mkT(1.0, 0.0);
        this.stdChiSquared = this.mkChiSquared(1.0, 0.0);
        this.stdF = this.mkF(1.0, 1.0, 0.0);
        this.stdBinomial = this.mkBinomial(1.0, 0.5);
        this.stdNegativeBinomial = this.mkNegativeBinomial(1.0, 0.5, Double.NaN);
        this.stdPoisson = this.mkPoisson(1.0);
        this.stdGeometric = this.mkGeometric(0.5);
    }
}

