/*
 * Decompiled with CFR 0.152.
 */
package jdplus.x13.base.core.x11.filter.endpoints;

import jdplus.toolkit.base.api.data.DoubleSeq;
import jdplus.toolkit.base.core.data.DataBlock;
import jdplus.toolkit.base.core.math.linearfilters.SymmetricFilter;
import jdplus.x13.base.core.x11.filter.endpoints.IEndPointsProcessor;

public class FilteredMeanEndPoints
implements IEndPointsProcessor {
    private SymmetricFilter filter;

    public FilteredMeanEndPoints(SymmetricFilter filter) {
        this.filter = filter;
    }

    @Override
    public void process(DoubleSeq in, DataBlock out) {
        int len = this.filter.length() / 2;
        int n = in.length();
        double[] tmp = new double[n + 2 * len];
        in.copyTo(tmp, len);
        DoubleSeq rbeg = in.range(0, len);
        DoubleSeq rend = in.range(n - len, n);
        double beg = rbeg.average();
        double end = rend.average();
        int i = 0;
        int j = n + len;
        while (i < len) {
            tmp[i] = beg;
            tmp[j] = end;
            ++i;
            ++j;
        }
        this.filter.apply(DataBlock.of((double[])tmp), out);
    }
}

