## ----setup, include = FALSE---------------------------------------------------
knitr::opts_chunk$set(
  collapse = TRUE,
  comment = "#>"
)

## -----------------------------------------------------------------------------
library(callback)
m <- mobility1
str(m)

## ----fig.width=7,fig.height=4.4-----------------------------------------------
c <- callback(data=m,cluster="offer",candid=c("gender","licenses"),callback="callback")
r <- stat_raw(c)
print(r)
plot(r)

## -----------------------------------------------------------------------------
levels(m$gender)
levels(m$licenses)

## -----------------------------------------------------------------------------
m2 <- m
m2$licenses <- relevel(m2$licenses,ref="Yes")
levels(m2$licenses)

## -----------------------------------------------------------------------------
model <- list( c("licenses"), 
               c("licenses","gender","inter"),
               c("gender"))
  
cpm <- callback_comp(data = m2, cluster = "offer", 
                   candid = c("gender","licenses"), 
                 callback = "callback", 
                    model = model)

## -----------------------------------------------------------------------------
print(cpm)

## -----------------------------------------------------------------------------
estim <- reg(cpm)
print(estim)

## -----------------------------------------------------------------------------
summary(estim)

## -----------------------------------------------------------------------------
m2 <- m
m2$cand <- as.factor(ifelse(m2$gender == "Man","m",
                            ifelse(m2$licenses == "Yes","f1","f0")))
m2$cand <- relevel(m2$cand,ref = "m") 

levels(m2$cand)

## -----------------------------------------------------------------------------
model <- list( c("gender"),c("gender","inter"))
  
cpm2 <- callback_comp(data = m2, cluster = "offer", 
                   candid = "cand", 
                 callback = "callback", 
                    model = model)

summary(reg(cpm2))

