/*
 * Decompiled with CFR 0.152.
 */
package org.jpmml.converter;

import jakarta.xml.bind.JAXBElement;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TimeZone;
import java.util.function.Function;
import javax.xml.namespace.QName;
import org.dmg.pmml.Array;
import org.dmg.pmml.ComplexArray;
import org.dmg.pmml.DataType;
import org.dmg.pmml.Extension;
import org.dmg.pmml.Header;
import org.dmg.pmml.InlineTable;
import org.dmg.pmml.RealSparseArray;
import org.dmg.pmml.Row;
import org.dmg.pmml.Timestamp;
import org.jpmml.converter.Application;
import org.jpmml.converter.PMMLEncoder;
import org.jpmml.converter.ValueUtil;
import org.jpmml.model.cells.InputCell;
import org.jpmml.model.cells.OutputCell;

public class PMMLUtil {
    private static final TimeZone UTC = TimeZone.getTimeZone("UTC");

    private PMMLUtil() {
    }

    public static Extension createExtension(String name, String value) {
        Extension extension = new Extension().setName(name).setValue(value);
        return extension;
    }

    public static Extension createExtension(String name, Object ... content) {
        Extension extension = new Extension().setName(name).addContent(content);
        return extension;
    }

    public static Header createHeader(PMMLEncoder encoder) {
        Class<?> clazz = encoder.getClass();
        Application application = Application.getInstance();
        if (application != null) {
            clazz = application.getClass();
        }
        Package _package = clazz.getPackage();
        return PMMLUtil.createHeader(_package.getImplementationTitle(), _package.getImplementationVersion());
    }

    public static Header createHeader(String name, String version) {
        if (name == null) {
            name = "JPMML-Converter";
        }
        org.dmg.pmml.Application pmmlApplication = new org.dmg.pmml.Application().setName(name).setVersion(version);
        return PMMLUtil.createHeader(pmmlApplication);
    }

    public static Header createHeader(org.dmg.pmml.Application pmmlApplication) {
        Date now = new Date();
        SimpleDateFormat dateFormat = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss'Z'");
        dateFormat.setTimeZone(UTC);
        Timestamp timestamp = new Timestamp().addContent(new Object[]{dateFormat.format(now)});
        Header header = new Header().setApplication(pmmlApplication).setTimestamp(timestamp);
        return header;
    }

    public static Array createArray(DataType dataType, List<?> values) {
        switch (dataType) {
            case STRING: {
                return PMMLUtil.createStringArray(values);
            }
            case INTEGER: {
                return PMMLUtil.createIntArray(values);
            }
            case FLOAT: 
            case DOUBLE: {
                return PMMLUtil.createRealArray(values);
            }
        }
        throw new IllegalArgumentException();
    }

    public static Array createStringArray(List<?> values) {
        ComplexArray array = new ComplexArray().setType(Array.Type.STRING).setValue(values);
        return array;
    }

    public static Array createIntArray(List<Integer> values) {
        ComplexArray array = new ComplexArray().setType(Array.Type.INT).setValue(values);
        return array;
    }

    public static Array createRealArray(List<? extends Number> values) {
        ComplexArray array = new ComplexArray().setType(Array.Type.REAL).setValue(values);
        return array;
    }

    public static RealSparseArray createRealSparseArray(List<? extends Number> values, Double defaultValue) {
        RealSparseArray sparseArray = new RealSparseArray().setN(Integer.valueOf(values.size())).setDefaultValue(defaultValue);
        List indices = sparseArray.getIndices();
        List entries = sparseArray.getEntries();
        int index = 1;
        for (Number number : values) {
            if (!ValueUtil.equals(number, defaultValue)) {
                indices.add(index);
                entries.add(ValueUtil.asDouble(number));
            }
            ++index;
        }
        return sparseArray;
    }

    public static InlineTable createInlineTable(Map<String, ? extends List<?>> data) {
        return PMMLUtil.createInlineTable(Function.identity(), data);
    }

    public static <K> InlineTable createInlineTable(Function<K, String> function, Map<K, ? extends List<?>> data) {
        int rows = 0;
        LinkedHashMap columns = new LinkedHashMap();
        Set<Map.Entry<K, List<?>>> entries = data.entrySet();
        for (Map.Entry entry : entries) {
            QName columnName;
            Object column = entry.getKey();
            List columnData = (List)entry.getValue();
            if (rows == 0) {
                rows = columnData.size();
            } else if (rows != columnData.size()) {
                throw new IllegalArgumentException();
            }
            String tagName = function.apply(column);
            if (tagName.startsWith("data:")) {
                columnName = new QName("http://jpmml.org/jpmml-model/InlineTable", tagName.substring("data:".length()), "data");
            } else {
                if (tagName.indexOf(58) > -1) {
                    throw new IllegalArgumentException(tagName);
                }
                columnName = new QName(PMMLEncoder.VERSION.getNamespaceURI(), tagName);
            }
            columns.put(column, columnName);
        }
        QName inputColumnName = InputCell.QNAME;
        QName outputColumnName = OutputCell.QNAME;
        InlineTable inlineTable = new InlineTable();
        for (int i = 0; i < rows; ++i) {
            Row row = new Row();
            Set entries2 = columns.entrySet();
            for (Map.Entry entry : entries2) {
                List<?> columnData = data.get(entry.getKey());
                Object value = columnData.get(i);
                if (value == null) continue;
                QName columName = (QName)entry.getValue();
                Object cell = inputColumnName.equals(columName) ? new InputCell(value) : (outputColumnName.equals(columName) ? new OutputCell(value) : new JAXBElement(columName, String.class, (Object)ValueUtil.asString(value)));
                row.addContent(new Object[]{cell});
            }
            inlineTable.addRows(new Row[]{row});
        }
        return inlineTable;
    }
}

