/*
 * Decompiled with CFR 0.152.
 */
package jdplus.toolkit.base.core.ssf.dk;

import jdplus.toolkit.base.api.data.DoubleSeqCursor;
import jdplus.toolkit.base.core.data.DataBlock;
import jdplus.toolkit.base.core.data.DataBlockIterator;
import jdplus.toolkit.base.core.math.matrices.FastMatrix;
import jdplus.toolkit.base.core.math.matrices.SymmetricMatrix;
import jdplus.toolkit.base.core.ssf.ISsfDynamics;
import jdplus.toolkit.base.core.ssf.ISsfInitialization;
import jdplus.toolkit.base.core.ssf.ISsfLoading;
import jdplus.toolkit.base.core.ssf.dk.BaseDiffuseFilteringResults;
import jdplus.toolkit.base.core.ssf.dk.DkToolkit;
import jdplus.toolkit.base.core.ssf.dk.IBaseDiffuseFilteringResults;
import jdplus.toolkit.base.core.ssf.dk.sqrt.DefaultDiffuseSquareRootFilteringResults;
import jdplus.toolkit.base.core.ssf.univariate.DisturbanceSmoother;
import jdplus.toolkit.base.core.ssf.univariate.IDisturbanceSmoothingResults;
import jdplus.toolkit.base.core.ssf.univariate.ISsf;
import jdplus.toolkit.base.core.ssf.univariate.ISsfData;
import jdplus.toolkit.base.core.ssf.univariate.ISsfError;
import lombok.NonNull;

public class DiffuseDisturbanceSmoother {
    private final ISsf ssf;
    private final ISsfDynamics dynamics;
    private final ISsfLoading loading;
    private final ISsfError error;
    private final boolean calcvar;
    private final boolean rescalevar;
    private IDisturbanceSmoothingResults srslts;
    private BaseDiffuseFilteringResults frslts;
    private double e;
    private double f;
    private double esm;
    private double esmVariance;
    private double h;
    private double fi;
    private DataBlock C;
    private DataBlock Ci;
    private DataBlock R;
    private DataBlock Ri;
    private DataBlock U;
    private FastMatrix N;
    private FastMatrix UVar;
    private FastMatrix S;
    private boolean missing;
    private int pos;
    private DataBlock tmp;
    private double c;
    private double v;

    public static Builder builder(ISsf ssf) {
        return new Builder(ssf);
    }

    private DiffuseDisturbanceSmoother(ISsf ssf, boolean calcvar, boolean rescalevar) {
        this.ssf = ssf;
        this.calcvar = calcvar;
        this.rescalevar = rescalevar;
        this.dynamics = ssf.dynamics();
        this.loading = ssf.measurement().loading();
        this.error = ssf.measurement().error();
    }

    public boolean process(ISsfData data, @NonNull IDisturbanceSmoothingResults sresults) {
        if (sresults == null) {
            throw new NullPointerException("sresults is marked non-null but is null");
        }
        DefaultDiffuseSquareRootFilteringResults fresults = DkToolkit.sqrtFilter(this.ssf, data, false);
        return this.process(data.length(), fresults, sresults);
    }

    public boolean process(int endpos, BaseDiffuseFilteringResults results, @NonNull IDisturbanceSmoothingResults sresults) {
        if (sresults == null) {
            throw new NullPointerException("sresults is marked non-null but is null");
        }
        this.frslts = results;
        this.srslts = sresults;
        this.initSmoother(this.ssf);
        this.ordinarySmoothing(this.ssf, endpos);
        this.pos = this.frslts.getEndDiffusePosition();
        while (--this.pos >= 0) {
            this.loadInfo();
            if (!this.iterate()) continue;
            this.srslts.saveSmoothedTransitionDisturbances(this.pos, this.U, this.UVar);
            if (this.error == null) continue;
            this.srslts.saveSmoothedMeasurementDisturbance(this.pos, this.esm, this.esmVariance);
        }
        if (this.rescalevar) {
            this.srslts.rescaleVariances(this.frslts.var());
        }
        return true;
    }

    private void initSmoother(ISsf ssf) {
        int dim = ssf.getStateDim();
        int resdim = this.dynamics.getInnovationsDim();
        this.R = DataBlock.make(dim);
        this.C = DataBlock.make(dim);
        this.Ri = DataBlock.make(dim);
        this.Ci = DataBlock.make(dim);
        this.U = DataBlock.make(resdim);
        this.S = FastMatrix.make(dim, resdim);
        if (this.calcvar) {
            this.N = FastMatrix.square(dim);
            this.tmp = DataBlock.make(dim);
            this.UVar = FastMatrix.square(resdim);
            this.h = this.error != null && this.error.isTimeInvariant() ? this.error.at(0) : 0.0;
        }
        if (this.dynamics.isTimeInvariant()) {
            this.dynamics.S(0, this.S);
        }
    }

    private void loadInfo() {
        this.e = this.frslts.error(this.pos);
        this.f = this.frslts.errorVariance(this.pos);
        this.fi = this.frslts.diffuseNorm2(this.pos);
        this.C.copy(this.frslts.M(this.pos));
        if (this.fi != 0.0) {
            this.Ci.copy(this.frslts.Mi(this.pos));
            this.Ci.mul(1.0 / this.fi);
            this.C.addAY(-this.f, this.Ci);
            this.C.mul(1.0 / this.fi);
        } else {
            this.C.mul(1.0 / this.f);
            this.Ci.set(0.0);
        }
        boolean bl = this.missing = !Double.isFinite(this.e);
        if (this.pos > 0) {
            if (!this.dynamics.isTimeInvariant() && this.S != null) {
                this.S.set(0.0);
                this.dynamics.S(this.pos - 1, this.S);
            }
            if (this.error != null && !this.error.isTimeInvariant()) {
                this.h = this.error.at(this.pos - 1);
            }
        }
    }

    private boolean iterate() {
        this.iterateR();
        if (this.calcvar) {
            this.iterateN();
        }
        if (this.pos > 0) {
            this.esm = this.c * this.h;
            if (this.dynamics.hasInnovations(this.pos - 1)) {
                this.dynamics.XS(this.pos - 1, this.R, this.U);
                if (this.calcvar) {
                    this.esmVariance = this.h - this.h * this.h * this.v;
                    SymmetricMatrix.XtSX(this.N, this.S, this.UVar);
                    this.UVar.chs();
                    this.UVar.diagonal().add(1.0);
                }
            } else {
                this.U.set(0.0);
                if (this.calcvar) {
                    this.UVar.set(0.0);
                }
            }
        }
        return true;
    }

    private void iterateN() {
        if (this.missing || this.f == 0.0 && this.fi == 0.0) {
            this.iterateMissingN();
        } else if (this.fi == 0.0) {
            this.iterateRegularN();
        } else {
            this.iterateDiffuseN();
        }
        SymmetricMatrix.reenforceSymmetry(this.N);
    }

    private void iterateMissingN() {
        this.tvt(this.N);
    }

    private void iterateRegularN() {
        this.tvt(this.N);
        this.tmp.product(this.C, this.N.columnsIterator());
        this.v = 1.0 / this.f + this.tmp.dot(this.C);
        this.loading.VpZdZ(this.pos, this.N, this.v);
        this.subZ(this.N.rowsIterator(), this.tmp);
        this.subZ(this.N.columnsIterator(), this.tmp);
    }

    private void iterateDiffuseN() {
        this.tvt(this.N);
        this.tmp.product(this.Ci, this.N.columnsIterator());
        this.v = this.tmp.dot(this.Ci);
        this.loading.VpZdZ(this.pos, this.N, this.v);
        this.subZ(this.N.rowsIterator(), this.tmp);
        this.subZ(this.N.columnsIterator(), this.tmp);
    }

    private void iterateR() {
        if (this.fi == 0.0) {
            this.iterateRegularR();
        } else {
            this.iterateDiffuseR();
        }
    }

    private void iterateRegularR() {
        this.dynamics.XT(this.pos, this.R);
        this.dynamics.XT(this.pos, this.Ri);
        if (!this.missing && this.f != 0.0) {
            this.c = this.e / this.f - this.R.dot(this.C);
            this.loading.XpZd(this.pos, this.R, this.c);
        }
    }

    private void iterateDiffuseR() {
        this.dynamics.XT(this.pos, this.R);
        this.dynamics.XT(this.pos, this.Ri);
        if (!this.missing && this.fi != 0.0) {
            this.c = -this.Ri.dot(this.Ci);
            double ci = this.e / this.fi + this.c - this.R.dot(this.C);
            this.loading.XpZd(this.pos, this.Ri, ci);
            double cf = -this.R.dot(this.Ci);
            this.loading.XpZd(this.pos, this.R, cf);
        }
    }

    private void tvt(FastMatrix N) {
        DataBlockIterator columns = N.columnsIterator();
        while (columns.hasNext()) {
            this.dynamics.XT(this.pos, columns.next());
        }
        DataBlockIterator rows = N.rowsIterator();
        while (rows.hasNext()) {
            this.dynamics.XT(this.pos, rows.next());
        }
    }

    private void subZ(DataBlockIterator rows, DataBlock b) {
        DoubleSeqCursor.OnMutable cell = b.cursor();
        while (rows.hasNext()) {
            this.loading.XpZd(this.pos, rows.next(), -cell.getAndNext());
        }
    }

    private void ordinarySmoothing(ISsf ssf, int endpos) {
        DisturbanceSmoother smoother = DisturbanceSmoother.builder(ssf).calcVariance(this.calcvar).rescaleVariance(false).build();
        smoother.process(this.frslts.getEndDiffusePosition(), endpos, this.frslts, this.srslts);
        this.R.copy(smoother.getFinalR());
        if (this.calcvar) {
            this.N.copy(smoother.getFinalN());
        }
    }

    public IBaseDiffuseFilteringResults getFilteringResults() {
        return this.frslts;
    }

    public DataBlock getFinalR() {
        return this.R;
    }

    public DataBlock getFinalRi() {
        return this.Ri;
    }

    public FastMatrix getFinalN() {
        return this.N;
    }

    public DataBlock firstSmoothedState() {
        ISsfInitialization initialization = this.ssf.initialization();
        int n = initialization.getStateDim();
        DataBlock a = DataBlock.make(n);
        FastMatrix Pf0 = FastMatrix.square(n);
        initialization.a0(a);
        initialization.Pf0(Pf0);
        a.addProduct(this.R, Pf0.columnsIterator());
        FastMatrix Pi0 = FastMatrix.square(n);
        initialization.Pi0(Pi0);
        a.addProduct(this.Ri, Pi0.columnsIterator());
        return a;
    }

    public static class Builder {
        private final ISsf ssf;
        private boolean rescaleVariance = false;
        private boolean calcVariance = true;

        public Builder(ISsf ssf) {
            this.ssf = ssf;
        }

        public Builder rescaleVariance(boolean rescale) {
            this.rescaleVariance = rescale;
            if (rescale) {
                this.calcVariance = true;
            }
            return this;
        }

        public Builder calcVariance(boolean calc) {
            this.calcVariance = calc;
            if (!calc) {
                this.rescaleVariance = false;
            }
            return this;
        }

        public DiffuseDisturbanceSmoother build() {
            return new DiffuseDisturbanceSmoother(this.ssf, this.calcVariance, this.rescaleVariance);
        }
    }
}

