/*
 * Decompiled with CFR 0.152.
 */
package jdplus.toolkit.base.core.math.polynomials;

import jdplus.toolkit.base.api.data.DoubleSeq;
import jdplus.toolkit.base.api.math.Constants;
import jdplus.toolkit.base.core.data.DataBlockIterator;
import jdplus.toolkit.base.core.math.linearsystem.QRLeastSquaresSolution;
import jdplus.toolkit.base.core.math.linearsystem.QRLeastSquaresSolver;
import jdplus.toolkit.base.core.math.matrices.FastMatrix;
import jdplus.toolkit.base.core.math.matrices.MatrixException;
import jdplus.toolkit.base.core.math.polynomials.Polynomial;

public class LeastSquaresDivision {
    public static final double EPS = Math.sqrt(Constants.getEpsilon());
    private double err;
    private double[] coeff;

    public boolean divide(Polynomial num, Polynomial denom) {
        try {
            this.err = 0.0;
            DoubleSeq N = num.coefficients();
            DoubleSeq D = denom.coefficients();
            int n = N.length();
            int d = D.length();
            if (d > n) {
                return false;
            }
            int q = n - d + 1;
            FastMatrix m = FastMatrix.make(n, q);
            DataBlockIterator columns = m.columnsIterator();
            int c = 0;
            while (columns.hasNext()) {
                columns.next().range(c, c + d).copy(D);
                ++c;
            }
            QRLeastSquaresSolution ls = QRLeastSquaresSolver.fastLeastSquares(N, m);
            this.coeff = ls.getB().toArray();
            this.err = ls.getSsqErr() / (double)d;
            return true;
        }
        catch (MatrixException error) {
            return false;
        }
    }

    public Polynomial getQuotient() {
        return Polynomial.of(this.coeff);
    }

    public double getError() {
        return this.err;
    }

    public boolean isExact() {
        return this.err < EPS;
    }
}

