/*
 * Decompiled with CFR 0.152.
 */
package jdplus.toolkit.base.api.timeseries.calendars;

import java.time.DayOfWeek;
import java.util.Arrays;
import jdplus.toolkit.base.api.timeseries.calendars.TradingDaysType;

public class DayClustering {
    private final int[] groups;
    private static final int[] TD7_IDX = new int[]{1, 2, 3, 4, 5, 6, 0};
    private static final int[] TD2_IDX = new int[]{1, 1, 1, 1, 1, 0, 0};
    private static final int[] TD2C_IDX = new int[]{1, 1, 1, 1, 1, 1, 0};
    private static final int[] TD2D_IDX = new int[]{1, 1, 1, 1, 0, 0, 0};
    private static final int[] TD3_IDX = new int[]{1, 1, 1, 1, 1, 2, 0};
    private static final int[] TD3C_IDX = new int[]{1, 1, 1, 1, 2, 2, 0};
    private static final int[] TD4_IDX = new int[]{1, 1, 1, 1, 2, 3, 0};
    private static final int[] TD4C_IDX = new int[]{1, 2, 2, 2, 2, 3, 0};
    private static final int[] TD6_IDX = new int[]{1, 2, 3, 4, 5, 0, 0};
    private static final String[] SHORTNAMES = new String[]{"mon", "tue", "wed", "thu", "fri", "sat", "sun"};
    public static final DayClustering TD2 = new DayClustering(TD2_IDX);
    public static final DayClustering TD2c = new DayClustering(TD2C_IDX);
    public static final DayClustering TD2d = new DayClustering(TD2D_IDX);
    public static final DayClustering TD3 = new DayClustering(TD3_IDX);
    public static final DayClustering TD3c = new DayClustering(TD3C_IDX);
    public static final DayClustering TD4 = new DayClustering(TD4_IDX);
    public static final DayClustering TD4c = new DayClustering(TD4C_IDX);
    public static final DayClustering TD6 = new DayClustering(TD6_IDX);
    public static final DayClustering TD7 = new DayClustering(TD7_IDX);

    public static DayClustering of(int[] groups) {
        if (groups.length != 7) {
            return null;
        }
        if (!DayClustering.checkGroups(groups)) {
            return null;
        }
        return new DayClustering(groups);
    }

    public static DayClustering of(TradingDaysType type) {
        return switch (type) {
            case TradingDaysType.TD7 -> TD7;
            case TradingDaysType.TD2 -> TD2;
            case TradingDaysType.TD2c -> TD2c;
            case TradingDaysType.TD2d -> TD2d;
            case TradingDaysType.TD3 -> TD3;
            case TradingDaysType.TD3c -> TD3c;
            case TradingDaysType.TD4 -> TD4;
            case TradingDaysType.TD4c -> TD4c;
            case TradingDaysType.TD6 -> TD6;
            default -> null;
        };
    }

    public TradingDaysType getType() {
        if (Arrays.equals(this.groups, TD7_IDX)) {
            return TradingDaysType.TD7;
        }
        if (Arrays.equals(this.groups, TD2_IDX)) {
            return TradingDaysType.TD2;
        }
        if (Arrays.equals(this.groups, TD3_IDX)) {
            return TradingDaysType.TD3;
        }
        if (Arrays.equals(this.groups, TD3C_IDX)) {
            return TradingDaysType.TD3c;
        }
        if (Arrays.equals(this.groups, TD2C_IDX)) {
            return TradingDaysType.TD2c;
        }
        if (Arrays.equals(this.groups, TD4_IDX)) {
            return TradingDaysType.TD4;
        }
        if (Arrays.equals(this.groups, TD4C_IDX)) {
            return TradingDaysType.TD4c;
        }
        if (Arrays.equals(this.groups, TD6_IDX)) {
            return TradingDaysType.TD6;
        }
        return TradingDaysType.TDuser;
    }

    private static boolean checkGroups(int[] groups) {
        int n = 0;
        int gr = 0;
        while (n < 7) {
            int ncur = 0;
            for (int i = 0; i < groups.length; ++i) {
                if (groups[i] != gr) continue;
                ++ncur;
            }
            if (ncur == 0) {
                return false;
            }
            n += ncur;
            ++gr;
        }
        return gr > 1;
    }

    private DayClustering(int[] groups) {
        this.groups = groups;
    }

    public int getGroup(DayOfWeek dw) {
        return this.groups[dw.getValue() - 1];
    }

    public int groupOf(int day) {
        return this.groups[day];
    }

    public int getGroupsCount() {
        int n = 0;
        for (int i = 0; i < this.groups.length; ++i) {
            if (this.groups[i] <= n) continue;
            n = this.groups[i];
        }
        return n + 1;
    }

    public int getGroupCount(int idx) {
        int n = 0;
        for (int i = 0; i < this.groups.length; ++i) {
            if (this.groups[i] != idx) continue;
            ++n;
        }
        return n;
    }

    public DayOfWeek[] group(int idx) {
        int n = this.getGroupCount(idx);
        DayOfWeek[] dw = new DayOfWeek[n];
        int i = 0;
        int j = 0;
        while (j < n) {
            if (this.groups[i] == idx) {
                dw[j++] = DayOfWeek.of(i + 1);
            }
            ++i;
        }
        return dw;
    }

    public int[] positions(int idx) {
        int n = 0;
        for (int i = 0; i < this.groups.length; ++i) {
            if (this.groups[i] != idx) continue;
            ++n;
        }
        int[] dw = new int[n];
        int i = 0;
        int j = 0;
        while (j < n) {
            if (this.groups[i] == idx) {
                dw[j++] = i;
            }
            ++i;
        }
        return dw;
    }

    public int[][] allPositions() {
        int n = this.getGroupsCount();
        int[][] all = new int[n][];
        for (int i = 0; i < n; ++i) {
            all[i] = this.positions(i);
        }
        return all;
    }

    public boolean isInside(DayClustering dc) {
        int n = dc.getGroupsCount();
        for (int i = 0; i < n; ++i) {
            int cur = -1;
            for (int j = 0; j < 7; ++j) {
                if (dc.groups[j] != i) continue;
                int g = this.groups[j];
                if (cur == -1) {
                    cur = g;
                    continue;
                }
                if (g == cur) continue;
                return false;
            }
        }
        return true;
    }

    public String toString() {
        TradingDaysType type = this.getType();
        if (type != TradingDaysType.TDuser) {
            return type.name();
        }
        StringBuilder builder = new StringBuilder();
        int ng = this.getGroupsCount();
        for (int i = 0; i < ng; ++i) {
            builder.append('{').append(this.toString(i)).append('}');
        }
        return builder.toString();
    }

    public String toString(int i) {
        StringBuilder builder = new StringBuilder();
        DayOfWeek[] gr = this.group(i);
        builder.append(SHORTNAMES[gr[0].getValue()]);
        for (int j = 1; j < gr.length; ++j) {
            builder.append(',').append(SHORTNAMES[gr[j].getValue()]);
        }
        return builder.toString();
    }

    public int[] getGroupsDefinition() {
        return (int[])this.groups.clone();
    }

    public int hashCode() {
        int hash = 7;
        hash = 37 * hash + Arrays.hashCode(this.groups);
        return hash;
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (other instanceof DayClustering) {
            DayClustering x = (DayClustering)other;
            return Arrays.equals(this.groups, x.groups);
        }
        return false;
    }
}

