/*
 * Decompiled with CFR 0.152.
 */
package org.openscience.cdk.io.iterator;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.StringReader;
import java.util.NoSuchElementException;
import java.util.Objects;
import org.openscience.cdk.exception.CDKException;
import org.openscience.cdk.interfaces.IAtomContainer;
import org.openscience.cdk.interfaces.IChemFile;
import org.openscience.cdk.interfaces.IChemObjectBuilder;
import org.openscience.cdk.io.PCCompoundASNReader;
import org.openscience.cdk.io.formats.IResourceFormat;
import org.openscience.cdk.io.formats.PubChemSubstancesASNFormat;
import org.openscience.cdk.io.iterator.DefaultIteratingChemObjectReader;
import org.openscience.cdk.tools.ILoggingTool;
import org.openscience.cdk.tools.LoggingToolFactory;
import org.openscience.cdk.tools.manipulator.ChemFileManipulator;

public class IteratingPCCompoundASNReader
extends DefaultIteratingChemObjectReader<IAtomContainer> {
    private BufferedReader input;
    private static final ILoggingTool logger = LoggingToolFactory.createLoggingTool(IteratingPCCompoundASNReader.class);
    private final IChemObjectBuilder builder;
    private boolean nextAvailableIsKnown;
    private boolean hasNext;
    private IAtomContainer nextMolecule;
    private String currentLine;
    private int depth;

    public IteratingPCCompoundASNReader(Reader in, IChemObjectBuilder builder) {
        this.builder = builder;
        this.setReader(in);
    }

    public IteratingPCCompoundASNReader(InputStream in, IChemObjectBuilder builder) {
        this(new InputStreamReader(in), builder);
    }

    public IResourceFormat getFormat() {
        return PubChemSubstancesASNFormat.getInstance();
    }

    public boolean hasNext() {
        if (!this.nextAvailableIsKnown) {
            this.hasNext = false;
            try {
                int depthDiff;
                this.currentLine = this.input.readLine();
                boolean endMoleculeFound = false;
                boolean startMoleculeFound = false;
                StringBuilder buffer = new StringBuilder();
                while (!startMoleculeFound && this.currentLine != null) {
                    String command;
                    depthDiff = this.countBrackets(this.currentLine);
                    this.depth += depthDiff;
                    if (depthDiff > 0 && this.depth == 3 && Objects.equals(command = this.getCommand(this.currentLine), "compound")) {
                        startMoleculeFound = true;
                        buffer.append("PC-Compound ::= {\n");
                    }
                    this.currentLine = this.input.readLine();
                }
                while (!endMoleculeFound && this.currentLine != null) {
                    depthDiff = this.countBrackets(this.currentLine);
                    this.depth += depthDiff;
                    if (depthDiff < 0 && this.depth == 2) {
                        endMoleculeFound = true;
                        buffer.append("}\n");
                        break;
                    }
                    buffer.append(this.currentLine).append('\n');
                    this.currentLine = this.input.readLine();
                }
                if (startMoleculeFound && endMoleculeFound) {
                    this.hasNext = true;
                    PCCompoundASNReader asnReader = new PCCompoundASNReader(new StringReader(buffer.toString()));
                    IChemFile cFile = asnReader.read((IChemFile)this.builder.newInstance(IChemFile.class, new Object[0]));
                    asnReader.close();
                    this.nextMolecule = (IAtomContainer)ChemFileManipulator.getAllAtomContainers((IChemFile)cFile).get(0);
                }
            }
            catch (IOException | IllegalArgumentException | CDKException exception) {
                logger.error((Object)"Error while reading next molecule: ", new Object[]{exception.getMessage()});
                logger.debug((Object)exception);
                this.hasNext = false;
            }
            if (!this.hasNext) {
                this.nextMolecule = null;
            }
            this.nextAvailableIsKnown = true;
        }
        return this.hasNext;
    }

    private int countChars(String copy, char character) {
        int occurences = 0;
        for (int i = 0; i < copy.length(); ++i) {
            if (character != copy.charAt(i)) continue;
            ++occurences;
        }
        return occurences;
    }

    private int countBrackets(String currentLine) {
        int bracketsOpen = this.countChars(currentLine, '{');
        int bracketsClose = this.countChars(currentLine, '}');
        return bracketsOpen - bracketsClose;
    }

    public IAtomContainer next() {
        if (!this.nextAvailableIsKnown) {
            this.hasNext = this.hasNext();
        }
        this.nextAvailableIsKnown = false;
        if (!this.hasNext) {
            throw new NoSuchElementException();
        }
        return this.nextMolecule;
    }

    public void close() throws IOException {
        this.input.close();
    }

    public void remove() {
        throw new UnsupportedOperationException();
    }

    private String getCommand(String line) {
        StringBuilder buffer = new StringBuilder();
        boolean foundBracket = false;
        for (int i = 0; i < line.length() && !foundBracket; ++i) {
            char currentChar = line.charAt(i);
            if (currentChar == '{') {
                foundBracket = true;
                continue;
            }
            buffer.append(currentChar);
        }
        return foundBracket ? buffer.toString().trim() : null;
    }

    public void setReader(Reader reader) {
        this.input = reader instanceof BufferedReader ? (BufferedReader)reader : new BufferedReader(reader);
        this.nextMolecule = null;
        this.nextAvailableIsKnown = false;
        this.hasNext = false;
    }

    public void setReader(InputStream reader) {
        this.setReader(new InputStreamReader(reader));
    }
}

