/*
 * Decompiled with CFR 0.152.
 */
package blogspot.software_and_algorithms.stern_library.data_structure;

import blogspot.software_and_algorithms.stern_library.data_structure.Interval;
import blogspot.software_and_algorithms.stern_library.data_structure.RedBlackTree;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;

public class DynamicIntervalTree<U extends Comparable<U>, T extends Interval<U>> {
    public RedBlackTree<T> binarySearchTree = new RedBlackTree<T>(new Comparator<T>(){

        @Override
        public int compare(T o1, T o2) {
            int result = ((Interval)o1).getLow().compareTo(((Interval)o2).getLow());
            if (result == 0) {
                result = ((Interval)o1).isClosedOnLow() != ((Interval)o2).isClosedOnLow() ? (((Interval)o1).isClosedOnLow() ? -1 : 1) : ((Interval)o1).compareTo(o2);
            }
            return result;
        }
    }){

        @Override
        protected RedBlackTree.Node<T> createNewNode(T value) {
            return new Node(value);
        }

        @Override
        public RedBlackTree.Node<T> delete(T value) {
            RedBlackTree.Node node = super.delete(value);
            if (node != null && node.getColor() != RedBlackTree.Node.NodeColor.BLACK) {
                for (RedBlackTree.Node temp = (Node)node.getParent(); temp != null; temp = temp.getParent()) {
                    temp.computeMaximumHighEndpoint();
                }
            }
            return node;
        }

        @Override
        protected void fixAfterDeletion(RedBlackTree.Node<T> node) {
            for (RedBlackTree.Node temp = (Node)node.getParent(); temp != null; temp = temp.getParent()) {
                temp.computeMaximumHighEndpoint();
            }
            super.fixAfterDeletion(node);
        }

        @Override
        protected void fixAfterInsertion(RedBlackTree.Node<T> node) {
            for (RedBlackTree.Node temp = (Node)node.getParent(); temp != null; temp = temp.getParent()) {
                temp.computeMaximumHighEndpoint();
            }
            super.fixAfterInsertion(node);
        }

        @Override
        protected void leftRotate(RedBlackTree.Node<T> node) {
            super.leftRotate(node);
            Node temp = (Node)node;
            temp.computeMaximumHighEndpoint();
            ((Node)temp.getParent()).computeMaximumHighEndpoint();
        }

        @Override
        protected void rightRotate(RedBlackTree.Node<T> node) {
            super.rightRotate(node);
            Node temp = (Node)node;
            temp.computeMaximumHighEndpoint();
            ((Node)temp.getParent()).computeMaximumHighEndpoint();
        }
    };

    public void clear() {
        this.binarySearchTree.clear();
    }

    public boolean delete(T interval) {
        return this.binarySearchTree.delete(interval) != null;
    }

    protected T fetchContainingInterval(U queryPoint) {
        RedBlackTree.Node node = (Node)this.binarySearchTree.getRoot();
        while (node != null) {
            int cmp;
            if (((Interval)node.getValue()).contains(queryPoint)) {
                return (T)((Interval)node.getValue());
            }
            RedBlackTree.Node leftChild = node.getLeft();
            node = node.getRight();
            if (leftChild == null || (cmp = ((Node)leftChild).getMaximumHighEndpoint().compareTo(queryPoint)) <= 0 && (cmp != 0 || !((Node)leftChild).isClosedOnEndpoint())) continue;
            node = leftChild;
        }
        return null;
    }

    public Collection<T> fetchContainingIntervals(U queryPoint) {
        T interval;
        if (queryPoint == null) {
            throw new NullPointerException("queryPoint is null");
        }
        ArrayList<T> result = new ArrayList<T>();
        while ((interval = this.fetchContainingInterval(queryPoint)) != null) {
            result.add(interval);
            this.delete(interval);
        }
        for (Interval next : result) {
            this.insert(next);
        }
        return result;
    }

    protected T fetchOverlappingInterval(T queryInterval) {
        RedBlackTree.Node node = (Node)this.binarySearchTree.getRoot();
        while (node != null) {
            int cmp;
            if (((Interval)node.getValue()).overlaps(queryInterval)) {
                return (T)((Interval)node.getValue());
            }
            RedBlackTree.Node leftChild = node.getLeft();
            node = node.getRight();
            if (leftChild == null || (cmp = ((Node)leftChild).getMaximumHighEndpoint().compareTo(((Interval)queryInterval).getLow())) <= 0 && (cmp != 0 || !((Node)leftChild).isClosedOnEndpoint() || !((Interval)queryInterval).isClosedOnLow())) continue;
            node = leftChild;
        }
        return null;
    }

    public Collection<T> fetchOverlappingIntervals(T queryInterval) {
        T interval;
        if (queryInterval == null) {
            throw new NullPointerException("queryInterval is null");
        }
        ArrayList<T> result = new ArrayList<T>();
        while ((interval = this.fetchOverlappingInterval(queryInterval)) != null) {
            result.add(interval);
            this.delete(interval);
        }
        for (Interval next : result) {
            this.insert(next);
        }
        return result;
    }

    public int getSize() {
        return this.binarySearchTree.getSize();
    }

    public boolean insert(T interval) {
        return this.binarySearchTree.insert(interval) != null;
    }

    protected static class Node<U extends Comparable<U>, T extends Interval<U>>
    extends RedBlackTree.Node<T> {
        private U maximumHighEndpoint;
        private boolean isClosedOnEndpoint;

        public Node(T interval) {
            super(interval);
            this.maximumHighEndpoint = ((Interval)interval).getHigh();
            this.isClosedOnEndpoint = ((Interval)interval).isClosedOnHigh();
        }

        protected void computeMaximumHighEndpoint() {
            int cmp;
            Object maximumHighEndpoint = ((Interval)this.getValue()).getHigh();
            boolean isClosedOnEndpoint = ((Interval)this.getValue()).isClosedOnHigh();
            RedBlackTree.Node child = this.getLeft();
            if (child != null && ((cmp = ((Node)child).maximumHighEndpoint.compareTo(maximumHighEndpoint)) > 0 || cmp == 0 && ((Node)child).isClosedOnEndpoint)) {
                maximumHighEndpoint = ((Node)child).maximumHighEndpoint;
                isClosedOnEndpoint = ((Node)child).isClosedOnEndpoint;
            }
            if ((child = this.getRight()) != null && ((cmp = ((Node)child).maximumHighEndpoint.compareTo(maximumHighEndpoint)) > 0 || cmp == 0 && ((Node)child).isClosedOnEndpoint)) {
                maximumHighEndpoint = ((Node)child).maximumHighEndpoint;
                isClosedOnEndpoint = ((Node)child).isClosedOnEndpoint;
            }
            this.maximumHighEndpoint = maximumHighEndpoint;
            this.isClosedOnEndpoint = isClosedOnEndpoint;
        }

        public Node<U, T> getLeft() {
            return (Node)super.getLeft();
        }

        public U getMaximumHighEndpoint() {
            return this.maximumHighEndpoint;
        }

        public Node<U, T> getParent() {
            return (Node)super.getParent();
        }

        public Node<U, T> getRight() {
            return (Node)super.getRight();
        }

        public boolean isClosedOnEndpoint() {
            return this.isClosedOnEndpoint;
        }
    }
}

