/*
 * Decompiled with CFR 0.152.
 */
package ru.itmo.ctlab.virgo.sgmwcs.graph;

import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import ru.itmo.ctlab.virgo.SolverException;
import ru.itmo.ctlab.virgo.sgmwcs.Signals;
import ru.itmo.ctlab.virgo.sgmwcs.graph.Edge;
import ru.itmo.ctlab.virgo.sgmwcs.graph.Graph;
import ru.itmo.ctlab.virgo.sgmwcs.graph.Node;
import ru.itmo.ctlab.virgo.sgmwcs.graph.Unit;

public class GraphPrinter {
    private final Graph graph;
    private final Signals signals;
    private final Set<Edge> cutEdges;

    public GraphPrinter(Graph graph, Signals signals, Set<Edge> cutEdges) {
        this.graph = graph;
        this.signals = signals;
        this.cutEdges = cutEdges;
    }

    public GraphPrinter(Graph graph, Signals signals) {
        this(graph, signals, Collections.emptySet());
    }

    private String formatSignal(int signal) {
        return "S" + signal;
    }

    private String printSignals(Unit unit) {
        List<Integer> sets = this.signals.unitSets(unit);
        String first = this.formatSignal(sets.get(0));
        return sets.subList(1, sets.size()).stream().map(this::formatSignal).reduce(first, (str, set) -> str + ", " + set);
    }

    private String formatUnit(String unit, String signals, String color) {
        return unit + " [label=\"" + unit + "(" + signals + ")\"" + color + "]";
    }

    private String formatUnit(String unit, String signals) {
        return unit + (this.signals == null ? "" : " [label=\"" + unit + "(" + signals + ")\"]");
    }

    private String weight(Unit unit) {
        return this.signals == null ? unit.getNum() + "" : this.signals.weight(unit) + "";
    }

    public void printGraph(String fileName) throws SolverException {
        this.printGraph(fileName, true);
    }

    public void toTSV(String nodesFile, String edgesFile) throws SolverException {
        this.toTSV(nodesFile, edgesFile, Collections.emptySet());
    }

    public void toTSV(String nodesFile, String edgesFile, Set<Unit> solution) throws SolverException {
        Path nodes = Paths.get(nodesFile, new String[0]);
        ArrayList<String> nodesList = new ArrayList<String>();
        Path edges = Paths.get(edgesFile, new String[0]);
        ArrayList<String> edgesList = new ArrayList<String>();
        nodesList.add("name\tsignals\tscore\tscore2\tsol");
        edgesList.add("source\ttarget\tsignals\tscore\tscore2\tsol");
        for (Unit u : this.graph.units()) {
            char isSol = solution.contains(u) ? (char)'1' : '0';
            String sigString = this.signals.unitSets(u).stream().map(s -> "S" + s).collect(Collectors.joining(","));
            double w = this.signals.weight(u);
            double rounded = (double)((int)(w * 100.0)) / 100.0;
            String str = sigString + '\t' + w + '\t' + rounded + '\t' + isSol;
            if (u instanceof Edge) {
                Edge e = (Edge)u;
                str = this.graph.getEdgeSource((Edge)e).num + "\t" + this.graph.getEdgeTarget((Edge)e).num + "\t" + str;
                edgesList.add(str);
                continue;
            }
            str = u.getNum() + "\t" + str;
            nodesList.add(str);
        }
        try {
            Files.write(nodes, nodesList, new OpenOption[0]);
            Files.write(edges, edgesList, new OpenOption[0]);
        }
        catch (IOException e) {
            throw new SolverException("Couldn't print graph");
        }
    }

    public void printGraph(String fileName, boolean sigLabels) throws SolverException {
        String str2;
        ArrayList<String> output = new ArrayList<String>();
        output.add("graph graphname {");
        for (Node v : this.graph.vertexSet()) {
            str2 = v.getNum() + "";
            output.add(this.formatUnit(str2, sigLabels ? this.printSignals(v) : this.weight(v)));
        }
        for (Edge e : this.graph.edgeSet()) {
            str2 = this.graph.getEdgeSource((Edge)e).num + "--" + this.graph.getEdgeTarget((Edge)e).num;
            if (this.cutEdges.contains(e)) {
                output.add(this.formatUnit(str2, sigLabels ? this.printSignals(e) : this.weight(e), " dir = none color=\"red\""));
                continue;
            }
            output.add(this.formatUnit(str2, sigLabels ? this.printSignals(e) : this.weight(e)));
        }
        if (sigLabels) {
            output.add("node[shape=record]");
            String signs = "signals [label=\"{" + IntStream.range(1, this.signals.size()).mapToObj(this::formatSignal).reduce("S0", (a, b) -> a + "|" + b) + "}|{" + IntStream.range(1, this.signals.size()).mapToObj(s -> this.signals.weight(s) + "").reduce(this.signals.weight(0) + "", (str, weight2) -> str + "|" + weight2) + "}\"]";
            output.add(signs);
        }
        output.add("}");
        Path file = Paths.get(fileName, new String[0]);
        try {
            Files.write(file, output, new OpenOption[0]);
        }
        catch (IOException e) {
            throw new SolverException("Couldn't print graph");
        }
    }
}

