/*
 * Decompiled with CFR 0.152.
 */
package com.amazon.sqlengine.executor.etree.temptable.column;

import com.amazon.sqlengine.executor.etree.temptable.TemporaryFile;
import com.amazon.sqlengine.executor.etree.temptable.column.ColumnSizeCalculator;
import com.amazon.sqlengine.executor.etree.temptable.column.DefaultColumnSlice;
import com.amazon.sqlengine.executor.etree.temptable.column.IColumnSlice;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;

public class FileMarkerColumnSlice
extends DefaultColumnSlice {
    private static final long serialVersionUID = 8346899091480541118L;
    private transient TemporaryFile.FileMarker[] m_data;
    private final int m_columnNumber;

    public FileMarkerColumnSlice(int n, int n2) {
        this.m_data = new TemporaryFile.FileMarker[n];
        this.m_columnNumber = n2;
    }

    @Override
    public int columnNumber() {
        return this.m_columnNumber;
    }

    @Override
    public boolean isNull(int n) {
        return null == this.m_data[n];
    }

    @Override
    public void setNull(int n) {
        this.m_data[n] = null;
    }

    @Override
    public TemporaryFile.FileMarker getFileMarker(int n) {
        return this.m_data[n];
    }

    @Override
    public IColumnSlice.ColumnSliceType getType() {
        return IColumnSlice.ColumnSliceType.FILE_MARKER;
    }

    @Override
    public void setFileMarker(int n, TemporaryFile.FileMarker fileMarker) {
        this.m_data[n] = fileMarker;
    }

    @Override
    public int size() {
        return this.m_data.length;
    }

    @Override
    public void copy(IColumnSlice iColumnSlice, int n, int n2, int n3) {
        FileMarkerColumnSlice fileMarkerColumnSlice = (FileMarkerColumnSlice)iColumnSlice;
        System.arraycopy(fileMarkerColumnSlice.m_data, n, this.m_data, n3, n2);
    }

    private void writeObject(ObjectOutputStream objectOutputStream) throws IOException {
        objectOutputStream.defaultWriteObject();
        int n = this.m_data.length;
        objectOutputStream.writeInt(n);
        for (int i = 0; i < n; ++i) {
            TemporaryFile.FileMarker fileMarker = this.m_data[i];
            if (null == fileMarker) {
                objectOutputStream.writeBoolean(true);
                continue;
            }
            objectOutputStream.writeBoolean(false);
            objectOutputStream.writeLong(fileMarker.m_pos);
            objectOutputStream.writeLong(fileMarker.m_length);
        }
    }

    private void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        objectInputStream.defaultReadObject();
        int n = objectInputStream.readInt();
        this.m_data = new TemporaryFile.FileMarker[n];
        for (int i = 0; i < n; ++i) {
            this.m_data[i] = objectInputStream.readBoolean() ? null : new TemporaryFile.FileMarker(objectInputStream.readLong(), objectInputStream.readLong());
        }
    }

    static double estimateRowSize(ColumnSizeCalculator.JavaSize javaSize) {
        return javaSize.getObjectShellSize() + 2 * javaSize.getLongSize();
    }

    static double estimateRowOverhead(ColumnSizeCalculator.JavaSize javaSize) {
        return javaSize.getObjectRefSize();
    }
}

