/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdbc.pooling;

import java.util.Iterator;
import java.util.NoSuchElementException;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.atomic.AtomicReference;
import oracle.jdbc.pooling.Pool;
import oracle.jdbc.pooling.PoolIterator;
import oracle.jdbc.pooling.PoolIteratorQueue;
import oracle.jdbc.pooling.Queue;
import oracle.jdbc.pooling.SkipList;
import oracle.jdbc.pooling.SkipListTuple;

final class LinkedListPool<T>
implements Pool<T> {
    private final AtomicLong elementsInstantiated = new AtomicLong(0L);
    private long listLength = 1L;
    private final Element listHead = new Element();
    private final AtomicReference<Element> fillRef = new AtomicReference<Element>(this.listHead);

    final long elementsInstantiated() {
        return this.elementsInstantiated.get();
    }

    final long listLength() {
        return this.listLength;
    }

    LinkedListPool() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void put(T t2) {
        Element element = this.fillRef.get();
        Element element2 = null;
        while (true) {
            if (element.tryReserve()) {
                try {
                    if (element.data == null) {
                        element.data = t2;
                        this.fillRef.set(element);
                        return;
                    }
                }
                finally {
                    element.release();
                }
            }
            if (element.next.get() == null && element2 == null) {
                element2 = new Element(t2);
            }
            if (element.next.compareAndSet(null, element2)) {
                this.fillRef.set(element2);
                ++this.listLength;
                return;
            }
            element = (Element)element.next.get();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void buildSkipLists(SkipListTuple ... skipListTupleArray) {
        int n2;
        final Queue[] queueArray = new Queue[skipListTupleArray.length];
        for (int i2 = 0; i2 < skipListTupleArray.length; ++i2) {
            queueArray[i2] = new Queue();
        }
        final LinkedListPool linkedListPool = this;
        PoolIterator<Element> poolIterator = this.poolElementsIterator(true, null);
        try {
            while (poolIterator.hasNext()) {
                Element element = (Element)poolIterator.next();
                for (n2 = 0; n2 < skipListTupleArray.length; ++n2) {
                    if (null == element.data) {
                        throw new NullPointerException("no data");
                    }
                    if (!skipListTupleArray[n2].getPredicate().test(element.data)) continue;
                    queueArray[n2].enqueue(element);
                }
            }
        }
        finally {
            poolIterator.release();
        }
        for (int i3 = 0; i3 < queueArray.length; ++i3) {
            n2 = i3;
            skipListTupleArray[i3].getConsumer().accept(new SkipList<T>(){

                @Override
                public PoolIterator<T> poolIterator(boolean bl) {
                    return linkedListPool.poolIterator(bl, queueArray[n2]);
                }
            });
        }
    }

    @Override
    public PoolIterator<T> poolIterator(boolean bl) {
        return this.poolIterator(bl, null);
    }

    private PoolIterator<T> poolIterator(final boolean bl, final Queue<Element> queue) {
        return new PoolIterator<T>(){
            final PoolIterator<Element> it;
            {
                this.it = LinkedListPool.this.poolElementsIterator(bl, queue);
            }

            @Override
            public boolean hasNext() {
                return this.it.hasNext();
            }

            @Override
            public T next() {
                return ((Element)this.it.next()).data;
            }

            @Override
            public void remove() {
                this.it.remove();
            }

            @Override
            public void release() {
                this.it.release();
            }

            @Override
            public boolean isSleeping() {
                return this.it.isSleeping();
            }

            @Override
            public boolean isAlive() {
                return this.it.isAlive();
            }
        };
    }

    private PoolIterator<Element> poolElementsIterator(final boolean bl, final Queue<Element> queue) {
        final Thread thread = Thread.currentThread();
        LinkedListPool linkedListPool = this;
        return new PoolIterator<Element>(){
            volatile Iterator<Element> it;
            volatile Element currentElement;
            volatile boolean outerReservation;
            volatile boolean nextReserved;
            final AtomicBoolean released;
            private boolean sleeping;
            private final Queue<Element> revisitQueue;
            {
                this.it = null != queue ? queue.Iterator() : LinkedListPool.this.elementsIterator();
                this.currentElement = null;
                this.outerReservation = false;
                this.nextReserved = false;
                this.released = new AtomicBoolean(false);
                this.sleeping = false;
                this.revisitQueue = new Queue();
            }

            @Override
            public boolean isAlive() {
                return !this.released.get() && thread.isAlive();
            }

            @Override
            public boolean isSleeping() {
                return this.sleeping;
            }

            private void throwIfWrongThread() {
                if (thread != Thread.currentThread()) {
                    throw new IllegalStateException("PoolIterator has been run by a wrong thread");
                }
            }

            private boolean preReserved(Element element) {
                return element.reserved.get() == Thread.currentThread();
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            private Element reserveNext() {
                Element element;
                while (this.it.hasNext()) {
                    element = this.it.next();
                    if (element.tryReserve()) {
                        if (element.data != null) {
                            Element element2 = element;
                            return element2;
                        }
                        element.release();
                        continue;
                    }
                    if (this.preReserved(element)) {
                        if (element.data == null) continue;
                        this.outerReservation = true;
                        return element;
                    }
                    if (!bl) continue;
                    element.poolIteratorQueue.enqueue(this);
                    this.revisitQueue.enqueue(element);
                }
                element = null;
                Element element3;
                while ((element3 = this.revisitQueue.dequeue()) != null) {
                    if (element3 == element) {
                        element = null;
                        try {
                            this.sleeping = true;
                            Thread.sleep(5L);
                        }
                        catch (InterruptedException interruptedException) {
                        }
                        finally {
                            this.sleeping = false;
                        }
                    }
                    if (null == element) {
                        element = element3;
                    }
                    if (element3.poolIteratorQueue.peek(this)) {
                        if (element3.tryReserve()) {
                            element3.poolIteratorQueue.disable(this);
                            if (element3.data != null) {
                                return element3;
                            }
                            element3.release();
                            continue;
                        }
                        this.revisitQueue.enqueue(element3);
                        continue;
                    }
                    this.revisitQueue.enqueue(element3);
                }
                return null;
            }

            @Override
            public boolean hasNext() {
                this.throwIfWrongThread();
                if (this.nextReserved) {
                    return true;
                }
                if (this.currentElement != null) {
                    if (this.outerReservation) {
                        this.outerReservation = false;
                    } else {
                        this.currentElement.release();
                    }
                }
                this.nextReserved = (this.currentElement = this.reserveNext()) != null;
                return this.nextReserved;
            }

            @Override
            public Element next() {
                this.throwIfWrongThread();
                if (this.hasNext()) {
                    this.nextReserved = false;
                    return this.currentElement;
                }
                throw new NoSuchElementException();
            }

            @Override
            public void remove() {
                this.throwIfWrongThread();
                if (this.currentElement != null) {
                    this.currentElement.data = null;
                    if (this.currentElement.id < ((Element)LinkedListPool.this.fillRef.get()).id) {
                        LinkedListPool.this.fillRef.set(this.currentElement);
                    }
                } else {
                    throw new IllegalStateException();
                }
            }

            @Override
            public void release() {
                this.throwIfWrongThread();
                if (this.released.compareAndSet(false, true)) {
                    this.revisitQueue.clear();
                    if (this.currentElement != null) {
                        if (this.outerReservation) {
                            this.outerReservation = false;
                        } else {
                            this.currentElement.release();
                        }
                        this.currentElement = null;
                    }
                }
            }
        };
    }

    private Iterator<Element> elementsIterator() {
        return new Iterator<Element>(){
            private Element current;
            {
                this.current = LinkedListPool.this.listHead;
            }

            @Override
            public boolean hasNext() {
                return null != this.current;
            }

            @Override
            public Element next() {
                if (null != this.current) {
                    Element element = this.current;
                    this.current = (Element)this.current.next.get();
                    return element;
                }
                return null;
            }
        };
    }

    private final class Element {
        private final long id;
        private final AtomicReference<Thread> reserved = new AtomicReference<Object>(null);
        private final AtomicReference<Element> next = new AtomicReference<Object>(null);
        volatile T data;
        private final PoolIteratorQueue<Element> poolIteratorQueue = new PoolIteratorQueue();

        private Element() {
            this((Object)null);
        }

        private Element(T t2) {
            this.data = t2;
            this.id = LinkedListPool.this.elementsInstantiated.getAndIncrement();
        }

        private boolean tryReserve() {
            return this.reserved.compareAndSet(null, Thread.currentThread());
        }

        private void release() {
            Thread thread = Thread.currentThread();
            if (!this.reserved.compareAndSet(thread, null)) {
                throw new IllegalStateException("element is released by wrong thread: " + thread);
            }
        }
    }
}

