/*
 * Decompiled with CFR 0.152.
 */
package org.openscience.cdk.inchi;

import io.github.dan2097.jnainchi.InchiFlag;
import io.github.dan2097.jnainchi.InchiOptions;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.openscience.cdk.tools.ILoggingTool;
import org.openscience.cdk.tools.LoggingToolFactory;

final class InChIOptionParser {
    private final ILoggingTool logger = LoggingToolFactory.createLoggingTool(InChIOptionParser.class);
    private final Map<String, InchiFlag> optMap = new HashMap<String, InchiFlag>();
    private final InchiOptions.InchiOptionsBuilder options;

    private InChIOptionParser() {
        for (InchiFlag flag : InchiFlag.values()) {
            this.optMap.put(flag.name(), flag);
        }
        this.optMap.put("15T", InchiFlag.OneFiveT);
        this.options = new InchiOptions.InchiOptionsBuilder();
    }

    private void processString(String optstr) {
        int pos = 0;
        block6: while (pos < optstr.length()) {
            InchiFlag flag;
            int next;
            switch (optstr.charAt(pos)) {
                case ' ': 
                case ',': 
                case '-': 
                case '/': {
                    ++pos;
                    continue block6;
                }
                case 'W': {
                    next = InChIOptionParser.getIndexOfEither(optstr, ',', ' ', ++pos);
                    if (next < 0) {
                        next = optstr.length();
                    }
                    String substring = optstr.substring(pos, next);
                    try {
                        this.options.withTimeoutMilliSeconds((long)((int)(1000.0 * Double.parseDouble(substring))));
                    }
                    catch (NumberFormatException ex) {
                        this.logger.warn((Object)("Invalid timtoue:" + substring));
                    }
                    continue block6;
                }
            }
            next = InChIOptionParser.getIndexOfEither(optstr, ',', ' ', pos);
            if (next < 0) {
                next = optstr.length();
            }
            if ((flag = this.optMap.get(optstr.substring(pos, next))) != null) {
                this.options.withFlag(new InchiFlag[]{flag});
            } else {
                this.logger.warn((Object)("Ignore unrecognized InChI flag:" + optstr.substring(pos, next)));
            }
            pos = next;
        }
    }

    private static int getIndexOfEither(String str, char chA, char chB, int fromIndex) {
        int iA = str.indexOf(chA, fromIndex);
        int iB = str.indexOf(chB, fromIndex);
        if (iA < 0) {
            return iB;
        }
        if (iB < 0) {
            return iA;
        }
        return Math.min(iA, iB);
    }

    static InchiOptions parseString(String str) {
        if (str == null) {
            return null;
        }
        InChIOptionParser parser = new InChIOptionParser();
        parser.processString(str);
        return parser.options.build();
    }

    static InchiOptions parseStrings(List<String> strs) {
        if (strs == null) {
            return null;
        }
        InChIOptionParser parser = new InChIOptionParser();
        for (String str : strs) {
            parser.processString(str);
        }
        return parser.options.build();
    }
}

