/*
 * Decompiled with CFR 0.152.
 */
package org.openscience.cdk.isomorphism;

import org.openscience.cdk.interfaces.IAtom;
import org.openscience.cdk.interfaces.IPseudoAtom;
import org.openscience.cdk.isomorphism.matchers.IQueryAtom;

public abstract class AtomMatcher {
    public abstract boolean matches(IAtom var1, IAtom var2);

    public static AtomMatcher forAny() {
        return new AnyMatcher();
    }

    public static AtomMatcher forElement() {
        return new ElementMatcher();
    }

    public static AtomMatcher forQuery() {
        return new QueryMatcher();
    }

    private static final class ElementMatcher
    extends AtomMatcher {
        private ElementMatcher() {
        }

        @Override
        public boolean matches(IAtom atom1, IAtom atom2) {
            return this.atomicNumber(atom1) == this.atomicNumber(atom2);
        }

        private int atomicNumber(IAtom atom) {
            Integer elem = atom.getAtomicNumber();
            if (elem != null) {
                return elem;
            }
            if (atom instanceof IPseudoAtom) {
                return 0;
            }
            throw new NullPointerException("an atom had unset atomic number");
        }
    }

    private static final class QueryMatcher
    extends AtomMatcher {
        private QueryMatcher() {
        }

        @Override
        public boolean matches(IAtom atom1, IAtom atom2) {
            return ((IQueryAtom)atom1).matches(atom2);
        }
    }

    private static final class AnyMatcher
    extends AtomMatcher {
        private AnyMatcher() {
        }

        @Override
        public boolean matches(IAtom atom1, IAtom atom2) {
            return true;
        }
    }
}

