/*
 * Decompiled with CFR 0.152.
 */
package com.amazon.jdbc.communications.interfaces;

import java.io.UnsupportedEncodingException;
import java.nio.ByteBuffer;

public abstract class AbstractOutboundMessage {
    public static byte TERMINATOR = 0;

    public abstract int getSize();

    public abstract void serialize(ByteBuffer var1, byte[] var2);

    public void serialize(ByteBuffer byteBuffer) {
        int n = this.getSize();
        if (byteBuffer.capacity() < n) {
            // empty if block
        }
        this.serialize(byteBuffer, this.toBytes(n));
    }

    protected byte[] toBytes(int n) {
        byte[] byArray = new byte[]{(byte)(n >>> 24), (byte)(n >>> 16), (byte)(n >>> 8), (byte)n};
        return byArray;
    }

    protected byte[] toBytes(String string) {
        try {
            return string.getBytes("UTF-8");
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            return null;
        }
    }

    protected void addField(ByteBuffer byteBuffer, byte[] byArray, byte[] byArray2) {
        byteBuffer.put(byArray);
        byteBuffer.put(TERMINATOR);
        byteBuffer.put(byArray2);
        byteBuffer.put(TERMINATOR);
    }
}

