/*
 * Decompiled with CFR 0.152.
 */
package com.amazon.jdbc.jdbc4;

import com.amazon.exceptions.ExceptionConverter;
import com.amazon.exceptions.JDBCMessageKey;
import com.amazon.jdbc.common.SConnection;
import com.amazon.jdbc.common.SConnectionHandle;
import com.amazon.jdbc.common.SPooledConnection;
import com.amazon.jdbc.jdbc4.S4Connection;
import com.amazon.jdbc.jdbc4.S4PooledConnection;
import com.amazon.jdbc.jdbc4.S4PreparedStatement;
import com.amazon.jdbc.jdbc4.S4PreparedStatementHandle;
import com.amazon.support.exceptions.ExceptionType;
import java.sql.PreparedStatement;
import java.sql.SQLClientInfoException;
import java.sql.SQLException;
import java.util.Properties;

public class S4ConnectionHandle
extends SConnectionHandle {
    public S4ConnectionHandle(SConnection sConnection, SPooledConnection sPooledConnection) throws SQLException {
        super(sConnection, sPooledConnection);
    }

    @Override
    public Properties getClientInfo() throws SQLException {
        this.checkIfOpen();
        try {
            return ((S4Connection)this.m_connection).getClientInfo();
        }
        catch (SQLException sQLException) {
            if (!this.m_connection.getConnection().isAlive()) {
                this.m_pooledConnection.onHandleError(sQLException);
            }
            throw sQLException;
        }
    }

    @Override
    public String getClientInfo(String string) throws SQLException {
        this.checkIfOpen();
        try {
            return ((S4Connection)this.m_connection).getClientInfo(string);
        }
        catch (SQLException sQLException) {
            if (!this.m_connection.getConnection().isAlive()) {
                this.m_pooledConnection.onHandleError(sQLException);
            }
            throw sQLException;
        }
    }

    @Override
    public PreparedStatement prepareStatement(String string) throws SQLException {
        this.checkIfOpen();
        try {
            PreparedStatement preparedStatement = this.m_connection.prepareStatement(string);
            return new S4PreparedStatementHandle((S4PooledConnection)this.m_pooledConnection, (S4PreparedStatement)preparedStatement);
        }
        catch (SQLException sQLException) {
            if (!this.m_connection.getConnection().isAlive()) {
                this.m_pooledConnection.onHandleError(sQLException);
            }
            throw sQLException;
        }
    }

    @Override
    public PreparedStatement prepareStatement(String string, int n) throws SQLException {
        this.checkIfOpen();
        try {
            PreparedStatement preparedStatement = this.m_connection.prepareStatement(string, n);
            return new S4PreparedStatementHandle((S4PooledConnection)this.m_pooledConnection, (S4PreparedStatement)preparedStatement);
        }
        catch (SQLException sQLException) {
            if (!this.m_connection.getConnection().isAlive()) {
                this.m_pooledConnection.onHandleError(sQLException);
            }
            throw sQLException;
        }
    }

    @Override
    public PreparedStatement prepareStatement(String string, int n, int n2) throws SQLException {
        this.checkIfOpen();
        try {
            PreparedStatement preparedStatement = this.m_connection.prepareStatement(string, n, n2);
            return new S4PreparedStatementHandle((S4PooledConnection)this.m_pooledConnection, (S4PreparedStatement)preparedStatement);
        }
        catch (SQLException sQLException) {
            if (!this.m_connection.getConnection().isAlive()) {
                this.m_pooledConnection.onHandleError(sQLException);
            }
            throw sQLException;
        }
    }

    @Override
    public PreparedStatement prepareStatement(String string, int n, int n2, int n3) throws SQLException {
        this.checkIfOpen();
        try {
            PreparedStatement preparedStatement = this.m_connection.prepareStatement(string, n, n2, n3);
            return new S4PreparedStatementHandle((S4PooledConnection)this.m_pooledConnection, (S4PreparedStatement)preparedStatement);
        }
        catch (SQLException sQLException) {
            if (!this.m_connection.getConnection().isAlive()) {
                this.m_pooledConnection.onHandleError(sQLException);
            }
            throw sQLException;
        }
    }

    @Override
    public PreparedStatement prepareStatement(String string, int[] nArray) throws SQLException {
        this.checkIfOpen();
        try {
            PreparedStatement preparedStatement = this.m_connection.prepareStatement(string, nArray);
            return new S4PreparedStatementHandle((S4PooledConnection)this.m_pooledConnection, (S4PreparedStatement)preparedStatement);
        }
        catch (SQLException sQLException) {
            if (!this.m_connection.getConnection().isAlive()) {
                this.m_pooledConnection.onHandleError(sQLException);
            }
            throw sQLException;
        }
    }

    @Override
    public PreparedStatement prepareStatement(String string, String[] stringArray) throws SQLException {
        this.checkIfOpen();
        try {
            PreparedStatement preparedStatement = this.m_connection.prepareStatement(string, stringArray);
            return new S4PreparedStatementHandle((S4PooledConnection)this.m_pooledConnection, (S4PreparedStatement)preparedStatement);
        }
        catch (SQLException sQLException) {
            if (!this.m_connection.getConnection().isAlive()) {
                this.m_pooledConnection.onHandleError(sQLException);
            }
            throw sQLException;
        }
    }

    @Override
    public void setClientInfo(Properties properties) throws SQLClientInfoException {
        if (this.m_isClosed) {
            throw (SQLClientInfoException)ExceptionConverter.getInstance().toSQLException(JDBCMessageKey.CONNECTION_CLOSED, this.m_connection.getWarningListener(), ExceptionType.CLIENT_INFO, new Object[0]);
        }
        try {
            ((S4Connection)this.m_connection).setClientInfo(properties);
        }
        catch (SQLClientInfoException sQLClientInfoException) {
            if (!this.m_connection.getConnection().isAlive()) {
                this.m_pooledConnection.onHandleError(sQLClientInfoException);
            }
            throw sQLClientInfoException;
        }
    }

    @Override
    public void setClientInfo(String string, String string2) throws SQLClientInfoException {
        if (this.m_isClosed) {
            throw (SQLClientInfoException)ExceptionConverter.getInstance().toSQLException(JDBCMessageKey.CONNECTION_CLOSED, this.m_connection.getWarningListener(), ExceptionType.CLIENT_INFO, new Object[0]);
        }
        try {
            ((S4Connection)this.m_connection).setClientInfo(string, string2);
        }
        catch (SQLClientInfoException sQLClientInfoException) {
            if (!this.m_connection.getConnection().isAlive()) {
                this.m_pooledConnection.onHandleError(sQLClientInfoException);
            }
            throw sQLClientInfoException;
        }
    }
}

