/*
 * Decompiled with CFR 0.152.
 */
package com.amazon.sqlengine.aeprocessor.aetree.relation;

import com.amazon.dsi.dataengine.interfaces.IColumn;
import com.amazon.dsi.dataengine.utilities.Nullable;
import com.amazon.dsi.dataengine.utilities.Searchable;
import com.amazon.dsi.dataengine.utilities.TypeMetadata;
import com.amazon.dsi.dataengine.utilities.Updatable;
import com.amazon.dsi.exceptions.InvalidOperationException;
import com.amazon.sqlengine.aeprocessor.AEColumnInfo;
import com.amazon.sqlengine.aeprocessor.AEQColumnName;
import com.amazon.sqlengine.aeprocessor.AEQTableName;
import com.amazon.sqlengine.aeprocessor.aetree.relation.AERelationalExpr;
import com.amazon.sqlengine.exceptions.SQLEngineException;
import com.amazon.sqlengine.utilities.SQLEngineMessageKey;
import com.amazon.support.exceptions.DiagState;
import com.amazon.support.exceptions.ErrorException;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;

public abstract class AENamedRelationalExpr
extends AERelationalExpr {
    private ArrayList<RenameColumn> m_renamedColumns;
    private String m_correlationSpecName;

    protected AENamedRelationalExpr() {
        this.m_renamedColumns = new ArrayList();
        this.m_correlationSpecName = "";
    }

    protected AENamedRelationalExpr(AENamedRelationalExpr aENamedRelationalExpr) {
        super(aENamedRelationalExpr);
        this.m_renamedColumns = new ArrayList<RenameColumn>(aENamedRelationalExpr.m_renamedColumns);
        this.m_correlationSpecName = aENamedRelationalExpr.m_correlationSpecName;
    }

    public abstract String getCatalogName();

    @Override
    public IColumn getColumn(int n) {
        if (!this.hasDerivedColumnList()) {
            return this.getBaseColumn(n);
        }
        return this.m_renamedColumns.get(n);
    }

    public String getCorrelationName() {
        return this.m_correlationSpecName;
    }

    public AEQTableName getQTableName() {
        return new AEQTableName(this.getCatalogName(), this.getSchemaName(), this.getTableName());
    }

    public abstract String getSchemaName();

    public abstract String getTableName();

    public boolean hasDerivedColumnList() {
        return !this.m_renamedColumns.isEmpty();
    }

    public boolean matchesName(AEQTableName aEQTableName, boolean bl) {
        if ("".equals(this.getTableName())) {
            throw new IllegalStateException("Named Relational Expression must have a name: " + this.getLogString());
        }
        if (!AENamedRelationalExpr.stringEquals(this.getTableName(), aEQTableName.getTableName(), bl)) {
            return false;
        }
        if (!"".equals(aEQTableName.getSchemaName()) && !AENamedRelationalExpr.stringEquals(this.getSchemaName(), aEQTableName.getSchemaName(), bl)) {
            return false;
        }
        return "".equals(aEQTableName.getCatalogName()) || AENamedRelationalExpr.stringEquals(this.getCatalogName(), aEQTableName.getCatalogName(), bl);
    }

    public boolean matchesNameCaseSensitive(AEQTableName aEQTableName) {
        return this.matchesName(aEQTableName, true);
    }

    public boolean matchesNameCaseInsensitive(AEQTableName aEQTableName) {
        return this.matchesName(aEQTableName, false);
    }

    @Override
    public int findColumn(String string, boolean bl) {
        if (null == string || string.length() == 0) {
            throw new IllegalArgumentException("name cannot be null or empty.");
        }
        int n = this.getColumnCount();
        for (int i = 0; i < n; ++i) {
            String string2 = this.getColumn(i).getName();
            if (!(bl ? string.equals(string2) : string.equalsIgnoreCase(string2))) continue;
            return i;
        }
        return -1;
    }

    @Override
    public AEColumnInfo findQColumn(AEQColumnName aEQColumnName, boolean bl) throws ErrorException {
        boolean bl2 = aEQColumnName.hasQualifier();
        if (bl2 && !this.matchesName(aEQColumnName.getQTable(), bl)) {
            return null;
        }
        int n = this.findColumn(aEQColumnName.getColName(), bl);
        if (0 > n) {
            if (bl2) {
                throw new SQLEngineException(DiagState.DIAG_COLUMN_MISSING, SQLEngineMessageKey.COLUMN_NOT_FOUND.name(), new String[]{aEQColumnName.toString()});
            }
            return null;
        }
        return new AEColumnInfo(this, n, false);
    }

    public void overrideColumnNames(List<String> list, boolean bl) throws ErrorException {
        if (null == list) {
            throw new IllegalArgumentException("names cannot be null or empty.");
        }
        if (this.m_correlationSpecName.length() == 0) {
            throw new InvalidOperationException();
        }
        if (list.size() != this.getColumnCount()) {
            String[] stringArray = new String[]{this.m_correlationSpecName, Integer.toString(this.getColumnCount()), Integer.toString(list.size())};
            throw new SQLEngineException(DiagState.DIAG_SYNTAX_ERR_OR_ACCESS_VIOLATION, SQLEngineMessageKey.CORR_SPEC_INVALID_NUM_COLS.name(), stringArray);
        }
        this.checkNameUniqueness(list, bl);
        this.m_renamedColumns.clear();
        int n = 0;
        for (String string : list) {
            IColumn iColumn = this.getBaseColumn(n);
            if (null == iColumn) {
                throw new NullPointerException("Could not retrieve column.");
            }
            this.m_renamedColumns.add(new RenameColumn(iColumn, string));
            ++n;
        }
    }

    public void overrideCorrelationSpec(AENamedRelationalExpr aENamedRelationalExpr, int[] nArray) {
        this.m_correlationSpecName = aENamedRelationalExpr.m_correlationSpecName;
        if (!aENamedRelationalExpr.m_renamedColumns.isEmpty()) {
            assert (nArray.length == this.getColumnCount());
            this.m_renamedColumns.clear();
            for (int i = 0; i < nArray.length; ++i) {
                Object object;
                if (0 <= nArray[i]) {
                    object = aENamedRelationalExpr.m_renamedColumns.get(nArray[i]).getName();
                    this.m_renamedColumns.add(new RenameColumn(this.getBaseColumn(i), (String)object));
                    continue;
                }
                object = this.getBaseColumn(i);
                this.m_renamedColumns.add(new RenameColumn((IColumn)object, object.getName()));
            }
        }
    }

    public void overrideCorrelationSpec(AENamedRelationalExpr aENamedRelationalExpr) {
        int[] nArray = new int[aENamedRelationalExpr.getColumnCount()];
        for (int i = 0; i < aENamedRelationalExpr.getColumnCount(); ++i) {
            nArray[i] = i;
        }
        this.overrideCorrelationSpec(aENamedRelationalExpr, nArray);
    }

    public void overrideCorrelationSpec(AENamedRelationalExpr aENamedRelationalExpr, AENamedRelationalExpr aENamedRelationalExpr2, String string) {
        int n = this.getColumnCount();
        assert (n == aENamedRelationalExpr.getColumnCount() + aENamedRelationalExpr2.getColumnCount());
        if (!aENamedRelationalExpr.m_renamedColumns.isEmpty() || !aENamedRelationalExpr2.m_renamedColumns.isEmpty()) {
            if (null == string) {
                string = "";
            }
            this.m_correlationSpecName = string;
            this.m_renamedColumns.clear();
            for (int i = 0; i < n; ++i) {
                Object object;
                if (i < aENamedRelationalExpr.getColumnCount() && !aENamedRelationalExpr.m_renamedColumns.isEmpty()) {
                    object = aENamedRelationalExpr.m_renamedColumns.get(i).getName();
                    this.m_renamedColumns.add(new RenameColumn(this.getBaseColumn(i), (String)object));
                    continue;
                }
                if (i >= aENamedRelationalExpr.getColumnCount() && !aENamedRelationalExpr2.m_renamedColumns.isEmpty()) {
                    int n2 = i - aENamedRelationalExpr.getColumnCount();
                    String string2 = aENamedRelationalExpr2.m_renamedColumns.get(n2).getName();
                    this.m_renamedColumns.add(new RenameColumn(this.getBaseColumn(n2), string2));
                    continue;
                }
                object = this.getBaseColumn(i);
                this.m_renamedColumns.add(new RenameColumn((IColumn)object, object.getName()));
            }
        }
    }

    public void setCorrelationName(String string) {
        if (null == string) {
            throw new NullPointerException("Correlation name cannot be null.");
        }
        this.m_correlationSpecName = string;
    }

    public abstract IColumn getBaseColumn(int var1);

    private void checkNameUniqueness(List<String> list, boolean bl) throws ErrorException {
        HashSet<String> hashSet = new HashSet<String>(list.size());
        for (String string : list) {
            if (!bl) {
                string = string.toLowerCase();
            }
            if (hashSet.add(string)) continue;
            String[] stringArray = new String[]{this.m_correlationSpecName.toUpperCase(), string.toUpperCase()};
            throw new SQLEngineException(DiagState.DIAG_SYNTAX_ERR_OR_ACCESS_VIOLATION, SQLEngineMessageKey.CORR_SPEC_NON_UNIQUE_COLS.name(), stringArray);
        }
    }

    private static boolean stringEquals(String string, String string2, boolean bl) {
        return bl ? string.equals(string2) : string.equalsIgnoreCase(string2);
    }

    private static class RenameColumn
    implements IColumn {
        private final IColumn m_col;
        private final String m_name;

        public RenameColumn(IColumn iColumn, String string) {
            this.m_col = iColumn;
            this.m_name = string;
        }

        @Override
        public String getCatalogName() {
            return this.m_col.getCatalogName();
        }

        @Override
        public long getColumnLength() {
            return this.m_col.getColumnLength();
        }

        @Override
        public long getDisplaySize() throws ErrorException {
            return this.m_col.getDisplaySize();
        }

        @Override
        public String getLabel() {
            return this.m_name;
        }

        @Override
        public String getName() {
            return this.m_name;
        }

        @Override
        public Nullable getNullable() {
            return this.m_col.getNullable();
        }

        @Override
        public String getSchemaName() {
            return this.m_col.getSchemaName();
        }

        @Override
        public Searchable getSearchable() {
            return this.m_col.getSearchable();
        }

        @Override
        public String getTableName() {
            return this.m_col.getTableName();
        }

        @Override
        public TypeMetadata getTypeMetadata() {
            return this.m_col.getTypeMetadata();
        }

        @Override
        public Updatable getUpdatable() {
            return this.m_col.getUpdatable();
        }

        @Override
        public boolean isAutoUnique() {
            return this.m_col.isAutoUnique();
        }

        @Override
        public boolean isCaseSensitive() {
            return this.m_col.isCaseSensitive();
        }

        @Override
        public boolean isDefinitelyWritable() {
            return this.m_col.isDefinitelyWritable();
        }

        @Override
        public boolean isUnnamed() {
            return this.m_col.isUnnamed();
        }
    }
}

