/*
 * Decompiled with CFR 0.152.
 */
package opennlp.tools.formats.muc;

import java.io.IOException;
import java.io.Reader;
import java.util.HashMap;
import java.util.Map;
import opennlp.tools.util.InvalidFormatException;
import opennlp.tools.util.StringUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SgmlParser {
    private static String extractTagName(CharSequence tagChars) throws InvalidFormatException {
        int fromOffset = 1;
        if (tagChars.length() > 1 && tagChars.charAt(1) == '/') {
            fromOffset = 2;
        }
        for (int ci = 1; ci < tagChars.length(); ++ci) {
            if (tagChars.charAt(ci) != '>' && !StringUtil.isWhitespace(tagChars.charAt(ci))) continue;
            return ((Object)tagChars.subSequence(fromOffset, ci)).toString();
        }
        throw new InvalidFormatException("Failed to extract tag name!");
    }

    private static Map<String, String> getAttributes(CharSequence tagChars) {
        HashMap<String, String> attributes = new HashMap<String, String>();
        StringBuilder key = new StringBuilder();
        StringBuilder value = new StringBuilder();
        boolean extractKey = false;
        boolean extractValue = false;
        for (int i = 0; i < tagChars.length(); ++i) {
            if (StringUtil.isWhitespace(tagChars.charAt(i)) && !extractValue) {
                extractKey = true;
                continue;
            }
            if (extractKey && ('=' == tagChars.charAt(i) || StringUtil.isWhitespace(tagChars.charAt(i)))) {
                extractKey = false;
                continue;
            }
            if (extractKey) {
                key.append(tagChars.charAt(i));
                continue;
            }
            if ('\"' == tagChars.charAt(i)) {
                if (extractValue) {
                    attributes.put(key.toString(), value.toString());
                    key.setLength(0);
                    value.setLength(0);
                }
                extractValue = !extractValue;
                continue;
            }
            if (!extractValue) continue;
            value.append(tagChars.charAt(i));
        }
        return attributes;
    }

    public void parse(Reader in, ContentHandler handler) throws IOException {
        int c;
        StringBuilder buffer = new StringBuilder();
        boolean isInsideTag = false;
        boolean isStartTag = true;
        int lastChar = -1;
        while ((c = in.read()) != -1) {
            if (60 == c) {
                if (isInsideTag) {
                    throw new InvalidFormatException("Did not expect < char!");
                }
                if (buffer.toString().trim().length() > 0) {
                    handler.characters(buffer.toString().trim());
                }
                buffer.setLength(0);
                isInsideTag = true;
                isStartTag = true;
            }
            buffer.appendCodePoint(c);
            if (47 == c && lastChar == 60) {
                isStartTag = false;
            }
            if (62 == c) {
                if (!isInsideTag) {
                    throw new InvalidFormatException("Did not expect > char!");
                }
                if (isStartTag) {
                    handler.startElement(SgmlParser.extractTagName(buffer), SgmlParser.getAttributes(buffer));
                } else {
                    handler.endElement(SgmlParser.extractTagName(buffer));
                }
                buffer.setLength(0);
                isInsideTag = false;
            }
            lastChar = c;
        }
        if (isInsideTag) {
            throw new InvalidFormatException("Did not find matching > char!");
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static abstract class ContentHandler {
        public void startElement(String name, Map<String, String> attributes) throws InvalidFormatException {
        }

        public void characters(CharSequence chars) throws InvalidFormatException {
        }

        public void endElement(String name) throws InvalidFormatException {
        }
    }
}

