/*
 * Decompiled with CFR 0.152.
 */
package org.chocosolver.solver.search.loop.lns;

import org.chocosolver.solver.search.loop.lns.neighbors.INeighbor;
import org.chocosolver.solver.search.loop.lns.neighbors.IntNeighbor;
import org.chocosolver.solver.search.loop.lns.neighbors.PropagationGuidedNeighborhood;
import org.chocosolver.solver.search.loop.lns.neighbors.RandomNeighborhood;
import org.chocosolver.solver.search.loop.lns.neighbors.ReversePropagationGuidedNeighborhood;
import org.chocosolver.solver.search.loop.lns.neighbors.SequenceNeighborhood;
import org.chocosolver.solver.search.loop.lns.neighbors.SetRandomNeighbor;
import org.chocosolver.solver.variables.IntVar;
import org.chocosolver.solver.variables.SetVar;

public class INeighborFactory {
    public static INeighbor blackBox(IntVar ... vars) {
        return INeighborFactory.sequencer(INeighborFactory.propagationGuided(vars), INeighborFactory.reversedPropagationGuided(vars), INeighborFactory.random(vars));
    }

    public static IntNeighbor random(IntVar ... vars) {
        return INeighborFactory.random(0L, vars);
    }

    public static IntNeighbor random(long seed, IntVar ... vars) {
        return new RandomNeighborhood(vars, 3, seed);
    }

    public static IntNeighbor propagationGuided(IntVar ... vars) {
        return INeighborFactory.propagationGuided(0L, vars);
    }

    public static IntNeighbor propagationGuided(long seed, IntVar ... vars) {
        return new PropagationGuidedNeighborhood(vars, 30.0, 10, seed);
    }

    public static IntNeighbor reversedPropagationGuided(IntVar ... vars) {
        return INeighborFactory.reversedPropagationGuided(10L, vars);
    }

    public static IntNeighbor reversedPropagationGuided(long seed, IntVar ... vars) {
        return new ReversePropagationGuidedNeighborhood(vars, 0, 30, seed);
    }

    public static INeighbor sequencer(INeighbor ... neighbors) {
        return new SequenceNeighborhood(neighbors);
    }

    public static INeighbor setVarRandom(SetVar setVar) {
        return new SetRandomNeighbor(setVar);
    }
}

