/*
 * Decompiled with CFR 0.152.
 */
package org.chocosolver.solver.constraints.ternary;

import org.chocosolver.solver.ICause;
import org.chocosolver.solver.Priority;
import org.chocosolver.solver.constraints.Propagator;
import org.chocosolver.solver.constraints.PropagatorPriority;
import org.chocosolver.solver.exception.ContradictionException;
import org.chocosolver.solver.variables.IntVar;
import org.chocosolver.solver.variables.Variable;
import org.chocosolver.solver.variables.events.IntEventType;
import org.chocosolver.util.ESat;
import org.chocosolver.util.objects.setDataStructures.iterable.IntIterableBitSet;

public class PropModXYZ
extends Propagator<IntVar> {
    private final IntVar x;
    private final IntVar y;
    private final IntVar z;
    private IntIterableBitSet usedValues;
    private final boolean allEnnums;
    private static final int THRESHOLD = 10000;

    public PropModXYZ(IntVar x, IntVar y, IntVar z) {
        super((Variable[])new IntVar[]{x, y, z}, (Priority)PropagatorPriority.TERNARY, false);
        this.x = x;
        this.y = y;
        this.z = z;
        boolean bl = this.allEnnums = x.hasEnumeratedDomain() && y.hasEnumeratedDomain() && z.hasEnumeratedDomain();
        if (z.hasEnumeratedDomain()) {
            this.usedValues = new IntIterableBitSet();
            this.usedValues.setOffset(z.getLB());
        }
    }

    @Override
    public int getPropagationConditions(int vIdx) {
        return IntEventType.boundAndInst();
    }

    @Override
    public void propagate(int evtmask) throws ContradictionException {
        int zub;
        int zlb;
        this.y.removeValue(0, (ICause)this);
        int xlb = this.x.getLB();
        int xub = this.x.getUB();
        int ylb = this.y.getLB();
        int yub = this.y.getUB();
        if (xlb >= 0) {
            zlb = 0;
            zub = Math.min(xub, Math.max(Math.abs(this.y.getLB()), Math.abs(this.y.getUB())) - 1);
        } else if (xub < 0) {
            zub = 0;
            zlb = Math.max(xlb, -Math.max(Math.abs(this.y.getLB()), Math.abs(this.y.getUB())) + 1);
        } else {
            zlb = Math.max(xlb, Math.min(ylb, Math.min(-ylb, -yub)) + 1);
            zub = Math.min(xub, Math.max(yub, Math.max(-ylb, -yub)) - 1);
        }
        this.z.updateBounds(zlb, zub, this);
        long card = (long)this.x.getDomainSize() * (long)this.y.getDomainSize();
        if (this.allEnnums && card <= 10000L) {
            this.propagateEnumerated();
        } else {
            this.propagateBounded();
        }
    }

    private void propagateEnumerated() throws ContradictionException {
        this.usedValues.clear();
        int vx = this.x.getLB();
        while (vx <= this.x.getUB()) {
            boolean toRemove = true;
            int vy = this.y.getLB();
            while (vy <= this.y.getUB()) {
                if (vy != 0 && this.z.contains(vx % vy)) {
                    this.usedValues.add(vx % vy);
                    toRemove = false;
                }
                vy = this.y.nextValue(vy);
            }
            if (toRemove) {
                this.x.removeValue(vx, (ICause)this);
            }
            vx = this.x.nextValue(vx);
        }
        this.z.removeAllValuesBut(this.usedValues, this);
        int vy = this.y.getLB();
        while (vy <= this.y.getUB()) {
            if (!PropModXYZ.containsOneDivid(this.x, vy, this.z)) {
                this.y.removeValue(vy, (ICause)this);
            }
            vy = this.y.nextValue(vy);
        }
    }

    private void propagateBounded() throws ContradictionException {
        boolean hasChange = true;
        while (hasChange) {
            hasChange = false;
            while (!PropModXYZ.containsOneDivid(this.x.getLB(), this.y, this.z)) {
                hasChange |= this.x.updateLowerBound(this.x.getLB() + 1, (ICause)this);
            }
            while (!PropModXYZ.containsOneDivid(this.x.getUB(), this.y, this.z)) {
                hasChange |= this.x.updateUpperBound(this.x.getUB() - 1, (ICause)this);
            }
            while (!PropModXYZ.containsOneDividLB(this.x, this.y, this.z.getLB())) {
                hasChange |= this.z.updateLowerBound(this.z.getLB() + 1, (ICause)this);
            }
            while (!PropModXYZ.containsOneDividUB(this.x, this.y, this.z.getUB())) {
                hasChange |= this.z.updateUpperBound(this.z.getUB() - 1, (ICause)this);
            }
            while (this.y.getLB() == 0 || !PropModXYZ.containsOneDivid(this.x, this.y.getLB(), this.z)) {
                hasChange |= this.y.updateLowerBound(this.y.getLB() + 1, (ICause)this);
            }
            while (this.y.getUB() == 0 || !PropModXYZ.containsOneDivid(this.x, this.y.getUB(), this.z)) {
                hasChange |= this.y.updateUpperBound(this.y.getUB() - 1, (ICause)this);
            }
        }
    }

    private static boolean containsOneDivid(int v, IntVar Y, IntVar Z) {
        int vy = Y.getLB();
        while (vy <= Y.getUB()) {
            if (vy != 0) {
                int vz = Z.getLB();
                while (vz <= Z.getUB()) {
                    if (v % vy == vz) {
                        return true;
                    }
                    vz = Z.nextValue(vz);
                }
            }
            vy = Y.nextValue(vy);
        }
        return false;
    }

    private static boolean containsOneDivid(IntVar X, int v, IntVar Z) {
        if (v != 0) {
            int vx = X.getLB();
            while (vx <= X.getUB()) {
                int vz = Z.getLB();
                while (vz <= Z.getUB()) {
                    if (vx % v == vz) {
                        return true;
                    }
                    vz = Z.nextValue(vz);
                }
                vx = X.nextValue(vx);
            }
        }
        return false;
    }

    private static boolean containsOneDividLB(IntVar X, IntVar Y, int v) {
        int vy = Y.getLB();
        while (vy <= Y.getUB()) {
            if (vy != 0) {
                int vx = X.getLB();
                while (vx <= X.getUB()) {
                    if (vx % vy == v) {
                        return true;
                    }
                    vx = X.nextValue(vx);
                }
            }
            vy = Y.nextValue(vy);
        }
        return false;
    }

    private static boolean containsOneDividUB(IntVar X, IntVar Y, int v) {
        int vy = Y.getUB();
        while (vy >= Y.getLB()) {
            if (vy != 0) {
                int vx = X.getUB();
                while (vx >= X.getLB()) {
                    if (vx % vy == v) {
                        return true;
                    }
                    vx = X.previousValue(vx);
                }
            }
            vy = Y.previousValue(vy);
        }
        return false;
    }

    @Override
    public ESat isEntailed() {
        if (this.x.isInstantiated() && this.y.isInstantiated() && this.z.isInstantiated()) {
            return this.y.getValue() != 0 && this.x.getValue() % this.y.getValue() == this.z.getValue() ? ESat.TRUE : ESat.FALSE;
        }
        return ESat.UNDEFINED;
    }

    @Override
    public String toString() {
        return this.x.getName() + " % " + this.y.getName() + " = " + this.z.getName();
    }
}

