/*
 * Decompiled with CFR 0.152.
 */
package org.chocosolver.solver.constraints.reification;

import org.chocosolver.sat.Reason;
import org.chocosolver.solver.constraints.Explained;
import org.chocosolver.solver.constraints.Propagator;
import org.chocosolver.solver.exception.ContradictionException;
import org.chocosolver.solver.variables.BoolVar;
import org.chocosolver.solver.variables.IntVar;
import org.chocosolver.solver.variables.Variable;
import org.chocosolver.solver.variables.events.IntEventType;
import org.chocosolver.util.ESat;

@Explained
public class PropXleYHalfReif
extends Propagator<IntVar> {
    private final IntVar x;
    private final IntVar y;
    private final BoolVar b;

    public PropXleYHalfReif(IntVar x, IntVar y, BoolVar b) {
        super((Variable[])new IntVar[]{x, y, b});
        this.x = x;
        this.y = y;
        this.b = b;
    }

    @Override
    public int getPropagationConditions(int vIdx) {
        if (vIdx == 1) {
            return IntEventType.DECUPP.getMask();
        }
        return IntEventType.INCLOW.getMask();
    }

    @Override
    public void propagate(int evtmask) throws ContradictionException {
        int y_max;
        if (this.b.isInstantiatedTo(0)) {
            this.setPassive();
            return;
        }
        int x_min = this.x.getLB();
        if (x_min > (y_max = this.y.getUB())) {
            this.b.setToFalse(this, this.lcg() ? Reason.r(this.x.getMinLit(), this.y.getMaxLit()) : Reason.undef());
            this.setPassive();
            return;
        }
        if (this.b.isInstantiatedTo(1)) {
            this.x.updateUpperBound(y_max, this, this.lcg() ? Reason.r(this.y.getMaxLit(), this.b.getValLit()) : Reason.undef());
            this.y.updateLowerBound(x_min, this, this.lcg() ? Reason.r(this.x.getMinLit(), this.b.getValLit()) : Reason.undef());
            if (this.x.getUB() <= this.y.getLB()) {
                this.setPassive();
            }
        }
    }

    @Override
    public ESat isEntailed() {
        if (this.isCompletelyInstantiated()) {
            if (this.b.isInstantiatedTo(1)) {
                return ESat.eval(this.x.getValue() <= this.y.getValue());
            }
            return ESat.TRUE;
        }
        return ESat.UNDEFINED;
    }
}

