/*
 * Decompiled with CFR 0.152.
 */
package dr.evomodel.continuous;

import dr.evolution.continuous.ContinuousTraitLikelihood;
import dr.evolution.continuous.Contrastable;
import dr.evomodel.tree.TreeModel;
import dr.inference.model.Likelihood;
import dr.xml.AbstractXMLObjectParser;
import dr.xml.ElementRule;
import dr.xml.XMLObject;
import dr.xml.XMLObjectParser;
import dr.xml.XMLParseException;
import dr.xml.XMLSyntaxRule;
import java.util.ArrayList;

public class ContinuousLikelihood
extends Likelihood.Abstract {
    public static final String CONTINUOUS_LIKELIHOOD = "continuousLikelihood";
    public static final String TRAIT = "trait";
    public static final String NAME = "name";
    public static XMLObjectParser PARSER = new AbstractXMLObjectParser(){
        private XMLSyntaxRule[] rules = new XMLSyntaxRule[]{new ElementRule(TreeModel.class)};

        @Override
        public String getParserName() {
            return ContinuousLikelihood.CONTINUOUS_LIKELIHOOD;
        }

        @Override
        public Object parseXMLObject(XMLObject xMLObject) throws XMLParseException {
            TreeModel treeModel = (TreeModel)xMLObject.getChild(TreeModel.class);
            ArrayList<String> arrayList = new ArrayList<String>();
            for (int i = 0; i < xMLObject.getChildCount(); ++i) {
                Object object = xMLObject.getChild(i);
                if (object instanceof XMLObject) {
                    XMLObject xMLObject2 = (XMLObject)object;
                    if (!xMLObject2.getName().equals(ContinuousLikelihood.TRAIT)) continue;
                    arrayList.add(xMLObject2.getStringAttribute(ContinuousLikelihood.NAME));
                    continue;
                }
                throw new XMLParseException("unknown child element found in continuousLikelihood");
            }
            if (treeModel == null) {
                throw new XMLParseException("tree model element missing from continuousLikelihood element");
            }
            String[] stringArray = new String[arrayList.size()];
            for (int i = 0; i < stringArray.length; ++i) {
                stringArray[i] = (String)arrayList.get(i);
            }
            ContinuousLikelihood continuousLikelihood = new ContinuousLikelihood(treeModel, stringArray);
            return continuousLikelihood;
        }

        @Override
        public String getParserDescription() {
            return "A likelihood for continuous traits.";
        }

        @Override
        public Class getReturnType() {
            return ContinuousLikelihood.class;
        }

        @Override
        public XMLSyntaxRule[] getSyntaxRules() {
            return this.rules;
        }
    };
    private String[] traitNames = null;
    private Contrastable[] mles = null;
    private TreeModel treeModel = null;
    private ContinuousTraitLikelihood contTraitLikelihood = new ContinuousTraitLikelihood();

    public ContinuousLikelihood(TreeModel treeModel, String[] stringArray) {
        super(treeModel);
        this.treeModel = treeModel;
        this.traitNames = stringArray;
        this.mles = new Contrastable[stringArray.length];
    }

    @Override
    public double calculateLogLikelihood() {
        return this.contTraitLikelihood.calculateLikelihood(this.treeModel, this.traitNames, this.mles, 1.0);
    }
}

