/*
 * Decompiled with CFR 0.152.
 */
package org.ohdsi.circe.check.checkers;

import java.util.Arrays;
import java.util.Objects;
import org.ohdsi.circe.check.checkers.BaseCheck;
import org.ohdsi.circe.check.checkers.BaseCheckerFactory;
import org.ohdsi.circe.check.checkers.WarningReporter;
import org.ohdsi.circe.cohortdefinition.CohortExpression;
import org.ohdsi.circe.cohortdefinition.CorelatedCriteria;
import org.ohdsi.circe.cohortdefinition.Criteria;
import org.ohdsi.circe.cohortdefinition.CriteriaGroup;
import org.ohdsi.circe.cohortdefinition.DemographicCriteria;
import org.ohdsi.circe.cohortdefinition.InclusionRule;
import org.ohdsi.circe.cohortdefinition.PrimaryCriteria;

public abstract class BaseValueCheck
extends BaseCheck {
    protected static final String INCLUSION_CRITERIA = "Inclusion criteria ";
    protected static final String PRIMARY_CRITERIA = "Primary criteria";
    protected static final String ADDITIONAL_CRITERIA = "Additional criteria";
    protected static final String CENSORING_CRITERIA = "Censoring events";

    @Override
    protected void check(CohortExpression expression, WarningReporter reporter) {
        this.checkPrimaryCriteria(expression.primaryCriteria, reporter);
        this.checkAdditionalCriteria(expression.additionalCriteria, reporter);
        this.checkInclusionRules(expression, reporter);
        this.checkCensoringCriteria(expression, reporter);
    }

    protected void checkPrimaryCriteria(PrimaryCriteria primaryCriteria, WarningReporter reporter) {
        if (Objects.nonNull(primaryCriteria)) {
            Arrays.stream(primaryCriteria.criteriaList).forEach(criteria -> this.checkCriteria((Criteria)criteria, reporter, PRIMARY_CRITERIA));
        }
    }

    protected void checkAdditionalCriteria(CriteriaGroup criteriaGroup, WarningReporter reporter) {
        if (Objects.nonNull(criteriaGroup)) {
            Arrays.stream(criteriaGroup.criteriaList).forEach(criteria -> this.checkCriteria((CorelatedCriteria)criteria, reporter, ADDITIONAL_CRITERIA));
            Arrays.stream(criteriaGroup.demographicCriteriaList).forEach(criteria -> this.checkCriteria((DemographicCriteria)criteria, reporter, ADDITIONAL_CRITERIA));
            Arrays.stream(criteriaGroup.groups).forEach(criteria -> this.checkAdditionalCriteria((CriteriaGroup)criteria, reporter));
        }
    }

    protected void checkCensoringCriteria(CohortExpression expression, WarningReporter reporter) {
        if (Objects.nonNull(expression.censoringCriteria)) {
            Arrays.stream(expression.censoringCriteria).forEach(criteria -> this.checkCriteria((Criteria)criteria, reporter, CENSORING_CRITERIA));
        }
    }

    protected void checkInclusionRules(CohortExpression expression, WarningReporter reporter) {
        for (InclusionRule rule : expression.inclusionRules) {
            if (!Objects.nonNull(rule.expression)) continue;
            for (CorelatedCriteria corelatedCriteria : rule.expression.criteriaList) {
                this.checkCriteria(corelatedCriteria, reporter, "Inclusion criteria \"" + rule.name + "\"");
            }
            for (DemographicCriteria demographicCriteria : rule.expression.demographicCriteriaList) {
                this.checkCriteria(demographicCriteria, reporter, "Inclusion criteria \"" + rule.name + "\"");
            }
        }
    }

    protected void checkCriteria(CorelatedCriteria criteria, WarningReporter reporter, String name) {
        if (Objects.nonNull(criteria.criteria)) {
            this.checkCriteria(criteria.criteria, reporter, name);
        }
    }

    protected void checkCriteria(CriteriaGroup criteriaGroup, WarningReporter reporter, String name) {
        for (DemographicCriteria demographicCriteria : criteriaGroup.demographicCriteriaList) {
            this.checkCriteria(demographicCriteria, reporter, name);
        }
        for (CorelatedCriteria corelatedCriteria : criteriaGroup.criteriaList) {
            this.checkCriteria(corelatedCriteria, reporter, name);
        }
        for (CriteriaGroup criteriaGroup2 : criteriaGroup.groups) {
            this.checkCriteria(criteriaGroup2, reporter, name);
        }
    }

    protected void checkCriteria(DemographicCriteria criteria, WarningReporter reporter, String name) {
        this.getFactory(reporter, name).check(criteria);
    }

    protected void checkCriteria(Criteria criteria, WarningReporter reporter, String name) {
        if (Objects.nonNull(criteria.CorrelatedCriteria)) {
            this.checkCriteria(criteria.CorrelatedCriteria, reporter, name);
        }
        this.getFactory(reporter, name).check(criteria);
    }

    protected abstract BaseCheckerFactory getFactory(WarningReporter var1, String var2);
}

