## ----include = FALSE----------------------------------------------------------
knitr::opts_chunk$set(
  collapse = TRUE,
  comment = "#>"
)

## ----setup--------------------------------------------------------------------
library(SoilTaxonomy)

## -----------------------------------------------------------------------------
taxon_to_taxon_code("gelisols")

## -----------------------------------------------------------------------------
taxon_to_taxon_code("histels")

## -----------------------------------------------------------------------------
taxon_to_taxon_code("glacistels")

## -----------------------------------------------------------------------------
taxon_to_taxon_code("typic glacistels")

## -----------------------------------------------------------------------------
taxon_to_taxon_code("typic haploxerolls")

## -----------------------------------------------------------------------------
taxon_code_to_taxon(c("AABA", "AABB", "AABC"))

## -----------------------------------------------------------------------------
taxon_to_level(c("Hemic Glacistels","Sapric Glacistels","Typic Glacistels"))

## -----------------------------------------------------------------------------
taxon_to_level("Fine, mixed, semiactive, mesic Ultic Haploxeralfs")

## -----------------------------------------------------------------------------
getTaxonAtLevel("Fine, mixed, semiactive, mesic Ultic Haploxeralfs", level = "greatgroup")

## -----------------------------------------------------------------------------
getTaxonAtLevel("Folists", level = "subgroup")

## -----------------------------------------------------------------------------
getParentTaxa("Fine, mixed, semiactive, mesic Ultic Haploxeralfs")

## -----------------------------------------------------------------------------
getParentTaxa(code = "BAB")

## -----------------------------------------------------------------------------
getParentTaxa(code = c("BAA","BAB"), convert = FALSE)

## -----------------------------------------------------------------------------
decompose_taxon_code(c("BAA","BAB"))

## -----------------------------------------------------------------------------
preceding_taxon_codes("ABC")

## -----------------------------------------------------------------------------
relative_taxon_code_position(c("A","AA","AAA","AAAA",
                               "AB","AAB","ABA","ABC",
                               "B","BA","BAA","BAB",
                               "BBA","BBB","BBC"))

