/*
 * Decompiled with CFR 0.152.
 */
package dr.inference.operators;

import dr.inference.model.BoundedSpace;
import dr.inference.model.Parameter;
import dr.inference.operators.AbstractAdaptableOperator;
import dr.inference.operators.RandomWalkOperator;
import dr.inference.operators.hmc.HamiltonianMonteCarloOperator;
import dr.math.distributions.MultivariateNormalDistribution;
import dr.math.matrixAlgebra.CholeskyDecomposition;
import java.util.ArrayList;
import jebl.math.Random;
import org.ejml.data.DenseMatrix64F;

public class ConvexSpaceRandomWalkOperator
extends AbstractAdaptableOperator {
    private static final boolean DEBUG = true;
    private static final double corDeflator = 0.01;
    private final ArrayList<double[]> sampleList = new ArrayList();
    private double window;
    private final BoundedSpace space;
    private final Parameter parameter;
    private final Parameter updateIndex;
    private final boolean ADAPTIVE_COVARIANCE = true;
    private final int burnin = 50;
    private double[] mean;
    private double[] oldMean;
    private final DenseMatrix64F cov;
    private final int dim;
    private final int varDim;
    private int iterations = 0;
    private int updates = 0;
    private int every = 10;
    private final ArrayList<Integer> varInds = new ArrayList();
    private double[][] cholesky;
    public static final String CONVEX_RW = "convexSpaceRandomWalkOperator";
    public static final String WINDOW_SIZE = "relativeWindowSize";

    public ConvexSpaceRandomWalkOperator(Parameter parameter, BoundedSpace boundedSpace, Parameter parameter2, double d, double d2) {
        int n;
        this.setWeight(d2);
        this.updateIndex = parameter2;
        this.parameter = parameter;
        this.space = boundedSpace;
        this.window = d;
        this.dim = parameter.getDimension();
        for (n = 0; n < this.dim; ++n) {
            if (parameter2 != null && parameter2.getParameterValue(n) != 1.0) continue;
            this.varInds.add(n);
        }
        this.varDim = this.varInds.size();
        this.cov = new DenseMatrix64F(this.varDim, this.varDim);
        for (n = 0; n < this.varDim; ++n) {
            this.cov.set(n, n, 1.0);
        }
        this.cholesky = CholeskyDecomposition.execute(this.cov.getData(), 0, this.varDim);
    }

    @Override
    public double doOperation() {
        BoundedSpace.IntersectionDistances intersectionDistances;
        int n;
        int n2;
        Object object;
        int n3;
        ++this.iterations;
        double[] dArray = this.parameter.getParameterValues();
        double[] dArray2 = new double[this.varDim];
        for (n3 = 0; n3 < this.varDim; ++n3) {
            dArray2[n3] = dArray[this.varInds.get(n3)];
        }
        if (this.iterations == 50) {
            this.sampleList.add(dArray2);
            this.mean = dArray2;
            ++this.updates;
        } else if (this.iterations > 50 && this.iterations % this.every == 0) {
            int n4;
            int n5;
            int n6;
            this.sampleList.add(dArray2);
            ++this.updates;
            this.oldMean = this.mean;
            for (n3 = 0; n3 < this.varDim; ++n3) {
                this.mean[n3] = ((double)(this.updates - 1) * this.oldMean[n3] + dArray2[n3]) / (double)this.updates;
            }
            for (n3 = 0; n3 < this.varDim; ++n3) {
                for (n6 = n3; n6 < this.varDim; ++n6) {
                    double d = (double)(this.updates - 1) * (this.cov.get(n3, n6) + this.oldMean[n3] * this.oldMean[n6]);
                    d += dArray2[n3] * dArray2[n6] - this.mean[n3] * this.mean[n6];
                    this.cov.set(n3, n6, d /= (double)this.updates);
                    this.cov.set(n6, n3, d);
                }
            }
            DenseMatrix64F denseMatrix64F = new DenseMatrix64F(this.varDim, this.varDim);
            for (n6 = 0; n6 < this.varDim; ++n6) {
                for (int i = 0; i < this.varDim; ++i) {
                    denseMatrix64F.set(n6, i, this.cov.get(n6, i) / Math.sqrt(this.cov.get(n6, n6) * this.cov.get(i, i)));
                    if (n6 != i) continue;
                    denseMatrix64F.set(n6, i, denseMatrix64F.get(n6, i) + 0.01);
                }
            }
            object = new DenseMatrix64F(this.varDim, this.varDim);
            double[] dArray3 = new double[this.varDim];
            for (n5 = 0; n5 < this.updates; ++n5) {
                double[] dArray4 = this.sampleList.get(n5);
                for (n4 = 0; n4 < this.varDim; ++n4) {
                    int n7 = n4;
                    dArray3[n7] = dArray3[n7] + dArray4[n4];
                    ((DenseMatrix64F)object).set(n4, n4, ((DenseMatrix64F)object).get(n4, n4) + dArray4[n4] * dArray4[n4]);
                    for (n2 = n4 + 1; n2 < this.varDim; ++n2) {
                        ((DenseMatrix64F)object).set(n4, n2, ((DenseMatrix64F)object).get(n4, n2) + dArray4[n4] * dArray4[n2]);
                    }
                }
            }
            n5 = 0;
            while (n5 < this.varDim) {
                int n8 = n5++;
                dArray3[n8] = dArray3[n8] / (double)this.updates;
            }
            for (n5 = 0; n5 < this.varDim; ++n5) {
                ((DenseMatrix64F)object).set(n5, n5, ((DenseMatrix64F)object).get(n5, n5) / (double)this.updates - dArray3[n5] * dArray3[n5]);
                for (int i = n5 + 1; i < this.varDim; ++i) {
                    ((DenseMatrix64F)object).set(n5, i, ((DenseMatrix64F)object).get(n5, i) / (double)this.updates - dArray3[n5] * dArray3[i]);
                    ((DenseMatrix64F)object).set(i, n5, ((DenseMatrix64F)object).get(n5, i));
                }
            }
            DenseMatrix64F denseMatrix64F2 = new DenseMatrix64F(this.varDim, this.varDim);
            for (n = 0; n < this.varDim; ++n) {
                for (n4 = 0; n4 < this.varDim; ++n4) {
                    denseMatrix64F2.set(n, n4, ((DenseMatrix64F)object).get(n, n4) / Math.sqrt(((DenseMatrix64F)object).get(n, n) * ((DenseMatrix64F)object).get(n4, n4)));
                    if (n != n4) continue;
                    denseMatrix64F2.set(n, n4, denseMatrix64F2.get(n, n4) + 0.01);
                }
            }
            System.arraycopy(denseMatrix64F2.data, 0, denseMatrix64F.data, 0, denseMatrix64F.data.length);
            this.cholesky = CholeskyDecomposition.execute(denseMatrix64F.getData(), 0, this.varDim);
        }
        double[] dArray5 = new double[dArray.length];
        object = MultivariateNormalDistribution.nextMultivariateNormalCholesky(new double[this.varDim], this.cholesky);
        double d = 0.0;
        for (n = 0; n < this.varDim; ++n) {
            d += object[n] * object[n];
        }
        double d2 = Math.sqrt(d);
        for (n2 = 0; n2 < this.varDim; ++n2) {
            object[n2] = object[n2] / d2;
        }
        for (n2 = 0; n2 < this.varDim; ++n2) {
            dArray5[this.varInds.get((int)n2).intValue()] = object[n2];
        }
        try {
            intersectionDistances = this.space.distancesToBoundary(dArray, dArray5, false);
        }
        catch (HamiltonianMonteCarloOperator.NumericInstabilityException numericInstabilityException) {
            throw new RuntimeException("position outside of bounded space at beginning of operator move");
        }
        double d3 = this.window * Random.nextDouble();
        d3 = RandomWalkOperator.reflectValue(d3, -intersectionDistances.backwardDistance, intersectionDistances.forwardDistance);
        for (int i = 0; i < dArray.length; ++i) {
            dArray5[i] = dArray[i] - dArray5[i] * d3;
        }
        this.parameter.setAllParameterValuesQuietly(dArray5);
        this.parameter.fireParameterChangedEvent();
        return 0.0;
    }

    @Override
    protected void setAdaptableParameterValue(double d) {
        if (d > 0.0) {
            d = 0.0;
        }
        this.window = Math.exp(d);
    }

    @Override
    protected double getAdaptableParameterValue() {
        return Math.log(this.window);
    }

    @Override
    public double getRawParameter() {
        return this.window;
    }

    @Override
    public String getAdaptableParameterName() {
        return WINDOW_SIZE;
    }

    @Override
    public String getOperatorName() {
        return CONVEX_RW;
    }

    @Override
    public Parameter getParameter() {
        return this.parameter;
    }
}

